package com.adobe.xfa;
/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2009 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */

import org.xml.sax.Attributes;

import com.adobe.xfa.Model.DualDomModel;


/**
 * Represents the XML peer of a Model or Packet element.
 * 
 * @exclude from published api.
 */
public class ModelPeer extends Element {
	
	public ModelPeer(
			Element parent, Node prevSibling, 
			String uri, String localName, String qName,
			Attributes attributes,
			Element xfaPeer) {
		super(parent, prevSibling, uri, localName, qName, attributes, XFA.INVALID_ELEMENT, "");
		setModel(xfaPeer.getModel());
		setDocument(xfaPeer.getOwnerDocument());
		setXfaPeer(xfaPeer);
	}

	
	/**
	 * Gets this element's first XML child.
	 * @return the first XML child.
	 */
	public Node getFirstXMLChild() {
		if (getXfaPeer() instanceof DualDomModel) {
			return mFirstXMLChild;	
		}
		else {
			return getXfaPeer().getFirstXMLChild();
		}
	}
}
