/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2005 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */
package com.adobe.xfa;


/**
 * @exclude from public api.
 */
public class ScriptDispatcher extends Dispatcher {
	private final String msContentType; // language, eg. formcalc

	private final String msScript; // the script to execute
	
	// ScriptDispatcher class

	public ScriptDispatcher(Element poScriptContextNode, String sEventContext,
			int nEventID, EventManager poEventManager, String sScript,
			String sContentType) {

		super(poScriptContextNode, sEventContext, nEventID, poEventManager);
		msScript = sScript;
		msContentType = sContentType;
	}

	public void dispatch() {
		getActionContextNode().evaluate(msScript, msContentType, ScriptHandler.UNSPECIFIED, true);
	}

	public String getContentType() {
		return msContentType;
	}

	public String getDispatcherType() {
		return "script";
	}

	public String getParameter(int nParam) {
		if (nParam == 0)
			return getContentType();
		else if (nParam == 1)
			return getScript();

		return "";
	}

	public String getScript() {
		return msScript;
	}
	
}