/*************************************************************************
 *
 *	File: QRCodeEncoderException.java
 *
 **************************************************************************
 * 
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.xfa.pmp.qrcodepmp;

import com.adobe.xfa.pmp.common.BarcodeEncoderException;

/**
 * Exception class for QRCode Barcode
 */
public class QRCodeEncoderException extends BarcodeEncoderException {
	private static final long serialVersionUID = -4131746686261004133L;
	private QRCodeEncoderErrorCode errorCode;

	/**
	 * Creates an instance of QRCodeEncoderException
	 * 
	 * @param errorCode
	 *            error code
	 */
	public QRCodeEncoderException(QRCodeEncoderErrorCode errorCode) {
		this.errorCode = errorCode;
	}

	/**
	 * Gets the error code
	 * 
	 * @return error code
	 */
	public QRCodeEncoderErrorCode getErrorCode() {
		return errorCode;
	}

}
