/*************************************************************************
 *
 *	File: QRC.java
 *
 **************************************************************************
 * 
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.xfa.pmp.qrcodepmp.denso;

import com.adobe.xfa.pmp.common.IntegerHolder;


/**
 * Ported from qr.c, qr0.c, qr1.c, qr2.c, qr3.c, qr4.c, qr5.c
 */
public class QRC
{
	/*----------------------------------------------------------qr.h------------------------------------------------------------------------*/

	 /* Mode information */
	private static final int JOINT_MODE    =            3;                                                
	                                                    /* Concatenation mode */
	private static final int        NUMBER_MODE          =      1;
	private static final int        ALNUM_MODE               = 2;
	private static final int        BINARY_MODE               = 4;
	private static final int        KANJI_MODE              =  8;

	
	/* Mode characters:  numeric, alphanumeric, binary, Kanji */
	private static final int MAXCHARMODE     =   4;
	private static final int        NUMBER    =            0;
	private static final int        ALNUM      =          1;
	private static final int        BINARY      =          2;
	private static final int        KANJI        =        3;

	/* Version information */
	private static final int        MAXVER      =          40;
	private static final int        MAXVER1      =          14;
	private static final int        MAXVER2       =         40;
	private static final int TTLENOFST      =  0;
	private static final int NDATAOFST      =  1;
	private static final int DIVIDOFST      =  5;

	/* QR model number */
	//private static final int MAXMODEL               = 2;
	private static final int MODEL1                  =      0;
	public static final int MODEL2                   =     1;
	
	/* Mask pattern number for each model */
	private static final int PATTERN12             =   8 ;               
	/* No. of mask pattern for model 1 and 2 */ 

	/* Version threshold for QR model 2 */
	private static final int CVER_ALP     =   1   ;             
	            /* Ver2(2-1=1) or more: Add alignment pattern */
	private static final int CVER_VINFO    =    6  ;              
	            /* Ver7(7-1=6) or more: Add version information */

	
	/* Version No. to switch the bit number for representing character length */
	private static final int VERSIONLO       = 9;
	private static final int VERSIONMI       = 26;
	private static final int        SMAX      =  181;                                        
	                            /* Max No. of cells per side */
	private static final int CMAX      =  3808;                               
	                            /* Max. total amount */
	private static final int AMAX       = 256;                                        
	                            /* Order of Galois field */
	private static final int EMAX       = 68;                                        
	                            /* Max. RS code length to be added */
	private static final int HMAX       = 254;                                       
	                            /* Code length for RS calculation */
	private static final int MAXCOEF     =   31;                                        
	                            /* Set No. of coefficient, microQR added coef2,5,6,8,10,14 */
	private static final int BLKMAX =2000;                                        
	                            /* Max. No. of  modes for Mixed mode */
	private static final int DATAMAX =7366;                               
	                            /* Max. No. of printed data characters */

	//private static final int MODEINF =5;                                        
	 /* Amount of the information except for data */
	
	static private class qrdata {							/* QR Code information */
		public char bmode;					/* Mode information */
		public int blen;						/* Number of data characters */
		public char[] fdatap;					/* Data pointer */
		public int fdatapi = 0;
};

 private void blkcell(int x, int y){ cell[y][(x)/8]|=bitpos[(x)&0x07];}
 private void witcell(int x,int y) {cell[y][(x)/8]&=(~bitpos[(x)&0x07]);}
 //private int tstcell(int x,int y) {return (cell[y][(x)/8]&bitpos[(x)&0x07]);}

 //private void mblkcell(int x,int y) {mcell[y][(x)/8]|=bitpos[(x)&0x07];}
 //private void mwitcell(int x,int y) {mcell[y][(x)/8]&=(~bitpos[(x)&0x07]);}
 public int mtstcell(int x,int y) {return (mcell[y][(x)>>3]&bitpos[(x)&0x07]);}

 private void iwitcell(int x,int y) {icell[y][(x)>>3]&=(~bitpos[(x)&0x07]);}
 private int itstcell(int x,int y) {return icell[y][(x)/8]&bitpos[(x)&0x07];}

 
 /*-------------------------------------------------------qr0.c------------------------------------------------------------------------------------------------*/
 private IntegerHolder	Jmode = new IntegerHolder(0);								/* <>0  Concatenation mode */
 private IntegerHolder	joint_data = new IntegerHolder(0);							
										/* No. of divisions (Concatenation information) */
 private IntegerHolder parity = new IntegerHolder(0);								/* Parity data */
public int		modelNo;							/* QR code model No. */
//private int		input_mode;

//private char    []cdp;								
//private int cdpi = 0;										/* Data pointer (Character) */
//private char    []fdp;								
//private int fdpi = 0;										/* Data pointer (File) */

public char[] cdata = new char[DATAMAX+1];	                    
										/* Printed data file buffer */
public qrdata[] qdata = new qrdata[BLKMAX];
{
	for(int j=0;j<BLKMAX;j++)
	{
		qdata[j] = new qrdata();
	}
}
//private qrdata[] pqr;
//private int pqri = 0;


 /*-------------------------------------------------------qr1.c------------------------------------------------------------------------------------------------*/
private static final int DPATTERN = 60433;			/* Dummy pattern */
/*--------------------------------------------------------------------------
----------------------------------------------------------------------------*/

private char[]	Ccode = new char[CMAX];
private char[]	iCcode = new char[CMAX];	
						/* For interleave data  (for debug) */
//private int		Cmod;			
public int /* Character mode: N/A/B/K = 0/1/2/3 */
Clvl;
private int /* Error level: L/M/Q/H = 0/1/2/3 */
Clen;
private int /* Error level: L/M/Q/H = 0/1/2/3 */ Cver;
public int 
Csize;
						/* No. of cells per side = (Cver+1)*4+17 */
private int		Selmsk = -1;			
						

private int		vinfoTOTAL,		
						/* Total codeword No. of defined version */
		vinfoNDATA,		
						/* Data amount of defined version and error correction level */
		vinfoDIVID;		
						/* Divided No. of defined version and error correction level */ 

/* Model 1 and 2: No. of bits for character number indicator	 Num Alf Bin Knj */

private static final char nch_indicate[][] = {
	{10,  9,  8,  8},	/* Version 9 or smaller */
	{12, 11, 16, 10},	/* Version 10 to 26 */
	{14, 13, 16, 12}};	/* Version 27 or larger */


/*	Total amount   No. of data characters   No. of divisions   Version */
/*					 L    M    Q    H   L  M  Q  H	   			*/
private static final int vinfo[][][] = {
		{	{  26, 	18,  15,  12,   8,  1, 1, 1, 1},	/*  1 */
			{  46, 	35,  29,  23,  15,  1, 1, 1, 1},	/*  2 */
			{  72, 	56,  43,  35,  23,  1, 1, 1, 1},	/*  3 */
			{ 100, 	79,  59,  49,  33,  1, 1, 1, 1},	/*  4 */
			{ 134, 107,  81,  67,  45,  1, 1, 1, 2},	/*  5 */
			{ 170, 135, 105,  85,  57,  1, 2, 2, 2},	/*  6 */
			{ 212, 169, 131, 107,  71,  1, 2, 2, 3},	/*  7 */
			{ 256, 207, 159, 127,  86,  2, 2, 2, 3},	/*  8 */
			{ 306, 245, 185, 155, 101,  2, 2, 3, 3},	/*  9 */
			{ 358, 289, 221, 182, 123,  2, 2, 3, 4},	/* 10 */
			{ 416, 335, 255, 207, 144,  2, 4, 4, 5},	/* 11 */
			{ 476, 383, 291, 243, 164,  2, 4, 4, 5},	/* 12 */
			{ 542, 431, 331, 275, 191,  3, 4, 4, 6},	/* 13 */
			{ 610, 488, 367, 309, 209,  3, 4, 5, 6},	/* 14 Model1 Max Version*/
			{ 684, 551, 411, 347, 230,  3, 4, 6, 7},	/* 15 */
			{ 760, 608, 459, 383, 263,  3, 5, 6, 8},	/* 16 */
			{ 842, 671, 509, 419, 296,  4, 5, 7, 9},	/* 17 */
			{ 926, 739, 563, 471, 319,  4, 6, 8,10},	/* 18 */
			{1016, 815, 617, 509, 351,  4, 6,10,11},	/* 19 */
			{1108, 884, 671, 549, 383,  5, 7,11,12},	/* 20 */
			{1206, 964, 727, 599, 407,  5, 7,12,12},	/* 21 */
			{1306,1049, 791, 649, 441,  6, 8,13,13},	/* 22 */
			{1412,1133, 863, 701, 479,  6, 9,13,15},	/* 23 */
			{1520,1217, 919, 764, 524,  6,10,15,15},	/* 24 */
			{1634,1308, 989, 831, 543,  7,10,16,16},	/* 25 */
			{1750,1399,1088, 881, 593,  7,11,18,18},	/* 26 */
			{1872,1503,1121, 935, 647,  8,11,18,18},	/* 27 */
			{1996,1607,1223,1006, 692,  8,12,19,21},	/* 28 */
			{2126,1709,1286,1079, 734,  9,13,20,21},	/* 29 */
			{2258,1799,1357,1149, 781,  9,14,23,23},	/* 30 */
			{2396,1929,1441,1195, 827, 10,14,23,23},	/* 31 */
			{2536,2029,1567,1287, 863, 10,16,23,32},	/* 32 */
			{2682,2147,1673,1374, 909, 12,18,25,26},	/* 33 */
			{2830,2267,1745,1427, 979, 14,18,28,28},	/* 34 */
			{2984,2399,1842,1487, 991, 12,19,31,31},	/* 35 */
			{3140,2508,1939,1599,1087, 13,20,32,32},	/* 36 */
			{3302,2651,2036,1649,1121, 13,21,33,33},	/* 37 */
			{3466,2785,2120,1748,1154, 14,21,33,35},	/* 38 */
			{3636,2909,2253,1835,1259, 15,23,36,36},	/* 39 */
			{3808,3071,2299,1899,1291, 16,25,38,38}		/* 40 */
		}, {	/* Model 2 */
			{  26,  19,  16,  13,   9,  1, 1, 1, 1},	/*  1 */
			{  44,  34,  28,  22,  16,  1, 1, 1, 1},	/*  2 */
			{  70,  55,  44,  34,  26,  1, 1, 2, 2},	/*  3 */
			{ 100,  80,  64,  48,  36,  1, 2, 2, 4},	/*  4 */
			{ 134, 108,  86,  62,  46,  1, 2, 4, 4},	/*  5 */
			{ 172, 136, 108,  76,  60,  2, 4, 4, 4},	/*  6 */
			{ 196, 156, 124,  88,  66,  2, 4, 6, 5},	/*  7 */
			{ 242, 194, 154, 110,  86,  2, 4, 6, 6},	/*  8 */
			{ 292, 232, 182, 132, 100,  2, 5, 8, 8},	/*  9 */
			{ 346, 274, 216, 154, 122,  4, 5, 8, 8},	/* 10 */
			{ 404, 324, 254, 180, 140,  4, 5, 8,11},	/* 11 */
			{ 466, 370, 290, 206, 158,  4, 8,10,11},	/* 12 */
			{ 532, 428, 334, 244, 180,  4, 9,12,16},	/* 13 */
			{ 581, 461, 365, 261, 197,  4, 9,16,16},	/* 14 */
			{ 655, 523, 415, 295, 223,  6,10,12,18},	/* 15 */
			{ 733, 589, 453, 325, 253,  6,10,17,16},	/* 16 */
			{ 815, 647, 507, 367, 283,  6,11,16,19},	/* 17 */
			{ 901, 721, 563, 397, 313,  6,13,18,21},	/* 18 */
			{ 991, 795, 627, 445, 341,  7,14,21,25},	/* 19 */
			{1085, 861, 669, 485, 385,  8,16,20,25},	/* 20 */
			{1156, 932, 714, 512, 406,  8,17,23,25},	/* 21 */
			{1258,1006, 782, 568, 442,  9,17,23,34},	/* 22 */
			{1364,1094, 860, 614, 464,  9,18,25,30},	/* 23 */
			{1474,1174, 914, 664, 514, 10,20,27,32},	/* 24 */
			{1588,1276,1000, 718, 538, 12,21,29,35},	/* 25 */
			{1706,1370,1062, 754, 596, 12,23,34,37},	/* 26 */
			{1828,1468,1128, 808, 628, 12,25,34,40},	/* 27 */
			{1921,1531,1193, 871, 661, 13,26,35,42},	/* 28 */
			{2051,1631,1267, 911, 701, 14,28,38,45},	/* 29 */
			{2185,1735,1373, 985, 745, 15,29,40,48},	/* 30 */
			{2323,1843,1455,1033, 793, 16,31,43,51},	/* 31 */
			{2465,1955,1541,1115, 845, 17,33,45,54},	/* 32 */
			{2611,2071,1631,1171, 901, 18,35,48,57},	/* 33 */
			{2761,2191,1725,1231, 961, 19,37,51,60},	/* 34 */
			{2876,2306,1812,1286, 986, 19,38,53,63},	/* 35 */
			{3034,2434,1914,1354,1054, 20,40,56,66},	/* 36 */
			{3196,2566,1992,1426,1096, 21,43,59,70},	/* 37 */
			{3362,2702,2102,1502,1142, 22,45,62,74},	/* 38 */
			{3532,2812,2216,1582,1222, 24,47,65,77},	/* 39 */
			{3706,2956,2334,1666,1276, 25,49,68,81}		/* 40 */
		}
	};

private static final int numrem[]= new int[]{0,4,7};		
              /* Required bit number for remainder when the numeric digit number is divided by 3 */
private int Blksu;						/* No. of data blocks */


/* Get version No. of Model 1 and 2 */
private int
getversion12(int blksu, qrdata []p, int level)
{
	int pi = 0;
	int i, nbit = 0, nch;
	int mode, length, maxVer = 0;

	switch(modelNo) {
	case MODEL1:
		nbit = 0;			
							/* Exclude initial mode information bit */
		maxVer = MAXVER1;
		break;
	case MODEL2:
		nbit = 4;			/* Add mode information bit */
		maxVer = MAXVER2;
		break;
	}
	if (Jmode.getValue() != 0) {			/* Concatenation mode */
		nbit += 20;			
						
	}
	for (i = 0; i < blksu; i++){
		mode = p[pi].bmode;
		length = p[pi].blen;
		switch(mode) {
			case NUMBER:
				nbit += (length/3)*10+numrem[length%3];
				break;
			case ALNUM:
				nbit += (length/2)*11+(length%2)*6;
				break;
			case BINARY:
				nbit += length*8;
				break;
			case KANJI:
				nbit += ((length+1)/2)*13;
				break;
		}
		nbit += nch_indicate[0][mode];		/* Version 9 or smaller */
		pi++;
	}
	
	nbit += (blksu - 1) * 4;		/* Add mode information bits */
	if (nbit/8 > vinfo[modelNo][VERSIONLO-1][level+NDATAOFST]){	
																/* Version 10 or larger */
		pi -= blksu;
		for (i = 0; i < blksu; i++){
			mode = p[pi++].bmode;
			nbit += (nch_indicate[1][mode] - nch_indicate[0][mode]);
		}
		if (nbit/8 > vinfo[modelNo][VERSIONMI-1][level+NDATAOFST]){	
																	/* Version 27 or larger */
			pi -= blksu;
			for (i = 0; i < blksu; i++){
				mode = p[pi++].bmode;
				nbit += (nch_indicate[2][mode] - nch_indicate[1][mode]);
			}
		}
	}
	nch	 = (nbit+7)/8;
	for (i = 0; i < maxVer; i++) {					
													/* Version is finally decided */
		if (nch <= vinfo[modelNo][i][level+NDATAOFST]) break;
	}
	if (i >= maxVer || nch > vinfo[modelNo][maxVer-1][level+NDATAOFST]) {
		/* printf(stderr, "err1 !!\n"); */
		return(-1);							/* error return */
	}
	return i;
}


/* Get bit No. of mode information indicator */
private int
getModeBitLen(int ver)
{
	int j = 0;

	switch(modelNo) {
	case MODEL1:
	case MODEL2:
		j = 4;						
                                    /* Mode bit number of model 1 and 2 */
		break;
	}
	return j;
}

/* Get mode data indicator */
private int
getModeBitData(int mode)
{
	int j = 0;
	
	int Model12_Mode[] = {NUMBER_MODE, ALNUM_MODE, BINARY_MODE, KANJI_MODE};
	
	switch(modelNo) {
	case MODEL1:
	case MODEL2:
		j = Model12_Mode[mode];				
                                            /* Bit No. of code mode for model 1 and 2 */
		break;
	}
	return j;
}


/* Get bit No. of character number indicator */ 
private int
getNumcharBitLen(int ver, int mode)
{
	int c3 = 0;

	switch(modelNo) {
	case MODEL1:
	case MODEL2:
		if (ver <= VERSIONLO-1) {
			c3 = nch_indicate[0][mode];		/* Version 9 or less */
		} else {
			if (ver <= VERSIONMI-1)
				c3 = nch_indicate[1][mode];	/* Version 10 to 26 */
			else 
				c3 = nch_indicate[2][mode];	/* Version 27 or larger */
		}
		break;
	}
	return c3;
}


/* Convert numeric/alphanumeric characters to binary */

private static final char bcwtbl[] = {
		/* space !	"  #  $	 %  &  '  (  )  *  +  ,  -  .  /	*/
		     36, 0, 0, 0,37,38, 0, 0, 0, 0,39,40, 0,41,42,43,
		/* 	  0	 1	2  3  4  5  6  7  8  9  :  ;  <  =  >  ?	*/
			  0, 1, 2, 3, 4, 5, 6, 7, 8, 9,44, 0, 0, 0, 0, 0,
		/* 	  @  a	b  c  d  e  f  g  h  i  j  k  l  m  n  o	*/
			  0,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,
		/* 	  p  q  r  s  t  u  v  w  x  y  z					*/
			 25,26,27,28,29,30,31,32,33,34,35};


/* Convert numeric data to binary */
private int
convnum(char[] sdata, char[] bdata, int bdatai, IntegerHolder pos, int ver, int slen, int sdatai)	/* Return No. of bytes after conversion */
{
	//int sdatai = 0;
	long i;
	int j,len;
	int c3, c4;

	len = 0;
	i = bdata[bdatai];
	j = getModeBitLen(ver);
	if (pos.getValue() < j) {
		i = (i << (j - pos.getValue())) | getModeBitData(NUMBER);		/* Numeric mode */
		c4 = 8 + (j - pos.getValue());
	}
	else {
		i = (i >> (pos.getValue() - j)) | getModeBitData(NUMBER);		/* Numeric mode */
		c4 = 8 - (pos.getValue() - j);
	}

	c3 = getNumcharBitLen(ver, NUMBER);
	i = (i << c3) | slen;		/* Character indicator */
	c3 += c4;
	while (c3 >= 8) {
		c3 -= 8;
		bdata[bdatai++] =  (char) (i >> c3);
		len++;
		i &= (~(-1 << c3));
	}

	for (j = 0; j < slen/3; j++) {
		i = (i << 10) + ((sdata[sdatai]-'0')*100 + (sdata[sdatai+1]-'0')*10 + sdata[sdatai+2]-'0');
		sdatai += 3;
		c3 += 10;
		while (c3 >= 8) {
			c3 -= 8;
			bdata[bdatai++] = (char) (i >> c3);
			len++;
			i &= (~(-1 << c3));
		}
	}

	if (slen%3 != 0) {				
									/* When No. of input characters is not a multiple of 3 */
		if ((slen%3) == 2) {			
										/* Two characters are left: 7 bits */
			i = (i << 7) + ((sdata[sdatai]-'0')*10 + ((sdata[sdatai+1])-'0'));
			c3 += 7;
		}
		else {							
										/* One character is left: 4 bits */
			i = (i << 4) + (sdata[sdatai]-'0');
			c3 += 4;
		}
	}
	while (c3 >= 8) {
		c3 -= 8;
		bdata[bdatai++] =  (char) (i >> c3);
		len++;
		i &= (~(-1 << c3));
	}
	if (c3 != 0){
		bdata[bdatai++] = (char) (i << (8 - c3));
	}
	pos.setValue(8 - c3);
	return len;
}


/* Convert alphanumeric data to binary */
private int
convalnum(char[] sdata, char[] bdata, int bdatai, IntegerHolder pos, int ver, int slen, int sdatai)		/* Return No. of bytes after conversion */
{
	//int sdatai = 0;
	long i;
	int j, len;
	int c1, c2, c3, c4;

	len = 0;
	i = bdata[bdatai];
	j = getModeBitLen(ver);
	if (pos.getValue() < j) {
		i = (i << (j - pos.getValue())) | getModeBitData(ALNUM);	/* Alphanumeric mode */
		c4 = 8 + (j - pos.getValue());
	}
	else {
		i = (i >> (pos.getValue() - j)) | getModeBitData(ALNUM);	/* Alphanumeric mode */
		c4 = 8 - (pos.getValue() - j);
	}

	c3 = getNumcharBitLen(ver, ALNUM);
	i = (i << c3) | slen;		/* Character indicator */
	c3 += c4;
	while (c3 >= 8) {
		c3 -= 8;
		bdata[bdatai++] =  (char) (i >> c3);
		len++;
		i &= (~(-1 << c3));
	}

	for (j = 0; j < slen/2; j++) {				/* Alphanumeric mode */
		c1 = bcwtbl[Character.toUpperCase(sdata[sdatai]) - ' '];		/* All character shall be uppercase */ 
		if ((c2 = (sdata[sdatai+1])) !=0)
			c2 = bcwtbl[Character.toUpperCase(c2) - ' '];
		i = (i << 11) + (c1*45 + c2);
		sdatai += 2;
		c3 += 11;
		while (c3 >= 8) {
			c3 -= 8;
			bdata[bdatai++] =  (char) (i >> c3);
			len++;
			i &= (~(-1 << c3));
		}
	}
	if (slen%2 != 0) {
		i = (i << 6) | bcwtbl[Character.toUpperCase(sdata[sdatai]) - ' '];
		c3 += 6;
	}
	while (c3 >= 8) {
		c3 -= 8;
		bdata[bdatai++] =  (char) (i >> c3);
		len++;
		i &= (~(-1 << c3));
	}
	if (c3 != 0){
		bdata[bdatai++] = (char) (i << (8 - c3));
	}
	pos.setValue(8 - c3);
	return len;
}

/* Convert binary data characters to binary */
private int
convbin(char[] sdata, char []bdata, int bdatai, IntegerHolder pos, int ver, int slen, int sdatai)			/* Return No. of bytes after conversion */
// uchar *sdata, *bdata, *pos;
// int ver, slen;
{
	//int sdatai = 0;
	long i;
	int len;
	int c3, c4;
	int j;

	len = 0;
	i = bdata[bdatai];
	j = getModeBitLen(ver);
	if (pos.getValue() < j) {
		i = (i << (j - pos.getValue())) | getModeBitData(BINARY);	/* Binary mode */
		c4 = 8 + (j - pos.getValue());
	}
	else {
		i = (i >> (pos.getValue() - j)) | getModeBitData(BINARY);	/* Binary mode */
		c4 = 8 - (pos.getValue() - j);
	}

	c3 = getNumcharBitLen(ver, BINARY);
	i = (i << c3) | slen;					/* Character indicator */
	c3 += c4;
	while (c3 >= 8) {
		c3 -= 8;
		bdata[bdatai++] = (char) (i >> c3);
		len++;
		i &= (~(-1 << c3));
	}

	for (j = 0; j < slen; j++) {
		i = (i << 8) + sdata[sdatai];
		sdatai++;
		c3 += 8;
		while (c3 >= 8) {
			c3 -= 8;
			bdata[bdatai++] = (char) (i >> c3);
			len++;
			i &= (~(-1 << c3));
		}
	}

	while (c3 >= 8) {
		c3 -= 8;
		bdata[bdatai++] =  (char) (i >> c3);
		len++;
		i &= (~(-1 << c3));
	}
	if (c3 != 0){
		bdata[bdatai++] =  (char) (i << (8 - c3));
	}
	pos.setValue(8 - c3);
	return len;
}


/* Convert Kanji data to binary */
private int
convknj(char[] sdata, char [] bdata, int bdatai, IntegerHolder pos, int ver, int slen, int sdatai)		/* Return No. of bytes after conversion */
{
	long i;
	int j, len;
	int c1, c3, c4;

	len = 0;
	i = bdata[bdatai];
	j = getModeBitLen(ver);
	if (pos.getValue() < j) {
		i = (i << (j - pos.getValue())) | getModeBitData(KANJI);		/* Kanji mode */
		c4 = 8 + (j - pos.getValue());
	}
	else {
		i = (i >> (pos.getValue() - j)) | getModeBitData(KANJI);		/* Kanji mode */
		c4 = 8 - (pos.getValue() - j);
	}

	c3 = getNumcharBitLen(ver, KANJI);
	i = (i << c3) | slen;			/* Character indicator */
	c3 += c4;
	while (c3 >= 8) {
		c3 -= 8;
		bdata[bdatai++] = (char) (i >> c3);
		len++;
		i &= (~(-1 << c3));
	}

	for (j = 0; j < slen; j++) {		/* Kanji mode */
		c1 = sdata[sdatai];
		if (c1 < 0xa0)
			c1 -= 0x81;
		else
			c1 -= 0xc1;
		i = (i << 13) + c1 * 0xc0 + (sdata[sdatai+1]) - 0x40;
		sdatai += 2;
		c3 += 13;
		while (c3 >= 8) {
			c3 -= 8;
			bdata[bdatai++] = (char) (i >> c3);
			len++;
			i &= (~(-1 << c3));
		}
	}
	if (c3 != 0){
		bdata[bdatai++] = (char) (i << (8 - c3));
	}
	pos.setValue(8 - c3);
	return len;
}

private int
conv2bin(int c, qrdata []pqr, char []bdata, int ver)		/* Return No. of bytes after conversion */
{
	int pqri =0;
	int i;
	int len = 0,slen;
	int mode;
	char[] sdata;
	IntegerHolder pos = new IntegerHolder(0);

/* Position of initial mode information */
	switch(modelNo) {
	case MODEL1:
		if (Jmode.getValue() != 0){				/* Concatenation mode */
			bdata[0] = JOINT_MODE;		
										/* Concatenation information set */
			bdata[1] = (char) joint_data.getValue();
			bdata[2] = (char) parity.getValue();	
			pos.setValue(8); len = 3;
		}else {
			bdata[0] = 0;
			pos.setValue(4); len = 0;
		}
		break;
	case MODEL2:
		if (Jmode.getValue() != 0){				/* Concatenation mode */
			bdata[0] = (char) ((JOINT_MODE<<4)+(joint_data.getValue()>>4));		
															/* Concatenation information set */
			bdata[1] = (char) (((joint_data.getValue()<<4) & 0xf0)+(parity.getValue()>>4));
			bdata[2] = (char) ((parity.getValue()<<4) & 0xf0);	
			pos.setValue(4); len = 2;
		}else {
			pos.setValue(8); len = 0;
		}
		break;
	}
	for (i = 0; i < c; i++) {		/* Convert data to binary code */
		mode = pqr[pqri].bmode;
		slen = pqr[pqri].blen;
		sdata = pqr[pqri].fdatap;
		int sdatai = pqr[pqri].fdatapi;
		switch(mode) {
			case NUMBER:			/* Numeric mode */
				len += convnum(sdata, bdata, len, pos, ver, slen, sdatai);
				break;
			case ALNUM:				/* Alphanumeric mode */
				len += convalnum(sdata, bdata, len, pos, ver, slen, sdatai);
				break;
			case BINARY:			/* Binary mode */
				len += convbin(sdata, bdata, len, pos, ver, slen, sdatai);	/* Premise that any null character string is not included */
				break;
			case KANJI:				/* Kanji mode */
				len += convknj(sdata, bdata, len, pos, ver, slen/2, sdatai);
				break;
		}
		pqri++;
	}

/* Terminator showing the end of data */
	switch(modelNo) {
	case MODEL1:
	case MODEL2:
		if (pos.getValue() < 4) {			
                        /* 4-bit is required for a terminator. When only 4 or less bits are left, */
			len++;				/* they are set to 0, and */
			bdata[len] = 0;	/* the subsequent 8-bit is set to 0 */
		} else if (pos.getValue() == 8) {
			bdata[len] = 0;	/* Current 8-bit is set to 0 */
		}
		len++;
		break;
	}

	return len;
}


private int CodeWordLen;				/* Total amount */

public int
qrcode(qrdata []pqr, int cVerFlag)					/* QR code */
{
	int i;
	char[] ucp;
	int ucpi = 0;

	ucp = Ccode;								
	for (i = 0; i < CMAX; i++) {
		ucp[ucpi++] = 0;
	}

	switch(modelNo) {		
                      /* Cver<0: Version has already been decided (automatic character mode) */ 
	case MODEL1:
	case MODEL2:
		if (Cver<0) Cver = getversion12(Blksu, pqr, Clvl);		
                                                         /* Decide code version of model 1 and 2 */
		if (cVerFlag != 0) {
			if (cVerFlag > Cver) Cver = cVerFlag - 1;
			else Cver = -1;	
                            /* The input character is not allowed for the designated version */
		}
		Csize = (Cver + 1) * 4 + 17;		/* No. of cells per side */
		break;
	}

	if (Cver>=0 && Cver<MAXVER) {
		vinfoTOTAL = vinfo[modelNo][Cver][TTLENOFST];	
                                                /* Total codeword for designated version */
		vinfoNDATA = vinfo[modelNo][Cver][Clvl+NDATAOFST];		
                                                /* Data amount for designated version and error correction level */
		vinfoDIVID = vinfo[modelNo][Cver][Clvl+DIVIDOFST];		
                                                /* Divided No. of designated version and error correction level */
	
		Clen = conv2bin(Blksu, pqr, Ccode, Cver);	/* Converted result + mode character */
		CodeWordLen = vinfoTOTAL;					/* Total amount */
		i = 8;
		while(Clen < vinfoNDATA+1) {				
                                              /* For model 2, additional one byte is required for RS */  
			Ccode[Clen++] = (char) ((DPATTERN >> i) & 255);
                                              /* Supplement the left bytes with DPATTERN */
			if (i > 0) i = 0;
			else i = 8;
		}
		
		
		add_correction_code();			
							/* Addition of Read-Solomon code */
		set_pattern();					/* Aligned in 2D cells */
		
		 
		estimate_pattern(Selmsk);		/* Masking */
	} else {
		Csize = 0;						/* Error: Failed in normal generation */
	}
	return Csize;
}

/*-------------------------------------------------------qr2.c------------------------------------------------------------------------------------------------*/


private char[]	dividend = new char[HMAX];				
									/* Dividend = Total amount/No. of divisions */
private int[]		divisor= new int[EMAX];				/* Divisor */
									/* Divided No. of defined version and error correction level */
private int			pinfoNDTDivid,			
									/* Model 2  Data length after divided  1st, 2nd=1st+1 */
			pinfoNRSDivid,			
									/* Model 2  RS length after divided */
			pinfoNDTItr1,			/* Model 2  No. of divisions 1st */
			pinfoNDTItr2;			/* Model 2  No. of divisions 2nd */



private static final char	alpha[] = {			/* Elements of GF (256) */
		0001, 0002, 0004, 0010, 0020, 0040, 0100, 0200,
		0035, 0072, 0164, 0350, 0315, 0207, 0023, 0046,
		0114, 0230, 0055, 0132, 0264, 0165, 0352, 0311,
		0217, 0003, 0006, 0014, 0030, 0060, 0140, 0300,
		0235, 0047, 0116, 0234, 0045, 0112, 0224, 0065,
		0152, 0324, 0265, 0167, 0356, 0301, 0237, 0043,
		0106, 0214, 0005, 0012, 0024, 0050, 0120, 0240,
		0135, 0272, 0151, 0322, 0271, 0157, 0336, 0241,
		0137, 0276, 0141, 0302, 0231, 0057, 0136, 0274,
		0145, 0312, 0211, 0017, 0036, 0074, 0170, 0360,
		0375, 0347, 0323, 0273, 0153, 0326, 0261, 0177,
		0376, 0341, 0337, 0243, 0133, 0266, 0161, 0342,
		0331, 0257, 0103, 0206, 0021, 0042, 0104, 0210,
		0015, 0032, 0064, 0150, 0320, 0275, 0147, 0316,
		0201, 0037, 0076, 0174, 0370, 0355, 0307, 0223,
		0073, 0166, 0354, 0305, 0227, 0063, 0146, 0314,
		0205, 0027, 0056, 0134, 0270, 0155, 0332, 0251,
		0117, 0236, 0041, 0102, 0204, 0025, 0052, 0124,
		0250, 0115, 0232, 0051, 0122, 0244, 0125, 0252,
		0111, 0222, 0071, 0162, 0344, 0325, 0267, 0163,
		0346, 0321, 0277, 0143, 0306, 0221, 0077, 0176,
		0374, 0345, 0327, 0263, 0173, 0366, 0361, 0377,
		0343, 0333, 0253, 0113, 0226, 0061, 0142, 0304,
		0225, 0067, 0156, 0334, 0245, 0127, 0256, 0101,
		0202, 0031, 0062, 0144, 0310, 0215, 0007, 0016,
		0034, 0070, 0160, 0340, 0335, 0247, 0123, 0246,
		0121, 0242, 0131, 0262, 0171, 0362, 0371, 0357,
		0303, 0233, 0053, 0126, 0254, 0105, 0212, 0011,
		0022, 0044, 0110, 0220, 0075, 0172, 0364, 0365,
		0367, 0363, 0373, 0353, 0313, 0213, 0013, 0026,
		0054, 0130, 0260, 0175, 0372, 0351, 0317, 0203,
		0033, 0066, 0154, 0330, 0255, 0107, 0216, 0001,
		0000
};
private static final short	trans[] = {			/* Positions of GF (256) elements */
		0400, 0000, 0001, 0031, 0002, 0062, 0032, 0306,
		0003, 0337, 0063, 0356, 0033, 0150, 0307, 0113,
		0004, 0144, 0340, 0016, 0064, 0215, 0357, 0201,
		0034, 0301, 0151, 0370, 0310, 0010, 0114, 0161,
		0005, 0212, 0145, 0057, 0341, 0044, 0017, 0041,
		0065, 0223, 0216, 0332, 0360, 0022, 0202, 0105,
		0035, 0265, 0302, 0175, 0152, 0047, 0371, 0271,
		0311, 0232, 0011, 0170, 0115, 0344, 0162, 0246,
		0006, 0277, 0213, 0142, 0146, 0335, 0060, 0375,
		0342, 0230, 0045, 0263, 0020, 0221, 0042, 0210,
		0066, 0320, 0224, 0316, 0217, 0226, 0333, 0275,
		0361, 0322, 0023, 0134, 0203, 0070, 0106, 0100,
		0036, 0102, 0266, 0243, 0303, 0110, 0176, 0156,
		0153, 0072, 0050, 0124, 0372, 0205, 0272, 0075,
		0312, 0136, 0233, 0237, 0012, 0025, 0171, 0053,
		0116, 0324, 0345, 0254, 0163, 0363, 0247, 0127,
		0007, 0160, 0300, 0367, 0214, 0200, 0143, 0015,
		0147, 0112, 0336, 0355, 0061, 0305, 0376, 0030,
		0343, 0245, 0231, 0167, 0046, 0270, 0264, 0174,
		0021, 0104, 0222, 0331, 0043, 0040, 0211, 0056,
		0067, 0077, 0321, 0133, 0225, 0274, 0317, 0315,
		0220, 0207, 0227, 0262, 0334, 0374, 0276, 0141,
		0362, 0126, 0323, 0253, 0024, 0052, 0135, 0236,
		0204, 0074, 0071, 0123, 0107, 0155, 0101, 0242,
		0037, 0055, 0103, 0330, 0267, 0173, 0244, 0166,
		0304, 0027, 0111, 0354, 0177, 0014, 0157, 0366,
		0154, 0241, 0073, 0122, 0051, 0235, 0125, 0252,
		0373, 0140, 0206, 0261, 0273, 0314, 0076, 0132,
		0313, 0131, 0137, 0260, 0234, 0251, 0240, 0121,
		0013, 0365, 0026, 0353, 0172, 0165, 0054, 0327,
		0117, 0256, 0325, 0351, 0346, 0347, 0255, 0350,
		0164, 0326, 0364, 0352, 0250, 0120, 0130, 0257
};

/* 68-degree of RS coefficient */
/*
2	25,1
3	198,199,3
4	75,249,78,6
5	113,164,166,119,10
6	166,0,134,5,176,15
7	87,229,146,149,238,102,21
8	175,238,208,249,215,252,196,28
9	95,246,137,231,235,149,11,123,36
10	251,67,46,61,118,70,64,94,32,45
11	220,192,91,194,172,177,209,116,227,10,55
12	102,43,98,121,187,113,198,143,131,87,157,66
13	74,152,176,100,86,100,106,104,130,218,206,140,78
14	199,249,155,48,190,124,218,137,216,87,207,59,22,91
15	8,183,61,91,202,37,51,58,58,237,140,124,5,99,105
16	120,104,107,109,102,161,76,3,91,191,147,169,182,194,225,120
17	43,139,206,78,43,239,123,206,214,147,24,99,150,39,243,163,136
18	215,234,158,94,184,97,118,170,79,187,152,148,252,179,5,98,96,153
19	67,3,105,153,52,90,83,17,150,159,44,128,153,133,252,222,138,220,171
20	17,60,79,50,61,163,26,187,202,180,221,225,83,239,156,164,212,212,188,190
21	240,233,104,247,181,140,67,98,85,200,210,115,148,137,230,36,122,254,148,175,210
22	210,171,247,242,93,230,14,109,221,53,200,74,8,172,98,80,219,134,160,105,165,231
23	171,102,146,91,49,103,65,17,193,150,14,25,183,248,94,164,224,192,1,78,56,147,253
24	229,121,135,48,211,117,251,126,159,180,169,152,192,226,228,218,111,0,117,232,87,96,227,2,
25	231,181,156,39,170,26,12,59,15,148,201,54,66,237,208,99,167,144,182,95,243,129,178,252,4,
26	173,125,158,2,103,182,118,17,145,201,111,28,165,53,161,21,245,142,13,102,48,227,153,145,18,70
27	79,228,8,165,227,21,180,29,9,237,70,99,45,58,138,135,73,126,172,94,216,193,157,26,17,14996
28	168,223,200,104,224,234,108,180,110,190,195,147,205,27,232,201,21,43,245,87,42,195,212,19,242,37,9,123
29	156,45,183,29,151,219,54,96,249,24,136,5,241,175,189,28,75,234,150,148,23,9,202,162,68,20,140,24,151
30	41,173,145,152,216,31,179,182,50,48,110,86,239,96,222,125,42,173,226,193,224,130,156,37,51,216,238,40,192,180
31	20,37,252,93,63,75,225,31,115,83,113,39,44,73,122,137,118,119,144,248,248,55,1,225,105,13,183,117,187,200,210
32	10,6,106,190,249,167,4,67,209,138,138,32,242,123,89,27,120,185,80,156,38,69,171,60,28,22,80,52,254,185,220,241
33	245,231,55,24,71,78,76,81,225,212,173,37,215,46,119,229,245,167,126,72,181,94,165,210,98125,159,184,169,232,185,231,18
34	111,77,146,94,26,21,108,19,105,94,113,193,86,140,163,125,58,158,229,239,218,103,56,70,11,61,183,129,167,13,98,62,129,51
35	7,94,143,81,247,127,202,202,194,125,146,29,138,162,153,65,105,122,116,238,26,36,216,112,25,228,15,49,8,162,30,126,111,58,85
36	200,183,98,16,172,31,246,234,60,152,115,0,167,152,113,248,238,107,18,63,218,37,87,210,10,177,120,74,121,196,117,251,113,233,30,120
37	154,75,141,180,61,165,104,232,46,227,96,178,92,135,57,162,120,194,212,174,252,183,42,35,57,111,23,133,100,8,105,37,192,189,159,19,156
38	159,34,38,228,230,59,243,95,49,218,176,164,20,65,45,111,39,81,49,118,113,222,193,250,242168,217,41,164,247,177,30,238,18,120,153,60,193
39	81,216,174,47,200,150,59,156,89,143,89,166,183,170,152,21,165,177,113,132,234,5,154,68,14,175,196,157,249,233,83,24,153,241,126,36,116,19,231
40	59,116,79,161,252,98,128,205,128,161,247,57,163,56,235,106,53,26,187,174,226,104,170,7,15,35,181,114,88,41,47,163,125,134,72,20,232,53,35,15
41	132,167,52,139,184,223,149,92,250,18,83,33,127,109,194,7,211,242,109,66,86,169,87,96,187159,114,172,118,208,183,200,82,179,38,39,34,242,142,147,55
42	250,103,221,230,25,18,137,231,0,3,58,242,221,191,110,84,230,8,188,106,96,147,15,131,139,4,101,223,39,101,213,199,237,254,201,123,171,162,194,117,50,96
43	96,67,3,245,217,215,33,65,240,109,144,63,21,131,38,101,153,128,55,31,237,3,94,160,20,87,7,56,191,123,207,75,82,0,122,132,101,145,215,15,121,192,138
44	190,7,61,121,71,246,69,55,168,188,89,243,191,25,72,123,9,145,14,247,1,238,44,78,143,62,24,126,118,114,68,163,52,194,217,147,204,169,37,130,113,102,73,181
45	6,172,72,250,18,171,171,162,229,187,239,4,187,11,37,228,102,72,102,22,33,73,95,99,132,1,5,89,4,112,130,95,211,235,227,58,35,88,132,23,44,165,54,187,225
46	112,94,88,112,253,224,202,115,187,99,89,5,54,113,129,44,58,16,135,216,169,211,36,1,4,96,0,241,73,104,234,8,249,245,119,174,52,25,157,224,43,202,223,19,82,15
47	76,164,229,92,79,168,219,110,104,21,220,74,19,199,195,100,93,191,43,213,72,56,138,161,12,187,119,250,189,137,190,76,126,247,93,30,132,6,58,213,208,165,224,152,133,91,61
48	228,25,196,130,211,146,60,24,251,90,39,102,240,61,178,63,46,123,115,18,221,111,135,160,12,205,107,206,95,150,120,184,91,21,247,156,140,238,191,11,94,227,84,50,163,39,34,108
49	172,121,1,41,193,222,237,64,109,181,52,120,212,226,239,245,208,20,246,34,225,204,134,101125,206,69,138,250,0,77,58,143,185,220,254,210,190,112,88,91,57,90,109,5,13,181,25,156
50	232,125,157,161,164,9,118,46,209,99,203,193,35,3,209,111,195,242,203,225,46,13,32,160,12,209,130,160,242,215,242,75,77,42,189,32,113,65,124,69,228,114,235,175,124,170,215,232,133205
51	213,166,142,43,10,216,141,163,172,180,102,70,89,62,222,62,42,210,151,163,218,70,77,39,16,191,114,202,245,188,183,221,75,212,27,237,127,204,235,62,190,232,18,46,171,15,98,247,66,13,0
52	116,50,86,186,50,220,251,89,192,46,86,127,124,19,184,233,151,215,22,14,59,145,37,242,203134,254,89,190,94,59,65,124,113,100,233,235,121,22,76,86,97,39,242,200,220,101,33,239,254,16,51
53	122,214,231,136,199,11,6,205,124,72,213,117,187,60,147,201,73,75,33,146,171,247,118,208,57,177,203,235,83,45,226,202,229,168,7,57,237,235,200,124,106,254,165,14,147,0,57,42,31,17,213,173,103
54	183,26,201,87,210,221,113,21,46,65,45,50,238,184,249,225,102,58,209,218,109,165,26,95,18,192,52,245,35,254,238,175,172,79,123,25,122,43,120,108,215,80,128,201,235,8,153,59,101,31198,76,31,156
55	38,197,123,167,16,87,178,238,227,97,148,247,26,90,228,182,236,197,47,249,36,213,54,113,11,74,177,204,155,61,47,42,0,132,144,251,200,38,38,138,54,44,64,19,22,206,16,10,228,211,161171,44,194,210
56	106,120,107,157,164,216,112,116,2,91,248,163,36,201,202,229,6,144,254,155,135,208,170,20,12,139,127,142,182,249,177,174,190,28,10,85,239,184,101,124,152,206,96,23,163,61,27,196,27,151,154,202,207,20,61,10
57	58,140,237,93,106,61,193,2,87,73,194,215,159,163,10,155,5,121,153,59,248,4,117,22,60,177144,44,72,228,62,1,19,170,113,158,25,175,199,139,90,1,210,7,119,154,89,159,130,122,46,147,90,135,94,68,66
58	82,116,26,247,66,27,62,107,252,182,200,185,235,55,251,242,210,144,154,237,176,141,192,24,152,249,206,85,253,142,65,165,125,23,24,30,122,240,214,6,129,218,29,145,127,134,206,245,17,29,41,63,159,142,233,125,148,123
59	57,115,232,11,195,217,3,206,77,67,29,166,180,106,118,203,17,69,152,213,74,44,49,43,98,61253,122,14,43,209,143,9,104,107,171,224,57,254,251,226,232,221,194,240,117,161,82,178,246,78,33,50,86,215,239,180,180,181
60	107,140,26,12,9,141,243,197,226,197,219,45,211,101,219,120,28,181,127,6,100,247,2,205,19,57,115,219,101,109,160,82,37,38,238,49,160,209,121,86,11,124,30,181,84,25,194,87,65,102,10,220,70,27,209,16,89,7,33,240
61	161,244,105,115,64,9,221,236,16,145,148,34,144,186,13,20,254,246,38,35,202,72,4,212,159,11,165,135,252,250,25,87,30,120,226,234,92,199,72,7,155,218,231,44,125,178,156,174,124,43,00,31,56,101,204,64,175,225,169,146,45
62	65,202,113,98,71,223,248,118,214,94,0,122,37,23,2,228,58,121,7,105,135,78,243,118,70,76,23,89,72,50,70,111,194,17,212,126,181,35,221,117,235,11,229,149,147,123,213,40,115,6,200,10,26,246,182,218,127,215,36,186,110,106
63	30,71,36,71,19,195,172,110,61,2,169,194,90,136,59,182,231,145,102,39,170,231,214,67,196,07,53,112,246,90,90,121,183,146,74,77,38,89,22,231,55,56,242,112,217,110,123,62,201,217,12,165,60,181,37,161,246,132,246,18,115,136,168
64	45,51,175,9,7,158,159,49,68,119,92,123,177,204,187,254,200,78,141,149,119,26,127,53,160,3,199,212,29,24,145,156,208,150,218,209,4,216,91,47,184,146,47,140,195,195,125,242,238,63,9,108,140,230,242,31,204,11,178,243,217,156,213,231
65	137,158,247,240,37,238,214,128,99,218,46,138,198,128,92,219,109,139,166,25,66,67,14,58,28,149,177,195,221,154,171,48,80,12,59,190,228,19,55,208,92,112,229,37,60,10,47,81,0,192,37171,175,147,128,73,166,61,149,12,24,95,70,113,40
66	5,118,222,180,136,136,162,51,46,117,13,215,81,17,139,247,197,171,95,173,65,137,178,68,11,95,101,41,72,214,169,197,95,7,44,154,77,111,236,40,121,143,63,87,80,253,240,126,217,77,34232,106,50,168,82,76,146,67,106,171,25,132,93,45,105
67	191,172,113,86,7,166,246,185,155,250,98,113,89,86,214,225,156,190,58,33,144,67,179,163,5,154,233,151,104,251,160,126,175,208,225,70,227,146,4,152,139,103,25,107,61,204,159,250,19,225,105,160,98,167,2,53,16,242,83,210,196,103,248,86,211,41,171
68	247,159,223,33,224,93,77,70,90,160,32,254,43,150,84,101,190,205,133,52,60,202,165,220,20,151,93,84,15,84,253,173,160,89,227,52,199,97,95,231,52,177,41,125,137,241,166,225,118,2,5,32,82,215,175,198,43,238,235,27,101,184,127,3,5,8,163,238
*/

private static final char coef7[]  =	{ 87, 229, 146, 149, 238, 102,  21		   };	      /*  7 */
private static final char coef10[] =	{251,  67,  46,  61, 118,  70,  64,  94,  32,  45 };  /* 10 */
private static final char coef13[] =	{ 74, 152, 176, 100,  86, 100, 106, 104, 130, 218,	  /* 13 */
					 206, 140,  78							   };
private static final char coef15[] =	{  8, 183,  61,  91, 202,  37,  51,  58,  58, 237,	  /* 15 */
					 140, 124,   5,  99, 105				   };
private static final char coef16[] =	{120, 104, 107, 109, 102, 161,  76,   3,  91, 191,	  /* 16 */
					 147, 169, 182, 194, 225, 120			   };
private static final char coef17[] =	{ 43, 139, 206,  78,  43, 239, 123, 206, 214, 147,	  /* 17 */
		 	 		  24,  99, 150,  39, 243, 163, 136		   };
private static final char coef18[] =	{215, 234, 158,  94, 184,  97, 118, 170,  79, 187,	  /* 18 Model2 */
					 152, 148, 252, 179,   5,  98,  96, 153	   };
private static final char coef20[] =	{ 17,  60,  79,  50,  61, 163,  26, 187, 202, 180,	  /* 20 */
		 	 		 221, 225,  83, 239, 156, 164, 212, 212, 188, 190  };
private static final char coef22[] = 	{210, 171, 247, 242,  93, 230,  14, 109, 221,  53,	  /* 22 */
		  	 		 200,  74,   8, 172,  98,  80, 219, 134, 160, 105,
		   	 		 165, 231	         					   };
private static final char coef24[] = 	{229, 121, 135,  48, 211, 117, 251, 126, 159, 180,	  /* 24 */
		  	 		 169, 152, 192, 226, 228, 218, 111,   0, 117, 232,
		   	 		  87,  96, 227,  21          			   };
private static final char coef26[] = 	{173, 125, 158,   2, 103, 182, 118,  17, 145, 201,	  /* 26 */
		 	 		 111,  28, 165,  53, 161,  21, 245, 142,  13, 102,
		  	 		  48, 227, 153, 145, 218,  70			   };
private static final char coef28[] = 	{168, 223, 200, 104, 224, 234, 108, 180, 110, 190,	  /* 28 */
		  	 		 195, 147, 205,  27, 232, 201,  21,  43, 245,  87,
		  	 		  42, 195, 212, 119, 242,  37,   9, 123		   };
private static final char coef30[] = 	{ 41, 173, 145, 152, 216,  31, 179, 182,  50,  48,	  /* 40 */
		 	 		 110,  86, 239,  96, 222, 125,  42, 173, 226, 193,
		 	 		 224, 130, 156,  37, 251, 216, 238,  40, 192, 180  };
private static final char coef32[] = 	{ 10,   6, 106, 190, 249, 167,   4,  67, 209, 138,	  /* 32 */
		 	 		 138,  32, 242, 123,  89,  27, 120, 185,  80, 156,
		  	 		  38,  69, 171,  60,  28, 222,  80,  52, 254, 185,
		 	 		 220, 241					   };
private static final char coef34[] = 	{111,  77, 146,  94,  26,  21, 108,  19, 105,  94,	  /* 34 */
		 	 		 113, 193,  86, 140, 163, 125,  58, 158, 229, 239,
		 	 		 218, 103,  56,  70, 114,  61, 183, 129, 167,  13,
		 	  		 98,  62, 129,  51				   };
private static final char coef36[] = 	{200, 183,  98,  16, 172,  31, 246, 234,  60, 152,	  /* 36 */
		 	 		 115,   0, 167, 152, 113, 248, 238, 107,  18,  63,
		 	 		 218,  37,  87, 210, 105, 177, 120,  74, 121, 196,
		 	 		 117, 251, 113, 233,  30, 120			   };
private static final char coef40[] = 	{ 59, 116,  79, 161, 252,  98, 128, 205, 128, 161,	  /* 40 */
		 	 		 247,  57, 163,  56, 235, 106,  53,  26, 187, 174,
		 	 		 226, 104, 170,   7, 175,  35, 181, 114,  88,  41,
		 	 		  47, 163, 125, 134,  72,  20, 232,  53,  35,  15  };
private static final char coef42[] = 	{250, 103, 221, 230,  25,  18, 137, 231,   0,   3,    /* 42 */
		 	  		  58, 242, 221, 191, 110,  84, 230,   8, 188, 106,
		 	 		  96, 147,  15, 131, 139,  34, 101, 223,  39, 101,
		 	 		 213, 199, 237, 254, 201, 123, 171, 162, 194, 117,
		 	 		  50,  96					   };
private static final char coef44[] = 	{190,   7,  61, 121,  71, 246,  69,  55, 168, 188,    /* 44 */
		 	  		  89, 243, 191,  25,  72, 123,   9, 145,  14, 247,
		 			   1, 238,  44,  78, 143,  62, 224, 126, 118, 114,
		 			  68, 163,  52, 194, 217, 147, 204, 169,  37, 130,
		 			 113, 102,  73, 181				   };
private static final char coef46[] = 	{112,  94,  88, 112, 253, 224, 202, 115, 187,  99,    /* 46 */
		 			  89,   5,  54, 113, 129,  44,  58,  16, 135, 216,
		 			 169, 211,  36,   1,   4,  96,  60, 241,  73, 104,
		 			 234,   8, 249, 245, 119, 174,  52,  25, 157, 224,
		 			  43, 202, 223,  19,  82,  15			   };
private static final char coef48[] = 	{228,  25, 196, 130, 211, 146,  60,  24, 251,  90,    /* 48 */
		 			  39, 102, 240,  61, 178,  63,  46, 123, 115,  18,
		 			 221, 111, 135, 160, 182, 205, 107, 206,  95, 150,
		 			 120, 184,  91,  21, 247, 156, 140, 238, 191,  11,
		 			  94, 227,  84,  50, 163,  39,  34, 108		   };
private static final char coef50[] = 	{232, 125, 157, 161, 164,   9, 118,  46, 209,  99,    /* 50 */
		 			 203, 193,  35,   3, 209, 111, 195, 242, 203, 225,
		 		 	  46,  13,  32, 160, 126, 209, 130, 160, 242, 215,
		 			 242,  75,  77,  42, 189,  32, 113,  65, 124,  69,
		 			 228, 114, 235, 175, 124, 170, 215, 232, 133, 205  };
private static final char coef52[] = 	{116,  50,  86, 186,  50, 220, 251,  89, 192,  46,    /* 52 */
		 			  86, 127, 124,  19, 184, 233, 151, 215,  22,  14,
		 			  59, 145,  37, 242, 203, 134, 254,  89, 190,  94,
		 			  59,  65, 124, 113, 100, 233, 235, 121,  22,  76,
		 			  86,  97,  39, 242, 200, 220, 101,  33, 239, 254,
				 	 116,  51					   };
private static final char coef54[] = 	{183,  26, 201,  87, 210, 221, 113,  21,  46,  65,    /* 54 */
				 	  45,  50, 238, 184, 249, 225, 102,  58, 209, 218,
				 	 109, 165,  26,  95, 184, 192,  52, 245,  35, 254,
				 	 238, 175, 172,  79, 123,  25, 122,  43, 120, 108,
				 	 215,  80, 128, 201, 235,   8, 153,  59, 101,  31,
				 	 198,  76,  31, 156				   };
private static final char coef56[] = 	{106, 120, 107, 157, 164, 216, 112, 116,   2,  91,    /* 56 */
				 	 248, 163,  36, 201, 202, 229,   6, 144, 254, 155,
				 	 135, 208, 170, 209,  12, 139, 127, 142, 182, 249,
				 	 177, 174, 190,  28,  10,  85, 239, 184, 101, 124,
				 	 152, 206,  96,  23, 163,  61,  27, 196, 247, 151,
				 	 154, 202, 207,  20,  61,  10			   };
private static final char coef58[] = 	{ 82, 116,  26, 247,  66,  27,  62, 107, 252, 182,    /* 58 */
				 	 200, 185, 235,  55, 251, 242, 210, 144, 154, 237,
				 	 176, 141, 192, 248, 152, 249, 206,  85, 253, 142,
				 	  65, 165, 125,  23,  24,  30, 122, 240, 214,   6,
				 	 129, 218,  29, 145, 127, 134, 206, 245, 117,  29,
				 	  41,  63, 159, 142, 233, 125, 148, 123		   };
private static final char coef60[] = 	{107, 140,  26,  12,   9, 141, 243, 197, 226, 197,    /* 60 */
				 	 219,  45, 211, 101, 219, 120,  28, 181, 127,   6,
				 	 100, 247,   2, 205, 198,  57, 115, 219, 101, 109,
				 	 160,  82,  37,  38, 238,  49, 160, 209, 121,  86,
				 	  11, 124,  30, 181,  84,  25, 194,  87,  65, 102,
				 	 190, 220,  70,  27, 209,  16,  89,   7,  33, 240  };
private static final char coef62[] = 	{ 65, 202, 113,  98,  71, 223, 248, 118, 214,  94,    /* 62 */
		 			   0, 122,  37,  23,   2, 228,  58, 121,   7, 105,
				 	 135,  78, 243, 118,  70,  76, 223,  89,  72,  50,
				 	  70, 111, 194,  17, 212, 126, 181,  35, 221, 117,
				 	 235,  11, 229, 149, 147, 123, 213,  40, 115,   6,
				 	 200, 100,  26, 246, 182, 218, 127, 215,  36, 186,
				 	 110, 106					   };
private static final char coef64[] = 	{ 45,  51, 175,   9,   7, 158, 159,  49,  68, 119,    /* 64 */
					  92, 123, 177, 204, 187, 254, 200,  78, 141, 149,
				 	 119,  26, 127,  53, 160,  93, 199, 212,  29,  24,
				 	 145, 156, 208, 150, 218, 209,   4, 216,  91,  47,
				 	 184, 146,  47, 140, 195, 195, 125, 242, 238,  63,
				 	  99, 108, 140, 230, 242,  31, 204,  11, 178, 243,
		 			 217, 156, 213, 231				   };
private static final char coef66[] = 	{  5, 118, 222, 180, 136, 136, 162,  51,  46, 117,    /* 66 */
				 	  13, 215,  81,  17, 139, 247, 197, 171,  95, 173,
				 	  65, 137, 178,  68, 111,  95, 101,  41,  72, 214,
				 	 169, 197,  95,   7,  44, 154,  77, 111, 236,  40,
				 	 121, 143,  63,  87,  80, 253, 240, 126, 217,  77,
				 	  34, 232, 106,  50, 168,  82,  76, 146,  67, 106,
				 	 171,  25, 132,  93,  45, 105			   };
private static final char coef68[] = 	{247, 159, 223,  33, 224,  93,  77,  70,  90, 160,    /* 68 */
				 	  32, 254,  43, 150,  84, 101, 190, 205, 133,  52,
					  60, 202, 165, 220, 203, 151,  93,  84,  15,  84,
				 	 253, 173, 160,  89, 227,  52, 199,  97,  95, 231,
				 	  52, 177,  41, 125, 137, 241, 166, 225, 118,   2,
				 	  54,  32,  82, 215, 175, 198,  43, 238, 235,  27,
				 	 101, 184, 127,   3,   5,   8, 163, 238		   };
private static class cftb {
	private int	nmenb;
	private char[] tbladr;
	cftb(int nmenb, char[] tbladr)
	{
		super();
		this.nmenb = nmenb;
		this.tbladr = tbladr;
	}
	
} 
private static final cftb coef_tbl[] =		{new cftb( 7, coef7 ), new cftb(10, coef10), new cftb(13, coef13), new cftb(15, coef15),
		new cftb(16, coef16), new cftb(17, coef17), new cftb(18, coef18), new cftb(20, coef20),
		new cftb(22, coef22), new cftb(24, coef24), new cftb(26, coef26), new cftb(28, coef28),
		new cftb(30, coef30), new cftb(32, coef32), new cftb(34, coef34), new cftb(36, coef36),
		new cftb(40, coef40), new cftb(42, coef42), new cftb(44, coef44), new cftb(46, coef46),
		new cftb(48, coef48), new cftb(50, coef50), new cftb(52, coef52), new cftb(54, coef54),
		new cftb(56, coef56), new cftb(58, coef58), new cftb(60, coef60), new cftb(62, coef62),
		new cftb(64, coef64), new cftb(66, coef66), new cftb(68, coef68)				};

/*  Coefficient of polynomial used in model 1 */
/*		7,10,13,15,16,17,20,22,24,26,28,30,32,34,36,
		40,42,44,46,48,50,52,54,56,58,60,62,64,66,68 */
/*  Coefficient of polynomial used in model 2 */
/*		7 10 13 15 16 17 18 20 22 24 26 28 30 */

private void add_correction_code()
{
	int		i, j, k, m_num, arg;
	int		div, tinfo, trslen, rsofst;
	char	[]ucp,	udp;
	int ucpi = 0, udpi = 0;
	int		[]idp;
	int idpi = 0;

	switch(modelNo) {
	case MODEL1:
		div = vinfoDIVID;						/* No. of divisions */
		trslen = vinfoTOTAL - vinfoNDATA - 1;	/* Total amount of RS characters */
		rsofst = vinfoNDATA + 1;				/* RS character position */
		tinfo = rsofst / div;					
												/* Data amount after divided */
		trslen /= div;

		for (i = 0; i < MAXCOEF; i++)			
												/* Find RS code table to be used */
    		if (trslen == coef_tbl[i].nmenb) break;
		if (i==MAXCOEF) {
    		/* fprintf(stderr, "error: COEF not founded !!\n"); */
    		//exit(1);
			throw new RuntimeException("error: COEF not founded !!\n");
		}
		ucp = coef_tbl[i].tbladr;
		idp = divisor;
		idpi = 0;
		for (i = 0; i < trslen; i++)
			idp[idpi++] = ucp[ucpi++];
    
		for (k = 0; k < div; k++) {
			ucp = Ccode;
			ucpi = tinfo*k;
			udp = dividend;
			udpi = 0;
			for (i = 0; i < tinfo; i++)
				udp[udpi++] = ucp[ucpi++];
			for (; i <= tinfo+trslen; i++)		
                     /* Supplement the remainder with "0".  Equal sign added on October 23, 1997  */
				udp[udpi++] = 0;
			for (i = 0; i < tinfo; i++) {
				m_num = trans[dividend[i]];
				if (m_num == AMAX) continue;
			
	    		for (j = 0; j < trslen; j++) {
					if (divisor[j] == AMAX) arg = AMAX;
					else {
						arg = divisor[j] + m_num;
						arg %= (AMAX - 1);
					}
					dividend[i + j + 1] ^= alpha[arg];
				}
			}
			ucp = dividend;
			ucpi = tinfo;
			udp = Ccode;
			udpi = trslen*k+rsofst;
			for (i = 0; i < trslen; i++)
				udp[udpi++] = (char) (ucp[ucpi++] & 0377);
		}
		
		/* Start position of remainder =  Amount of data + INT((Total amount - amount of data - mode information (=1))/No. of divisions)*No. of divisions */
		k = (vinfoTOTAL - vinfoNDATA - 1) / div; /* Omit decimals */
		k = k * div + vinfoNDATA + 1;
		int DPATTERN = 60433;				/* Dummy pattern */
		for (i = k, j = 8; i<vinfoTOTAL; i++){
			Ccode[i] = (char) ((DPATTERN >> j) & 255);	
														/* Supplement the remainder with DPATTERN */
			if (j > 0) j = 0;
			else j = 8;
		}
		break;
	case MODEL2:
		div = vinfoDIVID;					/* Total No. of divisions */
		trslen = vinfoTOTAL - vinfoNDATA;	/* Total amount of RS characters */
		rsofst = vinfoNDATA;				/* RS character position */
		trslen /= div;						/* Amount of RS after divided */
		pinfoNRSDivid = trslen;				/* Amount of RS after divided */
		pinfoNDTDivid = vinfoNDATA / div;	
											/* Amount of 1st data after divided */
		pinfoNDTItr2 = vinfoNDATA - pinfoNDTDivid * div;
		pinfoNDTItr1 = div - pinfoNDTItr2;

		for (i = 0; i < MAXCOEF; i++)		
											/* Find RS code table to be used */
    		if (trslen == coef_tbl[i].nmenb) break;
		if (i==MAXCOEF) {
    		/* fprintf(stderr, "error: COEF not founded !!\n"); */
    		//exit(1);
			throw new RuntimeException("error: COEF not founded !!\n");
		}
		ucp = coef_tbl[i].tbladr;
		idp = divisor;
		idpi = 0;
		for (i = 0; i < trslen; i++)
			idp[idpi++] = ucp[ucpi++];
    
		for (k = 0; k < div; k++) {
			if (k < pinfoNDTItr1) {
				tinfo = pinfoNDTDivid;			
												/* Amount of 1st data after divided */
				ucp = Ccode;
				ucpi = tinfo*k;
			} else {
				tinfo = pinfoNDTDivid + 1;		
												/* Amount of 2nd data after divided */
				ucp = Ccode;
				ucpi = tinfo*k - pinfoNDTItr1;
			}
			udp = dividend;
			udpi = 0;
			for (i = 0; i < tinfo; i++)
				udp[udpi++] = ucp[ucpi++];
			for (; i < tinfo+trslen; i++)		
												/* Supplement the remainder with "0" */
				udp[udpi++] = 0;
			for (i = 0; i < tinfo; i++) {
				m_num = trans[dividend[i]];
				if (m_num == AMAX) continue;
			
	    		for (j = 0; j < trslen; j++) {
					if (divisor[j] == AMAX) arg = AMAX;
					else {
						arg = divisor[j] + m_num;
						arg %= (AMAX - 1);
					}
					dividend[i + j + 1] ^= alpha[arg];
				}
			}
			ucp = dividend;
			ucpi = tinfo;
			udp = Ccode;
			udpi = trslen*k+rsofst;
			for (i = 0; i < trslen; i++)
				udp[udpi++] = (char) (ucp[ucpi++] & 0377);
		}
		break;
	}
}


/*-------------------------------------------------------qr3.c------------------------------------------------------------------------------------------------*/
 
private static final int POLY = 02467;		
/* Polynomial for generating (15,5) BCH code */
private static final int N = 15;			/* Code length of BCH code */
private static final int K = 5;				/* No. of BCH code information symbols */
private static final int PAT_MODEL1	=	024045;	
/* =0x2825 Mask pattern corresponding to model 1 format information */
private static final int PAT_MODEL2	=	052022;	
/* =0x5412 Mask pattern corresponding to model 2 format information */
 private static final char 			bitpos[] = { 1, 2, 4, 8, 16, 32, 64, 128};

 
 /* Model 2 version information  18-bit  (18, 6, 3) extended BCH code */
 private static final long verInfo[] = {
 	0x001f25, 0x00216f, 0x003e4a, 0x0042de, 0x005dfb, 0x0063b1, 0x007c94, 0x0085bc,
 	0x009a99, 0x00a4d3, 0x00bbf6, 0x00c762, 0x00d847, 0x00e60d, 0x00f928, 0x010b78,
 	0x01145d, 0x012a17, 0x013532, 0x0149a6, 0x015683, 0x0168c9, 0x0177ec, 0x018ec4,
 	0x0191e1, 0x01afab, 0x01b08e, 0x01cc1a, 0x01d33f, 0x01ed75, 0x01f250, 0x0209d5,
 	0x0216f0, 0x0228ba, 0x02379f, 0x024b0b, 0x02542e, 0x026a64, 0x027541, 0x028c69
 };
 

 /* Print posision detection pattern */
 private void
 k1mark(int xx, int yy)
 
 /* int xx, yy Upper left coordinates of position detection pattern (pdp) */
 {
 	int i, x, y;

 	for (i = 0, x = xx; i < 7; i++, x++)
 		blkcell(x,yy);
 	for (i = 0, x = xx, y = yy+6; i < 7; i++, x++)
 		blkcell(x,y);
 	for (i = 0, y = yy+1; i < 6; i++, y++)
 		blkcell(xx,y);
 	for (i = 0, x = xx+6, y = yy+1; i < 6; i++, y++)
 		blkcell(x,y);
 	for (i = 0, x = xx+2, y = yy+2; i < 3; i++, x++) {
 		blkcell(x,y);
 		blkcell(x,y+1);
 		blkcell(x,y+2);
 	}
 }

 
 /* Print three position detection patterns, and timing cells */
 private void
 k3mark()
 {
 	int n, i, j;

 	n = Csize;
 	k1mark(0, 0);			/* Upper left PDP */
 	k1mark(0, n-7);			/* Lower left PDP */
 	k1mark(n-7, 0);			/* Upper right PDP */
 	for (i = 0; i < 8; i++) {			/* PDP area (8*8) */
 		for (j = 0; j < 8; j++) {
 			iwitcell(i, j);
 			iwitcell(i, n-j-1);
 			iwitcell(n-i-1, j);
 		}
 	}
 	for (i = 8; i <= n-8; i += 2) {
 		blkcell(i, 6);		/* Horizontal timing cell */
 		blkcell(6, i);		/* Vertical timing cell */
 	}
 	for (i = 8; i < n-8; i++) {		/* Timing pattern */
 		iwitcell(i, 6);
 		iwitcell(6, i);
 	}
 	for (i = 0; i < 8; i++) {		
 									/* Mask No, error correction level */
 		iwitcell(i, 8);
 		iwitcell(8, i);
 		iwitcell(8, n-1-i);
 		iwitcell(n-1-i, 8);
 	}
 	blkcell(8, n-8);
 	iwitcell(8, 8);
 }


 /* Print alignment pattern  */
 private void
 alpmark(int i, int k)
 {
     int		x, y;
     for (y = i - 4; y <= i; y++) {
         blkcell(k, y);
         blkcell(k - 4, y);
 	}
     for (x = k - 3; x < k; x++) {
         blkcell(x, i);
         blkcell(x, i - 4);
     }
     blkcell(i - 2, k - 2);
     for (x = i - 4; x <= i; x++) {
         for (y = k - 4; y <= k; y++) {
             iwitcell(x, y);
         }
     }
 }

 
 /* Clear all data cell area & Initialize function cell area */
 private void
 clrcell()
 {
 	int		i, j, n;
 	char  r_bit[] = {0x00,0x01,0x03,0x07,0x0f,0x1f,0x3f,0x7f};
 	
 	n = Csize / 8;
 	for (i = 0; i < Csize; i++) {
 		for (j = 0; j < (Csize+7)/8; j++)	/* Initialize data cell */
 			cell[i][j] = 0;

 		for(j = 0; j < n; j++)
 			icell[i][j] = 0xff;
 		icell[i][j] = r_bit[Csize & 0x07];
 		
 	}
 }


 /* Depict function cell area on cell[][] and mark "0" in icell[][] */
 private void make_inst()
 {
 	int		i, j, n, m;
 	long	vinfo;

 	n = Csize;
 	switch(modelNo) {
 	case MODEL1:
 		k3mark();					
 									/* Set position detection pattern and timing pattern */
 		blkcell(n-1, n-1);			/* Origin cell */
 		iwitcell(n-1, n-1);			/* Origin cell area 4*4 */
 		iwitcell(n-1, n-2);
 		iwitcell(n-2, n-1);
 		iwitcell(n-2, n-2);
 		for (i = n-9; i > 12; i -= 8) {	/* Anchor cell */
 			for (j = 0; j < 4; j++) {
 				iwitcell(n-1, i-j);
 				iwitcell(n-2, i-j);
 				iwitcell(i-j, n-1);
 				iwitcell(i-j, n-2);
 			}
 		}
 		break;
 	case MODEL2:
 		k3mark();						
 		
 		/* Set position detection pattern and timing pattern */
 		if (Cver >= CVER_ALP) {			
 										/* Addition of alignment pattern */
 			i = ((n - 14) / 28) + 1;    /* No. of divisions */
 			m = (((n -i - 13) * 2 / i + 1) / 4 + 1) * 2;
 			for (j = n - 7; j >= 12; j -= m) {
 				for (i = n - 7; i >= 12; i -= m) {
 					if (j != 5 && i != 5)
 						alpmark(i + 2, j + 2);
 				}
 			}
 			for (j = n - 7 - m; j >= 7 + m / 2; j -= m) {
 				alpmark(8, j + 2);
 				alpmark(j + 2, 8);
 			}

 			if (Cver >= CVER_VINFO) {
 				vinfo = verInfo[Cver];
 				for (j = 0; j < 6; j++) {
 					for (i = n-11; i < n-8; i++) {	
 													/* Version information area */
 						iwitcell(i, j);
 						iwitcell(j, i);
 						if ((vinfo & 1) != 0) {			/* LSB =1 ? */
 							blkcell(i, j);
 							blkcell(j, i);
 						}
 						vinfo >>= 1;
 					}
 				}
 			}
 		}
 		break;
 	}
 }

 /* Set mask data */
 private void
 add_mask(int p_num)
 {
     int		i, ham = 0, r;
     	int lvlno[] = { 1, 0, 3, 2};	/* L M Q H */
 	 int	PAT_pattern[] = {PAT_MODEL1, PAT_MODEL2};

 	int  non_mask[] = {0x0000,0x0000,0x0000,0x0000};	
 														/* No masking (L M Q H) */

     if(p_num < PATTERN12) {
     	switch(modelNo) {
 		case MODEL1:
 		case MODEL2:
 			ham = (lvlno[Clvl] << 3) | p_num;
 			break;
 		}
     	r = ham << 5;
     	for (i = 0; i < K; i++) {
 			if ((r & 01000) != 0) r = (r << 1) ^ POLY;
 			else           r <<= 1;
     	}
    		ham = (ham << (N - K)) ^ r;
 		ham = ham ^ PAT_pattern[modelNo];
 	} else ham = non_mask[Clvl];

     switch(modelNo) {
 	case MODEL1:
 	case MODEL2:
 	   for (i = 0, r = 1; i < 9; i++) {		/* format 1 */
 			if (i == 6) continue;
 			if ((ham & r) != 0) {
 				blkcell(8, i);
 			} else {
 				witcell(8, i);
 			}
 			r <<= 1;
 		}
 		for (i = 0; i < 8; i++) {
 			if (i == 1) continue;
 			if ((ham & r) != 0) {
 				blkcell(7-i, 8);
 			} else {
 				witcell(7-i, 8);
 			}
 			r <<= 1;
 		}
 		for (i = 0, r = 1; i < 8; i++) {		/* format 2 */
 			if ((ham & r) != 0) {
 				blkcell(Csize-i-1, 8);
 			} else {
 				witcell(Csize-i-1, 8);
 			}
 			r <<= 1;
 		}
 		for (i = 0; i < 7; i++) {
 			if ((ham & r) != 0) {
 				blkcell(8, Csize-7+i);
 			} else {
 				witcell(8, Csize-7+i);
 			}
 			r <<= 1;
 		}
 		break;
 	}
 }

 private void
 set_Vptn(char c, int x, int y)
 
 /* uchar c;
    int x, y; Lower right of set position (MSB) */
 {
 	int i;

 	for (i = 0; i < 8; i++) {
 		if ((c & 128) != 0) blkcell(x-(i%2), y-(i/2));
 		c <<= 1;
 	}
 }

 private void
 set_Hptn(char c, int x, int y)
 
 /* uchar c;
    int x, y;  Lower right of set position (MSB) */
 {
 	int i;

 	for (i = 0; i < 8; i++) {
 		if ((c & 128) != 0) blkcell(x-(i%4), y-(i/4));
 		c <<= 1;
 	}
 }


 /* Interleave Ccode[] into iCcode[] */
 private void
 interLeave()
 {
 	int i, j;
 	char []udp, usp;
 	int udpi = 0, uspi = 0;
 	udp = iCcode;
 	for (i = 0; i < pinfoNDTDivid; i++) {
 		usp = Ccode;
 		uspi = i;
 		for (j = 0; j < vinfoDIVID; j++) {
 			udp[udpi++] = usp[uspi];
 			uspi += (pinfoNDTDivid + ((j<pinfoNDTItr1) ? 0 : 1));
 		}
 	}
 	usp = Ccode;
 	uspi = pinfoNDTDivid * (pinfoNDTItr1+1);		
 							    			/* The end of 2nd divided data */
 	for (j = 0; j < pinfoNDTItr2; j++) {
 		udp[udpi++] = usp[uspi];
 		uspi += (pinfoNDTDivid +1);
 	}
 	for (i = 0; i < pinfoNRSDivid; i++) {
 		usp = Ccode;
 		uspi = i + vinfoNDATA;			/* Beginning of RS data */
 		for (j = 0; j < vinfoDIVID; j++) {
 			udp[udpi++] = usp[uspi];
 			uspi += pinfoNRSDivid;
 		}
 	}
 }

 private void
 set_pattern()
 {
 	int i, j, x, y;
 	int sx, sy, n;
 	//extern int CodeWordLen;	/* Total amount */

 	clrcell();				/* Initialize cell */
 	
 	make_inst();			/* Generate function cell pattern */
 	
 	
 	switch(modelNo) {
 	case MODEL1:
 		i = 0;
 		x = Csize-1;
 		for (y = Csize-1; y > 8; y -= 4) {
 			if (y != Csize-1 && y > 12 && (((Csize-1-y)/4)&1)==0)
 				set_Vptn((char) 170, x, y);			/* Anchor cell */
 			else
 				set_Vptn(Ccode[i++], x, y);
 		}
 		x -= 2;
 		for (y = Csize-1; y > 8; y -= 4) {
 			set_Vptn(Ccode[i++], x, y);
 		}
 		x -= 2;
 		for (y = Csize-1; y > 8; y -= 2) {
 			set_Hptn(Ccode[i++], x, y);
 		}
 		x -= 4;
 		for (; x > 8; x -= 4) {
 			if (x > 12 && (((Csize-1-x)/4)&1)==0)
 				set_Hptn((char) 240, x, Csize-1);		/* Anchor cell */
 			else
 				set_Hptn(Ccode[i++], x, Csize-1);
 			for (y = Csize-3; y > 0; y -= 2) {
 				if (y==6) y--;
 				set_Hptn(Ccode[i++], x, y);
 			}
 		}
 		for (; x > 0; x-=2) {
 			if (x==6) x--;
 			for (y = Csize-9; y > 8; y -= 4) {
 				set_Vptn(Ccode[i++], x, y);
 			}
 		}
 		break;
 	case MODEL2:
 		interLeave();
 		
 		x = Csize - 1;
 		y = Csize - 1;
 		sx = -1; sy = -1;
 		for (j = 0; j < CodeWordLen; j++) {
 			n = iCcode[j];
 			for (i = 0; i < 8; i++) {
 				if ((n & 128) != 0) blkcell(x, y);
 				n <<= 1;
 				do {
 					x += sx;
 					if (sx<0) {
 						if (x < 0) {
 							return;	
 									/* When no remainder bit exists in the last codeword */
 						}
 						sx = 1;
 					} else {
 						y += sy;
 						if (y < 0) {
 							y = 0;
 							x -= 2;
 							if (x == 6) x = 5;	
 												/* Skip timing pattern running vetically */
 							sy = 1;
 						}
 						else if (y >= Csize) { y = Csize-1; x -= 2; sy =- 1; }
 						sx = -1;
 					}
 				} while (itstcell(x,y)==0);
 			}
 		}
 		break;						
 									/* When remainder bit exists */
 	}
 }

 
 /*-------------------------------------------------------qr4.c------------------------------------------------------------------------------------------------*/
private static final int SPAT	=		3;		
	/* No. of detail check patterns */
/*private int  NPRO  = 7;*/					
	/* No. of cells forming prohibited pattern  */
private static final int BM_RATIO = 10;				
	/* Deduced points regarding ratio of black and white */
private static final int BM_PROH = 40;				
	/* Deduced points regarding prohibited pattern */
private static final int BM_LONG1 = 3;				
	/* Deduced points regarding same color cells in series */
/* #define BM_LONG2 12				
		/* Deduced points regarding same color cells in series */
/* #define BM_FIRST 10				
		/* Deduced points regarding end lines */
private static final int BM_BLOCK = 3;				
	/* Deduced points regarding square block */
private static final int BND_LOW_LNG1 = 5;			
	/* Threshold of series of same color cells */
/* #define BND_LOW_LNG2 8			
		/* Threshold of same color cells in series */
//private int BND_LOW_BLK = 2;			
	/* Threshold of square block per side */
private static final int DEF_LONG5 = 12;			
	/* Length 5 contained in position detection pattern */
private static final int DEF_LONG7 = 12;			
	/* Length 7 contained in position detection pattern */
private static final int DEF_LONG8 = 6;			
	/* Length 8 contained in position detection pattern */
private static final int DEF_BLOCK_W = 0;			
	/* White square contained in position detection pattern */
private static final int DEF_BLOCK_B = 12;			
	/* Black square contained in position detection pattern */
private static final int DEF_PROHI = 18;			
	/* Prohibited pattern of position detection pattern */
//private int BLACK = 1;					/* Black cell */
//private int WHITE = 0;					/* White cell */

private int		full_mark;
private int		pat_num, data_cell;
private int[]		point = new int[PATTERN12];
										
private char[][]	icell= new char[SMAX][(SMAX+7)/8];		
	/* Excluded pattern of function cell */
 


private static final char	m_ptn_d0[] = {0x55,0xaa};
private static final char	m_ptn_d1	= 0xff;
private static final char m_ptn_d2[] = {0x49,0x92,0x24};
private static final char	m_ptn_d3[][] = {
								{0x49,0x92,0x24},
								{0x24,0x49,0x92},
								{0x92,0x24,0x49}
							  };
private static final char	m_ptn_d4[][] = {
								{0xc7,0x71,0x1c},
								{0xc7,0x71,0x1c},
								{0x38,0x8e,0xe3},
								{0x38,0x8e,0xe3}
							  };
private static final char	m_ptn_d5[][] = {
								{0xff,0xff,0xff},
								{0x41,0x10,0x04},
								{0x49,0x92,0x24},
								{0x55,0x55,0x55},
								{0x49,0x92,0x24},
								{0x41,0x10,0x04}
							  };
private static final char	m_ptn_d6[][] = {
								{0xff,0xff,0xff},
								{0xc7,0x71,0x1c},
								{0xdb,0xb6,0x6d},
								{0x55,0x55,0x55},
								{0x6d,0xdb,0xb6},
								{0x71,0x1c,0xc7}
							  };
private static final char	m_ptn_d7[][] = {
								{0x55,0x55,0x55},
								{0x38,0x8e,0xe3},
								{0x71,0x1c,0xc7},
								{0xaa,0xaa,0xaa},
								{0xc7,0x71,0x1c},
								{0x8e,0xe3,0x38}
							  };
 
 /* Mask pattern generation */
 private void mkmask_pattern(int ptn)
 {
 	int		i, j, n;
 	
 	n = (Csize + 7) / 8;
 	for (i = 0; i < Csize; i++)
 		for (j = 0; j < n; j++) {		/* Initialize */
 			mcell[i][j] = 0;
 	}

 	switch(ptn) {
 		case 0:
 			for (i = 0; i < Csize; i++) 
 			    for (j = 0; j < n; j++) 
 				mcell[i][j] = (char) (m_ptn_d0[i & 0x01] & icell[i][j]);
 				break;
 		case 1:
 			for (i = 0; i < Csize; i += 2) 
 			    for (j = 0; j < n; j++) 
 				mcell[i][j] = (char) (m_ptn_d1 & icell[i][j]);
 				break;
 		case 2:
 			for (i = 0; i < Csize; i++) 
 			    for (j = 0; j < n; j++) 
 				mcell[i][j] = (char) (m_ptn_d2[j % 3] & icell[i][j]);
 				break;
 		case 3:
 			for (i = 0; i < Csize; i++) 
 			    for (j = 0; j < n; j++) 
 				mcell[i][j] = (char) (m_ptn_d3[i % 3][j % 3] & icell[i][j]);
 				break;
 		case 4:
 			for (i = 0; i < Csize; i++) 
 			    for (j = 0; j < n; j++) 
 				mcell[i][j] = (char) (m_ptn_d4[i & 0x03][j % 3] & icell[i][j]);
 				break;
 		case 5:
 			for (i = 0; i < Csize; i++) 
 			    for (j = 0; j < n; j++) 
 				mcell[i][j] = (char) (m_ptn_d5[i % 6][j % 3] & icell[i][j]);
 				break;
 		case 6:
 			for (i = 0; i < Csize; i++) 
 			    for (j = 0; j < n; j++) 
 				mcell[i][j] = (char) (m_ptn_d6[i % 6][j % 3] & icell[i][j]);
 				break;
 		case 7:
 			for (i = 0; i < Csize; i++) 
 			    for (j = 0; j < n; j++) 
 				mcell[i][j] = (char) (m_ptn_d7[i % 6][j % 3] & icell[i][j]);
 				break;
 		default:
 			break;
 	}
 }



 private void make_pattern(int ptn, int maskNo)
 
 /* int ptn; Mask index No. internally managed 
    int mask No; No. to be put into the format information */
 {
 	int		i, j, ss;

 	add_mask(maskNo);				
 									/* Add mask information to cell [] */
 	mkmask_pattern(ptn);			/* Mask pattern generation */
 	ss = (Csize+7) / 8;
 	for (i = 0; i < Csize; i++) {
 		for (j = 0; j < ss; j++)
 			mcell[i][j] ^= cell[i][j];
 	}
 }

 /* Primary estimation for mask pattern of model 1 and 2 */
 private int check_block()
 {
 	int	   i,j,n,m,sum;
 	class lpdata {
        		char   l,h;

				lpdata()
				{
				}
 	     	};
 	class  pdata {
         	lpdata bytel = new lpdata();
 			int  word;
			pdata()
			{
			}	/* short  word;	98.9.10 */
 	     	} 
 	pdata d1 = new pdata();
 	pdata d2 = new pdata();
 	char s_bit[] = {0x03,0x06,0x0c,0x18,0x30,0x60,0xc0};

 	n = (Csize-1)/8; m = (Csize-1) & 0x07; sum = 0;
 	for (i=0; i < Csize-1; i++){
 		for (j = 0; j < n; j++) {
 			d1.bytel.h = (char) (mcell[i][j+1] & mcell[i+1][j+1]);
 			d2.bytel.h = (char) (mcell[i][j+1] | mcell[i+1][j+1]);
 			d1.bytel.l = (char) (mcell[i][j] & mcell[i+1][j]);
 			d2.bytel.l = (char) (mcell[i][j] | mcell[i+1][j]);
 			d1.word = d1.bytel.h * 256 + d1.bytel.l;
 			d2.word = d2.bytel.h * 256 + d2.bytel.l;
 			
 			if((d1.word & 0x0003) == 0x0003
 				    || (d2.word & 0x0003)  == 0) sum++;
 			if((d1.word & 0x0006) == 0x0006
 				    || (d2.word & 0x0006)  == 0) sum++;
 			if((d1.word & 0x000c) == 0x000c
 				    || (d2.word & 0x000c)  == 0) sum++;
 			if((d1.word & 0x0018) == 0x0018
 				    || (d2.word & 0x0018)  == 0) sum++;
 			if((d1.word & 0x0030) == 0x0030
 				    || (d2.word & 0x0030)  == 0) sum++;
 			if((d1.word & 0x0060) == 0x0060
 				    || (d2.word & 0x0060)  == 0) sum++;
 			if((d1.word & 0x00c0) == 0x00c0
 				    || (d2.word & 0x00c0)  == 0) sum++;
 			if((d1.word & 0x0180) == 0x0180
 				    || (d2.word & 0x0180)  == 0) sum++;
 		}
 		for (j = 0; j < m; j++){
 			if((d1.bytel.h & s_bit[j]) == s_bit[j]
 					|| (d2.bytel.h | ~s_bit[j]) == ~s_bit[j]) sum++;
 		}
 	}
 	return sum ;
 }

 private void estimate_pattern(int sel)
 {
 	int	i, maxpoint;
 	int	max[][] =	{ 	{0,-32768},		
                                             /* Never make it static */
 							{0,-32768},
 							{0,-32768},
 						};
 						 
 	switch(modelNo) {
 	case MODEL1:
 	case MODEL2:
 		if (sel<0) {						/* Optimize data cell */
 			data_cell = Csize * Csize;
 			maxpoint = -32768;
 			full_mark = 20000 + BM_LONG1 * DEF_LONG5 + (BM_LONG1 + 2) * DEF_LONG7 + (BM_LONG1 + 3) * DEF_LONG8
 			+ BM_BLOCK * (DEF_BLOCK_W + DEF_BLOCK_B) + BM_PROH * DEF_PROHI;

 			for (i = 0; i < PATTERN12; i++) {
 				make_pattern(i, i);
 				

 	/*#ifdef REP1
 				dsp_mpattan();
 	#endif*/
 				point[i] = full_mark - check_block() * BM_BLOCK;
 				

 	/*#ifdef REP3
 				fprintf(stderr, "Pattern[%d]=%d\n", i, point[i]);
 	#endif*/
 				if (max[0][1] < point[i]){
 					max[2][0] = max[1][0]; max[2][1] = max[1][1];
 					max[1][0] = max[0][0]; max[1][1] = max[0][1];
 					max[0][0] = i;         max[0][1] = point[i];
 				} else {
 					if (max[1][1] < point[i]){
 						max[2][0] = max[1][0]; max[2][1] = max[1][1];
 						max[1][0] = i;         max[1][1] = point[i];
 					} else {
 						if (max[2][1] < point[i]){
 							max[2][0] = i; max[2][1] = point[i];
 						}
 					}
 				}
 			}
 			
 			for (i=0; i < SPAT; i++){
 				make_pattern(max[i][0], max[i][0]);
 				max[i][1] -= check_pattern(max[i][0]);
 	/*#ifdef REP3
 				fprintf(stderr, "point%d[%d,%d]\n", i+1, max[i][0],max[i][1]);
 	#endif*/
 			}

 			for (i=0; i < SPAT; i++){
 				if (maxpoint < max[i][1]) {
 					maxpoint = max[i][1];
 					pat_num = max[i][0];
 				}
 			}
 			
 			make_pattern(pat_num, pat_num);		
 												/* Re-generate optimal pattern */
 		} else {
 			make_pattern(sel, sel);				/* Apply masking */
 		}
 		break;
 	}
 }

 private int check_pattern(int n)
 {
 	int		k, m, bmark, rn,ratio;
 	int		cell_black;
 	int		/*num_first,*/ num_prohibit, cell_no_change;
 	int[]		num_long = new int[SMAX+1];
 	char[]		buff = new char[SMAX+2];
 	char[]dp;
 	int dpi = 0;
 	char		cbit;
 	char[] b_flag = new char[2];
 	int 	i,j;
 	char 	data,fl;

 	bmark = 0;					/* Score of the mask */
 	num_prohibit = 0;
 	for (i = 0; i <= (Csize - BND_LOW_LNG1)/3; i++)
 		num_long[i] = 0;		
 								/* Frequency that same color cells appear in series */
 	//num_first = 0;
 	cell_black = 0;

 	cbit = 0x01; b_flag[0] = 0x00; b_flag[1] = 0x01;

 	for (i = 0; i < Csize; i++) {		
 										/* Check in the horizontal direction */
 		cell_no_change = 0; dp = mcell[i]; dpi = 0;
 		k = 0 ; fl = 0; data = dp[dpi++]; buff[0] = 0;
 		if ((data & 0x01) != 0) {
 			k++;
 			fl = 1;
 		}
 		for (j = 1; j <= Csize; j++)	{	
 											/* Start with (j = 0) to check against prohibited pattern */
 	 	    if ((data & cbit) == b_flag[fl]) cell_no_change++;
 		    else {
 				if(fl != 0) cell_black += cell_no_change;
 				buff[k++] = (char) cell_no_change;
 				cell_no_change = 1; 
 				fl ^= 0x01;
 		    }
 			data = (char) (data >> 1);
 			if((j & 0x07) == 0) data = dp[dpi++];
 		}
 		buff[k] = (char) cell_no_change;

 		for (j = 0; j <= k; j++) {
 		    if (buff[j] >= BND_LOW_LNG1){	
 				        		/* No. of same color cells in series exceeds threshold 1 */
 			    bmark += (BM_LONG1 + (buff[j] - BND_LOW_LNG1));
 			    num_long[(buff[j] - BND_LOW_LNG1)/3]++; 
 		    }
 		}
 		
 							/* Check against prohibited pattern */
 		if (fl != 0)  k++;		/* Set up margin area */
 		buff[0] = 127; buff[k] = 127;		/* Set margin */
 		
 		for (j = 1; j <= k-5; j+=2) {
 			if(buff[j+1] != buff[j] ) continue;	
 												/* Compare with prohibited pattern */
 			if(buff[j+2] != (buff[j] * 3)) continue;
 			if(buff[j+3] != buff[j] ) continue;
 			if(buff[j+4] != buff[j] ) continue;
 			if(buff[j-1] >= (buff[j]*4) || buff[j+5] >= (buff[j]*4)) num_prohibit++;
 		}
 	}

 	for (i = 0; i < Csize; i++) {		
 										/* Check in the vertical direction  */
 		cell_no_change = 0; m = i /8 ;
 		k = 0 ; fl = 0; buff[0] = 0;
 		cbit = bitpos[i & 0x07];
 		b_flag[1] = cbit;
 		if ((mcell[0][m] & cbit) != 0){
 		    k++;
 			fl = 0x01;
 		}
 		for (j = 0; j < Csize; j++)	{	
 										/* Start with (j = 0) to check against prohibited pattern */
 	 	    if ((mcell[j][m] & cbit) == b_flag[fl]) cell_no_change++;	
 																/* Same color as preceding cell */
 		    else {
 				buff[k++] = (char) cell_no_change;
 				cell_no_change = 1;
 				fl ^= 0x01;
 		    }
 		}
 		buff[k] = (char) cell_no_change;

 		for (j = 0; j <= k; j++) {
 		    if (buff[j] >= BND_LOW_LNG1){	
 								/* No. of same color cells in series exeeds threshold 1 */
 			    bmark += (BM_LONG1 + (buff[j] - BND_LOW_LNG1));
 			    num_long[(buff[j] - BND_LOW_LNG1)/3]++;
 		    }
 		}
 		
 													
 													/* Check against prohibited pattern */
 		if (fl != 0)  k++;								
 													/* Set up margin area */
 		buff[0] = 127; buff[k] = 127;				/* Set margin */
 		for (j = 1; j <= k-5; j+=2) {
 			if(buff[j+1] != buff[j]) continue;		
 													/* Compare with prohibited pattern */
 			if(buff[j+2] != (buff[j]*3)) continue;
 			if(buff[j+3] != buff[j]) continue;
 			if(buff[j+4] != buff[j]) continue;
 			if(buff[j-1] >= (buff[j]*4) || buff[j+5] >= (buff[j]*4)) num_prohibit++;
 		}
 	}

 	bmark += BM_PROH * num_prohibit;

 	ratio = cell_black / (data_cell/100);
 	rn = (ratio - 50) / 5;
 	bmark += BM_RATIO * Math.abs(rn);
 	
 /*#ifdef REP
 	if (rn)
 		fprintf(stderr, "\t :ratio -%d <- %d \n", BM_RATIO * abs(rn), rn);

 #endif

 #ifdef REP2
     fprintf(stderr, "<%d>\n", n);
     for (i = 0; i <= (Csize - BND_LOW_LNG1)/3; i++)
 	    fprintf(stderr,"long_line[%d-%d] -> %d\n", (i * 3) + BND_LOW_LNG1, (i * 3) + BND_LOW_LNG1 + 2, num_long[i]);
 	fprintf(stderr, "num_first -> %d\n", num_first);
 	fprintf(stderr, "prohibit -> %d\n", num_prohibit);
 	fprintf(stderr, "ratio -> %d\n", (int)(ratio * 100));
     fprintf(stderr, "bmark=%d\n\n", bmark);
     
 #endif*/

 	return bmark;
  }
 
 
 /*-------------------------------------------------------qr5.c------------------------------------------------------------------------------------------------*/

 private char[][]	cell= new char[SMAX][(SMAX+7)/8];
 private char[][]	mcell= new char[SMAX][(SMAX+7)/8];
 
 private int END_DATA_MODE	= (MAXCHARMODE);

 private qrdata[] tQRmode = new qrdata[4];
 {
	 for(int i=0;i<4;i++)
	 {
		 tQRmode[i] = new qrdata();
		 tQRmode[i].bmode = 4;
	 }
 }
 private qrdata[] qrdp;
 private int qrdpi = 0;

 private static final int		c_byte[] = {1, 1, 1, 2, 0};				
                                                                 /* Byte No. for each mode */

 private static final char antble[] = {					/* Alphanumeric mode table */
 		/* space !	"  #  $	 %  &  '  (  )  *  +  ,  -  .  /	*/
 		      1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 1, 1, 0, 1, 1, 1,
 		/* 	  0	 1	2  3  4  5  6  7  8  9  :  ;  <  =  >  ?	*/
 			  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0,
 		/* 	  @  A  B  C  D  E  F  G  H  I  J  K  L  M  N  O	*/
 			  0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
 		/* 	  P  Q  R  S  T  U  V  W  X  Y  Z					*/
 			  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1
 };
 
 
 private char chk_mode(char []cdp, char []pEndBound, int pEndBoundi, int cdpi)						/* Mode check for data */
 {
 	char	c, c2, mode;
 	c = cdp[cdpi];	
 	if (c >= '0' && c <= '9') {
 		mode = NUMBER;    						/* Numeric mode */
 	} else if ((c >= ' ' && c <= 'Z') && antble[c-' '] != 0) {
 		mode = ALNUM; /* Alphanumeric mode */
 	} else if ((c >= 0x81 && c <= 0x9f)
 		|| (c >= 0xe0 && c <= 0xeb)){					
 												/* Kanji mode 0x81-0x9f,0xe0-0xea */
 												
 												/* However, if the first byte is 0xebbf, it's acceptable as long
 												   as the second byte is within the range of 0x40 to 0x7e and 0x80 to 0xbf */
 		
 		// Before looking at the next (second) byte to determine if this encoding is Kanji, make sure that we're not
 		// stepping outside the array boundary
 		/*if((cdp[cdpi + 1]) < pEndBound[pEndBoundi])*/
 		if(cdp.length > cdpi + 1)
 			c2 = (cdp[cdpi+1]);
 		else
 			// This will force a binary mode encoding, but it's very unlikely to happen, as we've already got the first
 			// byte stating this is a potential 2-byte character.
 			c2 = 0xff; 

 		// The conditions that determine a Kanji encoding are as follows:
 		// If the first byte is not 0xEB, the acceptable ranges for the second byte are 0x40 to 0x7E, and 0x80 to 0xFC.
 		// If the first byte is 0xEB, the acceptable ranges for the second byte are 0x40 to 0x7E, and 0x80 to 0xBF.
 		// Just checking the first byte, and making sure the second byte skips 0x7F from a range of 0x40 to 0xFC (or 0xBF)
 		// will be sufficient.
 		if((c != 0xeb && c2 >= 0x40 && c2 <= 0xfc && c2 != 0x7f) ||
 			(c == 0xeb && c2 >= 0x40 && c2 <= 0xbf && c2 != 0x7f)){
 																	/* Second byte: 0x40--0x7e,0x80-0xfc */
 				mode = KANJI;
 			} else {
 				mode = BINARY;
 			}
 		
 	} else {
 		mode = BINARY;					     		/* Binary mode */
 	}
 	return  mode;
 }


 /* Calculation of required bit No. (No. of indicator bits for each mode)
  */
 private int bit_indicator(char mode)
 {
 	int nbit = 0, niBit;

 	switch(modelNo) {
 	case MODEL1:
 	case MODEL2:
 		if (Cver < VERSIONLO)
 			niBit = 0;
 		else if (Cver < VERSIONMI)
 			niBit = 1;
 		else
 			niBit = 2;
 		nbit = (nch_indicate[niBit][mode] + 4); 
                                                 /* Digit No. bit, mode bit (=4) */
 		break;
 	}
 	return nbit;
 }



 /* Calculation of required bit No. (No. of length digits for each mode) */
 private int bit_calc(char mode, int length)		/* Calculation of data bit No. */
 {
 	int nbit = 0;
 	//extern int numrem[4];

 	switch(mode) {
 	case NUMBER:							/* Numeric mode */
 		nbit = (length/3)*10+numrem[length%3];
 		break;
 	case ALNUM:										/* Alphanumeric mode */
 		nbit = (length/2)*11+(length%2)*6;
 		break;
 	case BINARY:									/* Binary mode */
 		nbit = length*8;
 		break;
 	case KANJI:										/* Kanji mode */
 		nbit = ((length+1)/2)*13;
 		break;
 	}
 	nbit += bit_indicator(mode); /* + Digit No. bit, mode bit */
 	return nbit;
 }


 /* Decision of combined(gousei) mode */
 private char gouseiMode(char m1, char m2)
 {
 	int m12;
 	if (m1 > m2)
 		m12 = m1;
 	else
 		m12 = m2;
 	if ((m12 == KANJI) && (m1 != m2)) m12 = BINARY;	
                                                     /* If one block is Kanji, blocks are combined as binary */ 
 	return (char) m12;
 }
 
 /* 
  * Save the length of preceding one block, mode of current block, and character buffer pointer
  * in tentative block area (tQRmode)
  */
 private void save_d_inf(int level, char cmode, char[] savep, int index)
 {
	
	 if(tQRmode[level+1] == null)
		 tQRmode[level+1] = new qrdata();
 	tQRmode[level+1].bmode = cmode;					/* save mode */
 	tQRmode[level+1].fdatap = savep;
 	tQRmode[level+1].fdatapi = index - c_byte[cmode];/* save pointer */
 	tQRmode[level].blen = tQRmode[level+1].fdatapi - tQRmode[level].fdatapi;	/* Byte length */
 }

 
 /* Copy qrdata object */
 private void data_copy(qrdata rdata, qrdata sdata)
 {
 	rdata.bmode = sdata.bmode;			/* Mode copy */
 	rdata.fdatap = sdata.fdatap;			/* Pointer copy */
 	rdata.blen = sdata.blen;				/* Length copy */
 	rdata.fdatapi = sdata.fdatapi;

 }
 
 /* First block tQRmode[0] is decided */
 private void tQRmode0_decide()
 {
	 if(qrdp[qrdpi] == null)
		 qrdp[qrdpi] = new qrdata();
 	data_copy(qrdp[qrdpi++], tQRmode[0]);
 	data_copy(tQRmode[0], tQRmode[1]);
 	data_copy(tQRmode[1], tQRmode[2]);
 	data_copy(tQRmode[2], tQRmode[3]);
 	Blksu++;
 }

 
 /*****************************************************************
 Classification by character mode switching
  (1) When only one block is left, the first block is decided:
 			x,E

  (2) When only two blocks are left,
      judge which is minimum, combined mode of first and second blocks or isolated mode:
 			x,x,E
 	if (Combined mode of first and second blocks Â�Æ’ Isolated mode) then
 		Combined mode of first and second blocks is the same as character mode of first block. 
 	else
 		The first block is decided.

  (3) Judge which option is minimum:
      Combined mode of first, second, and third blocks/Combined mode of two of three blocks/Isolated mode
      Minimum one of switch (g123 g1+g23 g12+g3 g1+g2+g3)
 		case g123
 		if (m123==BINARY && g23<g2+g3 && m234=ALUM) then
 			Combine second and third blocks
 		else
 			Combine first and second blocks
 	case g1+g23
 	    Combine second and third blocks
 	case g12+g3
 		Combine first and second blocks
 	case g1+g2+g3
 		The first block is decided.
 	end switch
 	goto (2)

 /*
  * 
  */
 /* First block is accumulated and the mode of second block is identified
    if (Second block == Final block) then
    first block is decided
 */
 private int eval_L1()
 {
 	if (tQRmode[1].bmode == END_DATA_MODE) {
 		tQRmode0_decide();		/* Decide first block */
 		return 0;
 	} else {
 		return 1;					
                                     /* Wait until the next block is input */
 	}
 }

 
 /*
  * First and second blocks are accumulated and mode of third block is identified
  */
 private int eval_L2()
 {
 	int gousei, isolate;
 	char gmd;

 	if (tQRmode[2].bmode == END_DATA_MODE) {
 		gmd = gouseiMode(tQRmode[0].bmode, tQRmode[1].bmode);
 		gousei = bit_calc(gmd, tQRmode[0].blen + tQRmode[1].blen);
 		isolate = bit_calc(tQRmode[0].bmode, tQRmode[0].blen) + bit_calc(tQRmode[1].bmode, tQRmode[1].blen);
 		if (gousei <= isolate) {
 			tQRmode[0].bmode = 	gmd;	/* Composition */
 			tQRmode[0].blen += tQRmode[1].blen;
 			data_copy(tQRmode[1], tQRmode[2]);
 		} else {						/* Select isolated mode */
 			tQRmode0_decide();		/* Decide first block */
 		}
 		return eval_L1();		/* Process the left one block */
 	} else {
 		return 2;						/* Process after third block is  input */
 	}
 }

 
 /* First to third blocks are accumulated (1 block=3 block) and mode of forth block is identified */
 private int eval_L3()
 {
 	int g0, g1, g2, g01, g12, g012;
 	char md01, md12, md012;
 	
 	if (tQRmode[2].bmode == END_DATA_MODE) return eval_L2();

 	g0 = bit_calc(tQRmode[0].bmode, tQRmode[0].blen);
 	g1 = bit_calc(tQRmode[1].bmode, tQRmode[1].blen);
 	g2 = bit_calc(tQRmode[2].bmode, tQRmode[2].blen);
 	md01 = gouseiMode(tQRmode[0].bmode, tQRmode[1].bmode);
 	g01 =  bit_calc(md01, tQRmode[0].blen + tQRmode[1].blen);

 	md12 = gouseiMode(tQRmode[1].bmode, tQRmode[2].bmode);
 	g12 =  bit_calc(md12, tQRmode[1].blen + tQRmode[2].blen);

 	md012 = gouseiMode(md01, md12);
 	g012 = bit_calc(md012, tQRmode[0].blen + tQRmode[1].blen + tQRmode[2].blen);

 	
     /* Select the minimum one from the following combinations
         g012
 		g01 + g2
 		g0 + g12
 		g0 + g1 + g2
     */
 	if (g012 <= g01+g2) {
 		if ((g12 < g1+g2) && (g012 <= g0+g12) 
 		||  (g12 >= g1+g2) && (g012 <= g0+g1+g2)) {	/* g012 is minimum */
 			if (md012 == BINARY && g12 <= g1+g2
 			&&  gouseiMode(md12, tQRmode[3].bmode) == ALNUM) {	
        /* If first block is binary and subsequent three blocks can be combined as alphanumeric */
 				tQRmode[1].bmode = md12;			/* Combine last two blocks as alphanumeric */
 				tQRmode[1].blen += tQRmode[2].blen;
 				data_copy(tQRmode[2], tQRmode[3]);
 			} else {	
                         /* Not three but two blocks are combined 
                            so that the forth block can be estimated with the other blocks. */
 				tQRmode[0].bmode = 	md01;			/* Combine first two blocks */
 				tQRmode[0].blen += tQRmode[1].blen;
 				data_copy(tQRmode[1], tQRmode[2]);
 				data_copy(tQRmode[2], tQRmode[3]);
 			}
 		} else {									/* g0+g12 or g0+g1+g2 is minimum */
 			if (md12 != BINARY && g12 <= g1+g2) {	/* md12 is not binary and g0+g12 is munimum */
 				tQRmode[1].bmode = md12;			/* Combine last two blocks */
 				tQRmode[1].blen += tQRmode[2].blen;
 				data_copy(tQRmode[2], tQRmode[3]);
 			} else {
 				tQRmode0_decide();					
                                                     /* The first block is decided. Next block is binary or g0+g1+g2 is minimum */
 			}
 		}
 	} else {
 		if ((g12 < g1+g2) && (g01+g2 <= g0+g12) 
 		||  (g12 >= g1+g2) && (g01 <= g0+g1)	) {	/* g01+g2 is minimum */
 			tQRmode[0].bmode = md01;				/* Combine first two blocks */
 			tQRmode[0].blen += tQRmode[1].blen;
 			data_copy(tQRmode[1], tQRmode[2]);
 			data_copy(tQRmode[2], tQRmode[3]);
 		} else {	
                     /* g0+g12 or g0+g1+g2 is minimum. The first block is decided */
 			if (md12 != BINARY && g12 <= g1+g2) {	
                                             /* md12 is not binary and g0+g12 is minimum */
 				tQRmode[1].bmode = md12;			/* Combine last two blocks */
 				tQRmode[1].blen += tQRmode[2].blen;
 				data_copy(tQRmode[2], tQRmode[3]);
 			} else {
 				tQRmode0_decide();					
                             /* First block is decided. Next block is binary or g0+g1+g2 is minimum */
 			}
 		}
 	}
 	return eval_L2();		/* Process the left two blocks */
 }

 
 /*
  * Main routine of automatic input mode 
  */
 public int auto_conv(qrdata [] sqrdp, char []sfdp, char []scdp, int datasu)
 {
 	char	level;							/* Level of character string estimation */
 	int		i, s = 0, cnt;
 	char	/*c,*/ cmode;
 	char[]	fdp, cdp, fdpEnd;
 	int fdpi = 0, cdpi = 0, fdpendi = 0;
 	int		oldCver;

 	switch(modelNo) {
 	case MODEL1:
 	case MODEL2:
 		Cver = 0;		
                         /* Code version of model 1 and 2 is estimated from minimum=0 */
 		break;
 	}
 	for (i = 0; i < 4; i++) {	/* Escape after four or less loops */
 		oldCver = Cver;
 		Blksu = level = 0;
 		qrdp = sqrdp;
 		qrdpi = 0;
 		fdp = sfdp;
 		fdpi = 0;
        fdpEnd = fdp;
        fdpendi = fdpi + datasu;
 		cdp = scdp;
 		cdpi = 0;
 		cnt = datasu;			/* No. of characters */
 		for(int u=0;u<4;u++)
 		 {
 			 tQRmode[u] = new qrdata();
 			 tQRmode[u].bmode = 4;
 		 }
 		if(tQRmode[0] == null)
 			tQRmode[0] = new qrdata();
 		tQRmode[0].fdatap = cdp;
 		tQRmode[0].fdatapi = cdpi;
 		cmode = chk_mode(fdp, fdpEnd, fdpendi, cdpi);
 	//	c = fdp[fdpi++];
 		cnt--;
 		cdpi++;//cdp[cdpi++] = c;								/* data save */
 		if (cmode == KANJI)
         {
             if(fdpi < fdp.length)//fdp[fdpi] < fdpEnd[fdpendi])
             {
            	 cdpi++;
            	 fdpi++;
 			    //cdp[cdpi++] = fdp[fdpi++];	/* Second byte of Kanji */
 			    cnt--;
             }
             else
             {
                 cmode = BINARY;
             }
 		}
 		tQRmode[0].bmode = cmode;

 		for(s=1; cnt>0 && /* *fdp != EOF && */ s < DATAMAX && Blksu < BLKMAX; s++){			/* data read */
 			
 			cmode = chk_mode(fdp, fdpEnd, fdpendi, cdpi);
 		//	c = fdp[fdpi++];
 			cnt--;
 			cdpi++;//cdp[cdpi++] = c;								/* data save */
 			if (cmode == KANJI)
             {
                 if(fdpi < fdp.length)//fdp[fdpi] < fdpEnd[fdpendi])
                 {
                	 cdpi++;fdpi++;
 				    //cdp[cdpi++] = fdp[fdpi++];	/* Second byte of Kanji */
 				    cnt--;
                 }
                 else
                 {
                     cmode = BINARY;
                 }
 			}
 			if (tQRmode[level].bmode != cmode) {	/* mode change */
 				save_d_inf(level, cmode, cdp, cdpi);		/* Save character string information */
 				level++;
 				if (level == 3) {					
                                                     /* Three blocks are gathered. Estimation of character string  */
 					level = (char) eval_L3();
 				}
 			}
 		}
 	/*  end of data   */
 		save_d_inf(level, (char) END_DATA_MODE, cdp, cdpi);		/* Save character string information */
 		level++;
 		
 		switch(level){
 		case 1:	tQRmode0_decide();
 				break;
 		case 2: eval_L2();
 				break;
 		case 3: eval_L3();
 		}
 		switch(modelNo) {
 		case MODEL1:
 		case MODEL2:
 			
 			Cver = getversion12(Blksu, sqrdp, Clvl);		/* Decide code version of model 1 and 2 */
 			
 			if (Cver < VERSIONLO) {
 				oldCver = Cver;
 			} else if (Cver < VERSIONMI) {
 				if (oldCver >= VERSIONLO)
 					oldCver = Cver;
 			} else if (oldCver >= VERSIONMI) {
 				oldCver = Cver;
 			}
 			break;
 		}
 		if (oldCver==Cver || Cver<0) break;
 	}
 	return s;
 }
 
 /*---------------misc----------------------*/

}