/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2005 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */
package com.adobe.xfa.template.formatting;

import com.adobe.xfa.Attribute;
import com.adobe.xfa.Element;
import com.adobe.xfa.EnumAttr;
import com.adobe.xfa.EnumValue;
import com.adobe.xfa.Node;
import com.adobe.xfa.ProtoableNode;
import com.adobe.xfa.XFA;
import com.adobe.xfa.template.containers.Field;
import com.adobe.xfa.template.containers.Subform;

/**
 * An element that describes the constraints on keeping subforms
 * together within a page or content area
 *
 * @exclude from published api -- Mike Tardif, May 2006.
 */

public final class Keep extends ProtoableNode {

	public Keep(Element parent, Node prevSibling) {
		super(parent, prevSibling, null, XFA.KEEP, XFA.KEEP, null, XFA.KEEPTAG, XFA.KEEP);
	}

	public Attribute defaultAttribute(int eTag) {
		if (eTag == XFA.INTACTTAG) {
			// The default value of intact is "none" if the
			// parent container's layout is flowed
			// The default value of intact is "contentArea"
			// if the parent container's layout is positioned or row.
			// Basically this means subforms with layout=position (ie detail line)
			// and row subforms are not splitable by default.
			// New in xfa v2.8: fields and draws are splitable, or at least, controllable via the <keep> element.
			// Fields are splitable by default, for legacy reasons. Draws are not splitable by default, again for legacy reasons.
			int oIntact = EnumAttr.KEEP_CONTENTAREA;
			Element oParent = getXFAParent();
			if (oParent instanceof Subform) {
				int oLayout = oParent.getEnum(XFA.LAYOUTTAG);
				if (EnumAttr.POSITION != oLayout && EnumAttr.ROW != oLayout)
					oIntact = EnumAttr.KEEP_NONE;
			}
			else if (oParent instanceof Field) {
				oIntact = EnumAttr.KEEP_NONE;
			}
			return EnumValue.getEnum(XFA.INTACTTAG, EnumAttr.getEnum(oIntact));
		}

		// Not special case, so let the base class handle it
		return super.defaultAttribute(eTag);
	}
}
