package com.adobe.xfa.text;

import com.adobe.xfa.ut.FindBugsSuppress;

/**
 * @exclude from published api.
 */

public class TextCharPropDataIterator implements TextCharPropIterator {
	private int[] mData;
	private int mIndex;
	private int mLength;

	public TextCharPropDataIterator (int[] data) {
		this (data, 0);
	}

	public TextCharPropDataIterator (int[] data, int startIndex) {
		this (data, startIndex, data.length);
	}

	@FindBugsSuppress(code="EI2")
	public TextCharPropDataIterator (int[] data, int startIndex, int length) {
		mData = data;
		mIndex = startIndex;
		mLength = length;
	}

	public int first () {
		mIndex = 0;
		return 0;
	}

	public int next (int index) {
		mIndex = index;
		return next();
	}

	public int next () {
		if (mIndex >= mLength) {
			return TextCharProp.INVALID;
		}

		return interpretData (mData[mIndex++]);
	}

	public int getNextIndex () {
		return mIndex;
	}


	int interpretData (int dataValue) {
		return dataValue;
	}
}
