// =================================================================================================
// ADOBE SYSTEMS INCORPORATED
// Copyright 2011 Adobe Systems Incorporated
// All Rights Reserved
//
// NOTICE:  Adobe permits you to use, modify, and distribute this file in accordance with the terms
// of the Adobe license agreement accompanying it.
// =================================================================================================

package com.adobe.xmp.schema.model.rules;

import com.adobe.xmp.schema.model.SchemaVisitor;
import com.adobe.xmp.schema.model.TypeRule;
import com.adobe.xmp.schema.model.XMPSchemaException;


/**
 * The rule for boolean is always an EQUAL rule.
 * Only purpose is a Boolean property that has to be constantly either true or false
 * (or absent).
 * 
 * @author Stefan Makswit
 */
public class BooleanRule implements TypeRule
{
	private static final long serialVersionUID = 1L;
	/** check if a certain property is always <em>true</em> or <em>false</em> */
	private boolean operand;

	
	/**
	 * Constructs a new BooleanRule.
	 *
	 * @param value the expected value
	 */
	public BooleanRule(boolean value)
	{
		this.operand = value;
	}


	/**
	 * @return Returns the argument
	 */
	public boolean getOperand()
	{
		return this.operand;
	}
	
	
	/**
	 * @see com.adobe.xmp.schema.model.TypeRule#accept(com.adobe.xmp.schema.model.SchemaVisitor)
	 */
	public void accept(SchemaVisitor schemaVisitor) throws XMPSchemaException
	{
		schemaVisitor.visit(this);
	}
}
