/**************************************************************************
 *                                                                        *
 * ADOBE CONFIDENTIAL                                                     *
 * ___________________                                                    *
 *                                                                        *
 *  Copyright 2011 Adobe Systems Incorporated                             *
 *  All Rights Reserved.                                                  *
 *                                                                        *
 * NOTICE:  All information contained herein is, and remains              *
 * the property of Adobe Systems Incorporated and its suppliers,          *
 * if any.  The intellectual and technical concepts contained             *
 * herein are proprietary to Adobe Systems Incorporated and its           *
 * suppliers and are protected by trade secret or copyright law.          *
 * Dissemination of this information or reproduction of this material     *
 * is strictly forbidden unless prior written permission is obtained      *
 * from Adobe Systems Incorporated.                                       *
 **************************************************************************/
package com.adobe.xmp.schema.service;

import com.adobe.xmp.schema.service.defaults.DefaultSchemaCache;
import com.adobe.xmp.schema.service.impl.SchemaServiceImpl;


/**
 * Factory to create instances of {@link SchemaService}
 * 
 * @author Stefan Makswit
 */
public class SchemaServiceFactory
{
	/**
	 * Creates an instance of <code>SchemaService</code> that is configured
	 * with custom provider, cache and prefix mapping implementations. 
	 * 
	 * @param provider an instance of {@link RelaxNGProvider}
	 * @param cache an instance of {@link SchemaCache}
	 * 
	 * @return Returns a configured instance of {@link SchemaService}.
	 * @throws SchemaServiceException Thrown if parameters are null or initialization fails.
	 */
	public static SchemaService createInstance(
			RelaxNGProvider provider,
			SchemaCache cache) throws SchemaServiceException
	{
		return new SchemaServiceImpl(provider, cache);
	}

	
	/**
	 * Creates the default instance of <code>SchemaService</code>.
	 * It provides the schemas that are included in the library.
	 * 
	 * @return Returns an instance of the default {@link SchemaService}
	 * @throws SchemaServiceException Thrown if initialization fails.
	 */
	public static SchemaService createDefaultInstance() throws SchemaServiceException
	{
		return new SchemaServiceImpl(
			new StandardRelaxNGProvider(),
			new DefaultSchemaCache());
	}
}	