/*************************************************************************
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2006 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 **************************************************************************/
package com.day.commons.datasource.poolservice;

import java.util.Collection;

/**
 * Combines multiple DataSourcePoolProvider services into a single service that
 * gives access to preconfigured data sources.
 */
public interface DataSourcePool {

    /**
     * Return the named data source, if available
     *
     * @param name Configured name of the data source
     * @param desiredType, expected type (for example DataSource.class for a
     *            j2ee DataSource).
     * @return a data source object of the desired type, which must be properly
     *         closed or disposed of to be returned to the pool, according to
     *         the semantics of that data source type.
     * @throws DataSourceNotFoundException no data source found with supplied
     *             name.
     * @throws TypeNotAvailableException data source found but not compatible
     *             with desired type
     */
    <AdapterType> AdapterType getDataSource(String name,
            Class<AdapterType> desiredType) throws DataSourceNotFoundException,
            TypeNotAvailableException;

    /**
     * Return the named data source, if available, as an Object. Useful in
     * scripting languages where the actual type is checked by the language, for
     * other cases it is recommended to use the <AdapterType> getDataSource
     * method.
     *
     * @param name name of the data source
     * @return the datasource
     * @throws DataSourceNotFoundException if the data source is not found
     */
    Object getDataSource(String name) throws DataSourceNotFoundException;

    /**
     * Return the collection of all JNDI data sources available with the system.
     * Useful for tooling which wants to show all datasources in the system
     *
     * @return Collection of all JNDI Data Sources that are register with this
     *         Pool
     */
    Collection<String> getAllJndiDataSourceNames();
}
