/*
 * Copyright 1997-2011 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.dam.api;

import aQute.bnd.annotation.ProviderType;

/**
 * The <code>DamEventRecorder</code> specifies the possibility to record a given {@link DamEvent}. Implementations may
 * do so via OSGi-eventing or by directly calling the {@link #record(DamEvent)} method for events that must be recorded
 * without the potential eventing-related delay between event issuance and persistence. Events are generally recorded
 * using the {@link com.day.cq.activitystreams.api.ActivityService}.
 */
@ProviderType
public interface DamEventRecorder {

    /**
     * Submit the given <code>damEvent</code> for recording.
     *
     * @param damEvent The {@link DamEvent} to record.
     */
    void record(DamEvent damEvent);

    /**
     * A getter method to get the status of DamEventRecorder service
     * @return true if the DamEventRecorder service is enabled else false
     */
    public boolean isEnabled();
}
