/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2017 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.day.cq.dam.api.metadata;

import java.util.Set;

import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;

import aQute.bnd.annotation.ProviderType;

/**
 * Base class for handling runtime rendering of resources
 * after application of rules residing on them
 */
@ProviderType
public interface ComponentHandler {

    String REGISTERED_COMPONENTS = "registered.components";

    String GENERIC_HANDLER_PATH = "any";

    String SOURCE_VALUE = "srcValue";

    String RULE_BASED = "ruleBased";

    String CHOICES_CASCADING_PARAM = "choicesCascading";

    String CASCADE_FROM_VALUE = "cfvalue";

    /**
     * @return A set of component paths for which this handler should be called.
     */
    Set<String> getPaths();

    /**
     * @param request client request
     * @return Returns a synthetic resource which may have different properties/children
     * as compared to the actual resource.
     */
    Resource handle(SlingHttpServletRequest request);
}
