/*
 * Copyright 1997-2010 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.personalization.tags;

import com.adobe.granite.xss.XSSAPI;
import com.day.cq.personalization.ClientContextUtil;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.scripting.SlingBindings;
import org.apache.sling.scripting.jsp.util.TagUtil;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.TagSupport;
import java.io.IOException;

/**
 * Implements the <code>&lt;personalisation:contextProfileProperty/&gt;</code> tag AdobePatentID="B1393"
 */
public class ContextProfilePropertyTag extends TagSupport {

    private static final long serialVersionUID = 4646561799994266940L;

    private String propertyName;
    private String store;
    private String prefix;
    private String suffix;

    @Override
    public void setPageContext(PageContext pageContext) {
        super.setPageContext(pageContext);
        propertyName = null;
        store = "profile";
        prefix = "";
        suffix = "";
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public void setStore(String store) {
        this.store = store;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    @Override
    public int doEndTag() throws JspException {
        final JspWriter out = pageContext.getOut();
        final SlingHttpServletRequest request = TagUtil.getRequest(pageContext);
        try {
            out.println(getScript(request));

        } catch (IOException e) {
            throw new JspException("Could not write script for context profile property", e);
        }

        return EVAL_PAGE;
    }

    String getScript(SlingHttpServletRequest request) {
        SlingBindings bindings = (SlingBindings) request.getAttribute(SlingBindings.class.getName());
        XSSAPI xssAPI = bindings.getSling().getService(XSSAPI.class).getRequestSpecificAPI(request);

        StringBuilder res = new StringBuilder();

        String id = store + "-" + propertyName + "-" + ClientContextUtil.getId(request.getResource().getPath());

        res.append("<span id=\"").append(xssAPI.encodeForHTMLAttr(id)).append("\">").append("</span>");

        res.append("<script type=\"text/javascript\">\n");
        res.append("if( window.CQ_Analytics ) {");
        res.append("CQ_Analytics.ClientContextUtils.renderStoreProperty(");
        res.append("'").append(xssAPI.encodeForJSString(id)).append("',");
        res.append("'").append(xssAPI.encodeForJSString(store)).append("',");
        res.append("'").append(xssAPI.encodeForJSString(propertyName)).append("',");
        res.append("'").append(xssAPI.encodeForJSString(prefix)).append("',");
        res.append("'").append(xssAPI.encodeForJSString(suffix)).append("',");
        res.append("'").append("").append("'");
        res.append(");");
        res.append("}");
        res.append("</script>");

        return res.toString();
    }
}
