/*
 * Copyright 1997-2010 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */

package com.day.cq.reporting;

/**
 * This interface must be implemented by each aggregate's implementation.
 */
public interface Aggregate {

    /**
     * Resets the aggregate to its initial state.
     */
    void reset();

    /**
     * Determines if the aggregate requires distinct values.
     *
     * @return <code>true</code> if the aggregate uses distinct values for calculation
     */
    boolean useDistinctValues();

    /**
     * Aggregates the specified value.
     *
     * @param valueToAggregate The value to aggregate
     */
    void aggregateValue(CellValue valueToAggregate);

    /**
     * Returns the aggregated value.
     *
     * @param report The report
     * @return The aggregated value
     */
    CellValue getAggregatedValue(Report report);

    /**
     * Returns the totalled aggregate value for the entire column, if available.
     *
     * @param report The report
     * @return The totalled aggregate value; <code>null</code> if no totalled aggregate
     *         value is available
     */
    CellValue getColumnTotal(Report report);

    /**
     * Returns the data type of aggregated values.
     *
     * @return The data type
     */
    String getAggregatedType();

}
