/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.search;

import javax.jcr.RepositoryException;
import java.util.List;

/**
 * <code>Trends</code> gives access to search trend data.
 */
public interface Trends {

    public List<Query> getQueries() throws RepositoryException;

    /**
     * @return the minimum font size
     */
    public int getMinSize();

    /**
     * @param minSize the new minimal font size
     */
    public void setMinSize(int minSize);

    /**
     * @return the maximum font size.
     */
    public int getMaxSize();

    /**
     * @param maxSize the new maximum font size.
     */
    public void setMaxSize(int maxSize);

    /**
     * @return the maximum number of queries to return.
     */
    public int getMaxQueries();

    /**
     * @param maxQueries the new maximum number of queries to return.
     */
    public void setMaxQueries(int maxQueries);

    public interface Query {
        
        String getQuery();

        int getSize();
    }
}
