/*************************************************************************
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2019 Adobe
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 **************************************************************************/
package com.day.cq.wcm.foundation.model;

import java.util.Map;

import org.apache.sling.api.resource.Resource;
import org.osgi.annotation.versioning.ConsumerType;


/**
 * Public, Sling Model Interface to be used in HTLs.
 */
@ConsumerType
public interface AllowedComponents {

    /**
     * All css classes to be used on the Allowed Components DOM container
     * @return css classes
     */
    String getCssClass();

    /**
     * All css classes to be used on a single Allowed Component DOM node
     * @return css classes
     */
    String getPlaceholderCssClass();

    /**
     * The resource path of the Placeholder that should be used to list each of the Allowed Components in the DOM
     * @return resource type of Placeholder
     */
    String getPlaceholderResourceType();

    /**
     * Sorted (by Resource's Component Title) Map of all Allowed Components for the given Resource:
     * <ul>
     *     <li>
     *         key - synthetic path to the single Allowed Component
     *     </li>
     *     <li>
     *         value - resource representing single Allowed Component
     *     </li>
     * </ul>
     * @return Map of Resources with Paths as a keys
     */
    Map<String, Resource> getResourcesMap();

    /**
     * Title of the Component represented by the given Resource, to be used in the Allowed Components DOM container
     * @return title
     */
    String getTitle();

    /**
     * Is the given resource contained by a page, with authored template structure,
     * and is the given resource set as editable (unlocked)
     * @return true if the template has structure support and the resource is editable, false otherwise
     */
    boolean isApplicable();

}
