/*
 * Copyright (C) 2004-2011
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package org.kohsuke.rngom.rngparser.parse.host;

import org.kohsuke.rngom.rngparser.ast.builder.Annotations;
import org.kohsuke.rngom.rngparser.ast.builder.BuildException;
import org.kohsuke.rngom.rngparser.ast.builder.DataPatternBuilder;
import org.kohsuke.rngom.rngparser.ast.om.Location;
import org.kohsuke.rngom.rngparser.ast.om.ParsedElementAnnotation;
import org.kohsuke.rngom.rngparser.ast.om.ParsedPattern;
import org.kohsuke.rngom.rngparser.parse.Context;

/**
 * 
 * @author
 *      Kohsuke Kawaguchi (kk@kohsuke.org)
 */
final class DataPatternBuilderHost extends Base implements DataPatternBuilder {
    final DataPatternBuilder lhs;
    final DataPatternBuilder rhs;
    
    DataPatternBuilderHost( DataPatternBuilder lhs, DataPatternBuilder rhs ) {
        this.lhs = lhs;
        this.rhs = rhs;
    }

    public void addParam(String name, String value, Context context, String ns, Location _loc, Annotations _anno) throws BuildException {
        LocationHost loc = cast(_loc);
        AnnotationsHost anno = cast(_anno);
        
        lhs.addParam( name, value, context, ns, loc.lhs, anno.lhs );
        rhs.addParam( name, value, context, ns, loc.rhs, anno.rhs );
    }

    public void annotation(ParsedElementAnnotation _ea) {
        ParsedElementAnnotationHost ea = (ParsedElementAnnotationHost) _ea;
        
        lhs.annotation(ea.lhs);
        rhs.annotation(ea.rhs);
    }

    public ParsedPattern makePattern(Location _loc, Annotations _anno) throws BuildException {
        LocationHost loc = cast(_loc);
        AnnotationsHost anno = cast(_anno);
        
        return new ParsedPatternHost(
            lhs.makePattern( loc.lhs, anno.lhs ),
            rhs.makePattern( loc.rhs, anno.rhs ));
    }

    public ParsedPattern makePattern(ParsedPattern _except, Location _loc, Annotations _anno) throws BuildException {
        ParsedPatternHost except = (ParsedPatternHost) _except;
        LocationHost loc = cast(_loc);
        AnnotationsHost anno = cast(_anno);
        
        return new ParsedPatternHost(
            lhs.makePattern(except.lhs, loc.lhs, anno.lhs),
            rhs.makePattern(except.rhs, loc.rhs, anno.rhs));
    }
}
