/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.contentinsight;

import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.osgi.annotation.versioning.ProviderType;

/**
 * A <code>ProviderSettingsProvider</code> provides required settings for
 * Content Insight provider implementations, e.g. remote service URLs or
 * authentication tokens. 
 */
@ProviderType
public interface ProviderSettingsProvider {

    /**
     * Get the provider's unique name.
     * 
     * @return Unique provider name.
     */
    public String getName();

    /**
     * Get the settings for a resource, e.g. a page.
     * 
     * @param resource Resource to get settins for
     * @return Settings for specified resource.
     */
    public ValueMap getSettings(Resource resource);

    /**
     * Check if provider is active for the given resource.
     * 
     * @param resource Resource to check
     * @return {@code true} if provider is active for given resource,
     *         {@code false} otherwise.
     */
    public boolean isActive(Resource resource);
}
