/*
 *
 *	File: DirectoryWalker.java
 *
 * ****************************************************************************
 *
 *	ADOBE CONFIDENTIAL
 *	___________________
 *
 *	Copyright 2004-2005 Adobe Systems Incorporated
 *	All Rights Reserved.
 * 
 *	NOTICE: All information contained herein is, and remains the property of
 *	Adobe Systems Incorporated and its suppliers, if any. The intellectual
 *	and technical concepts contained herein are proprietary to Adobe Systems
 *	Incorporated and its suppliers and may be covered by U.S. and Foreign
 *	Patents, patents in process, and are protected by trade secret or
 *	copyright law. Dissemination of this information or reproduction of this
 *	material is strictly forbidden unless prior written permission is obtained
 *	from Adobe Systems Incorporated.
 *
 */
package com.adobe.fontengine.fontmanagement;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.List;

/**
 * DirectoryWalker
 */
final class DirectoryWalker {
    private List fileList;
    private final boolean recurse;
    
    DirectoryWalker(File r, boolean recurse)
    { 
        this.recurse = recurse;
        if (r.isDirectory())
        {
            File[] list = r.listFiles(new FileFilter() {
            	// exclude any that aren't files or directories - file mapped i/o etc.
				public boolean accept(File file) {return (file.isFile() || file.isDirectory());}
			});
            fileList = new ArrayList(list.length);
            
            for (int i = 0; i < list.length; i++)
                fileList.add(list[i]);
            
        } else 
        {
            fileList = new ArrayList(1);
            fileList.add(r);
        }
    }
    
    File getNextFile()
    {
        while (true)
        {
	        if (fileList.isEmpty())
	            return null;
	               
	        File nextFile = (File)fileList.remove(fileList.size()-1);
	        if (recurse && nextFile.isDirectory())
	        {
	            File[] list = nextFile.listFiles();
	            for (int i = 0; i < list.length; i++)
	                fileList.add(list[i]);
	            
	            
	            return getNextFile();
	        } else if (!nextFile.isDirectory())
	            return nextFile;
        }
    }

}
