/*************************************************************************
 *
 *	File: PDF417EncoderErrorCode.java
 *
 **************************************************************************
 * 
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.xfa.pmp.adobepdf417pmp;

/**
 * PDF417 Error codes
 */
public enum PDF417EncoderErrorCode {
	UNKNOWN("UNKNOWN"), MESSAGE_TOO_BIG("MESSAGE_TOO_BIG"), IMAGE_TOO_SMALL(
			"IMAGE_TOO_SMALL"), TOO_MANY_ROWS("TOO_MANY_ROWS"), TOO_MANY_COLS(
			"TOO_MANY_COLS"), SYMBOL_TOO_BIG("SYMBOL_TOO_BIG"), RESOLUTION(
			"RESOLUTION"), ECC("ECC"), WIDTH("WIDTH"), HEIGHT("HEIGHT"), XSYMWIDTH(
			"XSYMWIDTH"), XSYMHEIGHT("XSYMHEIGHT"), NCODEWORDROW("NCODEWORDROW"), NCODEWORDCOL(
			"NCODEWORDCOL");

	private PDF417EncoderErrorCode(String message) {
		this.message = message;
	}

	private String message;

	public String toString() {
		return message;
	}
}
