/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2021 Adobe
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 **************************************************************************/

package com.day.cq.analytics.sitecatalyst.util;

import com.adobe.granite.crypto.CryptoSupport;
import com.day.cq.analytics.sitecatalyst.SitecatalystHttpClient;
import com.day.cq.analytics.sitecatalyst.AbstractApiAdapter;
import com.day.cq.analytics.sitecatalyst.ImsApiAdapter;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import java.util.Map;

@Component
public class ApiAdapterFactoryImpl implements ApiAdapterFactory {

    @Reference
    private WebService apiService;

    @Reference
    private SitecatalystHttpClient legacyApiService;

    @Reference
    private CryptoSupport cryptoSupport;

    @Reference
    private TokenProviderProxy tokenProviderProxy;


    @Override
    public AbstractApiAdapter createImsAdapter(Map configuration) {
        return new ImsApiAdapter(configuration, apiService, tokenProviderProxy);
    }
}

