/*************************************************************************
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2019 Adobe
 *  All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 **************************************************************************/
package com.day.cq.commons.servlets;

import org.apache.sling.servlets.post.HtmlResponse;

/**
 * Factory for creating status responses for html requests.
 */
final public class HtmlStatusResponseFactory {

    private HtmlStatusResponseFactory() {
    }

    /**
     * Create a html status response
     *
     * @param success <code>true</code> if action succeeded
     * @param message Action/error message
     * @param path    path of the "modified" page
     *
     * @return the html response
     */
    public static HtmlResponse createStatusResponse(boolean success,
                                                    String message, String path) {
        return createStatusResponse(success ? 200 : 500, message, path);
    }

    /**
     * Create a html status response
     *
     * @param status status code
     * @param message Action/error message
     * @param path    path of the "modified" page
     *
     * @return the html response
     */
    public static HtmlResponse createStatusResponse(int status, String message,
                                                    String path) {
        final HtmlResponse response = new HtmlResponse();
        if (path != null) {
            response.setPath(path);
            response.setLocation(path);
            final int pos = path.lastIndexOf('/');
            response.setParentLocation(path.substring(0, pos));
        }
        response.setStatus(status, message);
        if (status < 400) {
            response.setTitle("OK");
        } else {
            response.setTitle(" Error");
        }
        return response;
    }

    /**
     * Create a html status response
     *
     * @param success <code>true</code> if action succeeded
     * @param message Action/error message
     *
     * @return the html response
     */
    public static HtmlResponse createStatusResponse(boolean success, String message) {
        return createStatusResponse(success, message, null);
    }

    /**
     * Create a html status response
     *
     * @param status http status code
     * @param message Action/error message
     *
     * @return the html response
     */
    public static HtmlResponse createStatusResponse(int status, String message) {
        return createStatusResponse(status, message, null);
    }

    /**
     * Create a html status response
     *
     * @param success <code>true</code> if action succeeded
     * @param messages Action/error messages
     * @param paths    paths of the "modified" page
     *
     * @return the html response
     */
    public static HtmlResponse createStatusResponse(boolean success,
                                                    String[] messages,
                                                    String paths[]) {
        final StringBuffer buffer = new StringBuffer();
        for (final String msg : messages) {
            buffer.append(msg).append('\n');
        }
        return createStatusResponse(success, buffer.toString(), (paths != null && paths.length > 0 ? paths[0]: null));
    }
}