/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2022 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.day.cq.personalization;

import java.util.ArrayList;

public class SegmentOperators {
    private final String EQUAL_OPERATOR = "==";
    private final String NOT_EQUAL_OPETOR = "!=";
    private final String GREATER_THAN_OPERATOR = ">";
    private final String GREATER_OR_EQUAL_OPERATOR = ">=";
    private final String LESS_THAN_OPERATOR = "<" ;
    private final String LESS_OR_EQUAL = "<=";
    


    private  ArrayList<String> operatorList;

    public SegmentOperators() {

        operatorList = new ArrayList<String>();
        operatorList.add(EQUAL_OPERATOR);
        operatorList.add(NOT_EQUAL_OPETOR);
        operatorList.add(GREATER_THAN_OPERATOR);
        operatorList.add(GREATER_OR_EQUAL_OPERATOR);
        operatorList.add(LESS_THAN_OPERATOR);
        operatorList.add(LESS_OR_EQUAL);

    }

    public String getOpString (String opString) {

        if (operatorList.contains(opString))
            return opString;
        return EQUAL_OPERATOR;

    }

}
