/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.cff;

import com.adobe.agl.util.ULocale;
import com.adobe.fontengine.font.CScan;
import com.adobe.fontengine.font.CatalogDescription;
import com.adobe.fontengine.font.CodePage;
import com.adobe.fontengine.font.CoolTypeScript;
import com.adobe.fontengine.font.EmbeddingPermission;
import com.adobe.fontengine.font.FontData;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.LineMetrics;
import com.adobe.fontengine.font.Matrix;
import com.adobe.fontengine.font.OrigFontType;
import com.adobe.fontengine.font.OutlineConsumer;
import com.adobe.fontengine.font.Permission;
import com.adobe.fontengine.font.ROS;
import com.adobe.fontengine.font.Rect;
import com.adobe.fontengine.font.SWFFont4Description;
import com.adobe.fontengine.font.SWFFontDescription;
import com.adobe.fontengine.font.Scaler;
import com.adobe.fontengine.font.ScanConverter;
import com.adobe.fontengine.font.Subset;
import com.adobe.fontengine.font.UnderlineMetrics;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.XDCFontDescription;
import com.adobe.fontengine.font.cff.CFFScaler;
import com.adobe.fontengine.font.cff.CharStrings;
import com.adobe.fontengine.font.cff.Dict;
import com.adobe.fontengine.font.cff.NameKeyedFont;
import com.adobe.fontengine.font.cff.StringIndex;
import com.adobe.fontengine.font.cff.Type2CStringGenerator;
import com.adobe.fontengine.font.cff.Type2GlyphBBoxCalculator;
import com.adobe.fontengine.font.cff.Type2OutlineParser;
import com.adobe.fontengine.font.postscript.NameHeuristics;
import com.adobe.fontengine.fontmanagement.CacheSupportInfo;
import com.adobe.fontengine.fontmanagement.Platform;
import com.adobe.fontengine.fontmanagement.fxg.FXGFontDescription;
import com.adobe.fontengine.fontmanagement.platform.PlatformFontDescription;
import com.adobe.fontengine.fontmanagement.postscript.PostscriptFontDescription;
import com.adobe.fontengine.inlineformatting.css20.CSS20Attribute;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;

public abstract class CFFFont
extends FontData {
    protected final StringIndex stringIndex;
    protected final CharStrings globalSubrs;
    protected final String name;
    protected final Dict topDict;

    CFFFont(StringIndex stringIndex, CharStrings globalSubrs, Dict topDict, String name, byte[] digest) throws UnsupportedFontException, InvalidFontException {
        super(digest);
        this.stringIndex = stringIndex;
        this.globalSubrs = globalSubrs;
        this.topDict = topDict;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public abstract Matrix getFontMatrix();

    @Override
    public double getUnitsPerEmX() throws UnsupportedFontException, InvalidFontException {
        return 1.0 / this.getFontMatrix().a;
    }

    @Override
    public double getUnitsPerEmY() throws UnsupportedFontException, InvalidFontException {
        return 1.0 / this.getFontMatrix().d;
    }

    @Override
    public boolean getCoolTypeProportionalRomanFromFontProperties() throws InvalidFontException {
        return !this.isFixedPitch();
    }

    @Override
    public CoolTypeScript getCoolTypeScript() throws UnsupportedFontException {
        ROS ros = this.getROS();
        CoolTypeScript ctScript = CoolTypeScript.fromWellKnownROS(ros);
        if (ctScript != null) {
            return ctScript;
        }
        ctScript = CoolTypeScript.fromAnyROS(ros);
        if (ctScript != null) {
            return ctScript;
        }
        return CoolTypeScript.ROMAN;
    }

    private Rect getCoolTypeIdeoEmBoxFromCapHeight() throws InvalidFontException, UnsupportedFontException {
        double capHeight = this.getCoolTypeCapHeight();
        if (Double.isNaN(capHeight)) {
            return null;
        }
        double unitsPerEmX = this.getUnitsPerEmX();
        double unitsPerEmY = this.getUnitsPerEmY();
        double ymin = -(unitsPerEmY - capHeight) / 2.0;
        return new Rect(0.0, ymin, unitsPerEmX, ymin + unitsPerEmY);
    }

    @Override
    public Rect getCoolTypeIdeoEmBox() throws InvalidFontException, UnsupportedFontException {
        if (this.useCoolTypeCJKHeuristics()) {
            Rect r = this.getCoolTypeIdeoEmBoxFromFullBoxCharacter();
            if (r != null) {
                return r;
            }
            r = this.getCoolTypeIdeoEmBoxFromTypicalCharacter();
            if (r != null) {
                return r;
            }
        } else {
            Rect r = this.getCoolTypeIdeoEmBoxFromCapHeight();
            if (r != null) {
                return r;
            }
        }
        double unitsPerEmX = this.getUnitsPerEmX();
        double unitsPerEmY = this.getUnitsPerEmY();
        return new Rect(0.0, -0.12 * unitsPerEmY, unitsPerEmX, 0.88 * unitsPerEmY);
    }

    @Override
    public Rect getCoolTypeIcfBox() throws InvalidFontException, UnsupportedFontException {
        Rect ideoEmBox = this.getCoolTypeIdeoEmBox();
        Rect r = this.getCoolTypeIcfBoxFromTypicalCharacter(ideoEmBox);
        if (r != null) {
            return r;
        }
        return this.getCoolTypeIcfBoxFromIdeoEmBox(ideoEmBox);
    }

    @Override
    public UnderlineMetrics getCoolTypeUnderlineMetrics() throws UnsupportedFontException, InvalidFontException {
        return this.getCoolTypeUnderlineMetrics(this.getCoolTypeUnitsPerEm(), this.getUnitsPerEmY());
    }

    public UnderlineMetrics getCoolTypeUnderlineMetrics(double coolTypeUnitsPerEm, double unitsPerEmY) throws UnsupportedFontException, InvalidFontException {
        double position = this.topDict.get(Dict.NumbersKey.UnderlinePosition, true).getFirstValueAsDouble();
        double thickness = this.topDict.get(Dict.NumbersKey.UnderlineThickness, true).getFirstValueAsDouble();
        return new UnderlineMetrics(position * unitsPerEmY / coolTypeUnitsPerEm, thickness * unitsPerEmY / coolTypeUnitsPerEm);
    }

    @Override
    public abstract int getGlyphForChar(int var1) throws InvalidFontException, UnsupportedFontException;

    @Override
    public abstract double getHorizontalAdvance(int var1) throws InvalidFontException, UnsupportedFontException;

    public abstract String getGlyphName(int var1) throws InvalidFontException, UnsupportedFontException;

    @Override
    public abstract void getGlyphOutline(int var1, OutlineConsumer var2) throws InvalidFontException, UnsupportedFontException;

    public abstract void getOutline(int var1, Type2OutlineParser var2, OutlineConsumer var3) throws InvalidFontException, UnsupportedFontException;

    @Override
    public Rect getGlyphBBox(int gid) throws UnsupportedFontException, InvalidFontException {
        Matrix m = new Matrix(this.getUnitsPerEmX(), 0.0, 0.0, this.getUnitsPerEmY(), 0.0, 0.0);
        return new Type2GlyphBBoxCalculator(m).calculateBBox(this, gid);
    }

    public abstract int getGlyphCid(int var1) throws InvalidFontException, UnsupportedFontException;

    @Override
    public Scaler getScaler(ScanConverter c) throws InvalidFontException, UnsupportedFontException {
        if (c == null) {
            c = new CScan(false, 1.0, true);
        }
        return new CFFScaler(this, c);
    }

    public abstract double getStemVForGlyph(int var1) throws InvalidFontException;

    abstract double getItalicAngle();

    abstract Rect getRawFontBBox();

    abstract int[] getXUID();

    abstract String getNotice();

    abstract String getCopyright();

    abstract String getFullName();

    abstract Integer getFSType();

    abstract int getFirstChar() throws InvalidFontException, UnsupportedFontException;

    abstract int getLastChar() throws InvalidFontException, UnsupportedFontException;

    abstract OrigFontType getOrigFontType();

    Permission getEmbeddingPermissionGivenFT(boolean wasEmbedded, OrigFontType thisFontType) {
        Integer fsType = this.getFSType();
        if (fsType != null) {
            return EmbeddingPermission.interpretFSType(fsType);
        }
        OrigFontType oft = this.getOrigFontType();
        if (oft == OrigFontType.kTYPE1 || oft == null && thisFontType == OrigFontType.kTYPE1) {
            return EmbeddingPermission.getType1DefaultPermission(this.getNotice(), this.getName());
        }
        if (wasEmbedded) {
            return EmbeddingPermission.getDefaultWasEmbeddedPermission();
        }
        if (oft == OrigFontType.kCID || oft == null && thisFontType == OrigFontType.kCID) {
            return EmbeddingPermission.getCIDDefaultPermission(this.getXUID());
        }
        if (oft == OrigFontType.kTRUETYPE) {
            return EmbeddingPermission.getTrueTypeDefaultPermission();
        }
        return EmbeddingPermission.getOCFDefaultPermission();
    }

    @Override
    public Set getCSSFamilyNames() {
        HashSet<String> s = new HashSet<String>();
        String n = this.getPreferredCSSFamilyName();
        if (n != null) {
            s.add(n);
        }
        return s;
    }

    @Override
    public String getPreferredCSSFamilyName() {
        Dict.StringValue v = this.topDict.get(Dict.StringKey.FamilyName, false);
        return v != null ? v.value : this.name;
    }

    @Override
    public boolean isCSSStyleNormal() {
        return !this.isCSSStyleItalic();
    }

    public boolean isFixedPitch() {
        Dict.NumbersValue v = this.topDict.get(Dict.NumbersKey.isFixedPitch, true);
        return v != null && v.getFirstValueAsDouble() != 0.0;
    }

    @Override
    public boolean isCSSStyleItalic() {
        Dict.NumbersValue v = this.topDict.get(Dict.NumbersKey.ItalicAngle, true);
        return v != null && v.getFirstValueAsDouble() != 0.0;
    }

    @Override
    public boolean isCSSStyleOblique() {
        return this.isCSSStyleItalic();
    }

    @Override
    public boolean isCSSVariantNormal() {
        return !this.isCSSVariantSmallCaps();
    }

    @Override
    public boolean isCSSVariantSmallCaps() {
        String n;
        Dict.StringValue v = this.topDict.get(Dict.StringKey.FullName, true);
        String string = n = v != null ? v.value : this.name;
        if (n == null) {
            return false;
        }
        return NameHeuristics.fullNameIndicatesSmallCaps(n);
    }

    @Override
    public int getCSSWeight() {
        String n;
        Dict.StringValue v = this.topDict.get(Dict.StringKey.Weight, true);
        if (v != null) {
            return NameHeuristics.weightNameToWeight(v.value);
        }
        v = this.topDict.get(Dict.StringKey.FullName, true);
        String string = n = v != null ? v.value : this.name;
        if (n != null) {
            return NameHeuristics.fullNameToWeight(n);
        }
        return 400;
    }

    @Override
    public CSS20Attribute.CSSStretchValue getCSSStretchValue() {
        Dict.StringValue fullName = this.topDict.get(Dict.StringKey.FullName, true);
        String n = fullName != null ? fullName.value : this.name;
        Dict.StringValue familyName = this.topDict.get(Dict.StringKey.FamilyName, true);
        if (n != null) {
            return NameHeuristics.fullNameToWidth(n, familyName != null ? familyName.value : null);
        }
        return CSS20Attribute.CSSStretchValue.NORMAL;
    }

    @Override
    public CacheSupportInfo getCacheSupportInfo() throws InvalidFontException, UnsupportedFontException {
        return new CacheSupportInfo(this.getClass().getSimpleName(), this.getNumGlyphs(), true);
    }

    @Override
    public PostscriptFontDescription[] getPostscriptFontDescription() {
        String fontName = this.getName();
        if (this.name != null) {
            return new PostscriptFontDescription[]{new PostscriptFontDescription(fontName)};
        }
        return new PostscriptFontDescription[0];
    }

    @Override
    public FXGFontDescription[] getFXGFontDescription(Platform platform, ULocale locale) throws InvalidFontException, UnsupportedFontException {
        return new FXGFontDescription[0];
    }

    @Override
    public PlatformFontDescription[] getPlatformFontDescription(Platform platform, ULocale locale) throws InvalidFontException, UnsupportedFontException {
        return new PlatformFontDescription[0];
    }

    public abstract ROS getROS();

    @Override
    public SWFFontDescription getSWFFontDescription(boolean wasEmbedded) throws UnsupportedFontException, InvalidFontException {
        return new CFFSWFFont3Description(wasEmbedded);
    }

    @Override
    public void subsetAndStream(Subset subset, OutputStream os, boolean preserveROS) throws InvalidFontException, UnsupportedFontException, IOException {
        this.subsetAndStream(subset, os, preserveROS, null);
    }

    public abstract void stream(OutputStream var1, Integer var2) throws InvalidFontException, UnsupportedFontException, IOException;

    public abstract void subsetAndStream(Subset var1, OutputStream var2, boolean var3, Integer var4) throws InvalidFontException, UnsupportedFontException, IOException;

    abstract CharStrings getCharStrings();

    abstract CharStrings getLocalSubrsForFD(int var1);

    abstract int getNumFDs();

    abstract double getDefaultWidthForFD(int var1);

    abstract double getNominalWidthForFD(int var1);

    abstract int getFDForGlyph(int var1) throws InvalidFontException;

    CharStrings createSubsetCharstringIndex(Subset subset, boolean willSubrize) throws InvalidFontException, UnsupportedFontException {
        Type2CStringGenerator generator = new Type2CStringGenerator(subset.getNumGlyphs(), this.getNumFDs(), willSubrize);
        Type2OutlineParser parser = new Type2OutlineParser(true);
        for (int i = 0; i < subset.getNumGlyphs(); ++i) {
            int fullGid = subset.getFullGid(i);
            int fd = this.getFDForGlyph(fullGid);
            generator.newGlyph(i, fd, this.getDefaultWidthForFD(fd), this.getNominalWidthForFD(fd));
            parser.parse(this.getCharStrings(), fullGid, this.getLocalSubrsForFD(fd), this.globalSubrs, generator, Matrix.IDENTITY_MATRIX, this instanceof NameKeyedFont ? (NameKeyedFont)this : null);
        }
        return generator.getCharstringIndex();
    }

    @Override
    public CatalogDescription getSelectionDescription() throws InvalidFontException, UnsupportedFontException {
        return null;
    }

    @Override
    public SWFFont4Description getSWFFont4Description(boolean wasEmbedded) throws UnsupportedFontException, InvalidFontException {
        return null;
    }

    protected abstract class CFFFontXDCFontDescription
    extends XDCFontDescription {
        protected CFFFontXDCFontDescription() {
        }

        @Override
        public ROS getROS() throws UnsupportedFontException, InvalidFontException {
            return CFFFont.this.getROS();
        }

        @Override
        public boolean pdfFontIsTrueType() {
            return false;
        }

        @Override
        public String getPostscriptName() throws InvalidFontException, UnsupportedFontException {
            return CFFFont.this.getName();
        }

        @Override
        public String getFontFamily() throws InvalidFontException, UnsupportedFontException {
            Set s = CFFFont.this.getCSSFamilyNames();
            if (!s.isEmpty()) {
                return (String)s.iterator().next();
            }
            return null;
        }

        @Override
        public int getNumGlyphs() throws UnsupportedFontException, InvalidFontException {
            return CFFFont.this.getNumGlyphs();
        }

        @Override
        public int getGlyphCid(int glyphID) throws UnsupportedFontException, InvalidFontException {
            return CFFFont.this.getGlyphCid(glyphID);
        }

        @Override
        public String getGlyphName(int gid) throws InvalidFontException, UnsupportedFontException {
            return CFFFont.this.getGlyphName(gid);
        }

        @Override
        public double getStemV() throws UnsupportedFontException, InvalidFontException {
            int glyphID = CFFFont.this.getGlyphForChar(108);
            if (glyphID == 0) {
                glyphID = CFFFont.this.getGlyphForChar(73);
            }
            if (glyphID == 0) {
                return 0.0;
            }
            return CFFFont.this.getStemVForGlyph(glyphID) * 1000.0 / CFFFont.this.getUnitsPerEmX();
        }

        @Override
        public Rect getFontBBox() throws InvalidFontException, UnsupportedFontException {
            Rect bbox = CFFFont.this.getRawFontBBox();
            if (bbox == null) {
                return null;
            }
            return bbox.applyMatrix(CFFFont.this.getFontMatrix().multiply(1000.0));
        }

        @Override
        public double getCapHeight() throws UnsupportedFontException, InvalidFontException {
            double capHeight = CFFFont.this.getCoolTypeCapHeight();
            if (Double.isNaN(capHeight)) {
                return 0.0;
            }
            return capHeight * (1000.0 / CFFFont.this.getUnitsPerEmY());
        }

        @Override
        public double getXHeight() throws UnsupportedFontException, InvalidFontException {
            double xHeight = CFFFont.this.getCoolTypeXHeight();
            if (Double.isNaN(xHeight)) {
                return 0.0;
            }
            return xHeight * (1000.0 / CFFFont.this.getUnitsPerEmY());
        }

        @Override
        public double getItalicAngle() throws InvalidFontException, UnsupportedFontException {
            return CFFFont.this.getItalicAngle();
        }

        @Override
        public double getAdvance(int glyphID) throws InvalidFontException, UnsupportedFontException {
            return CFFFont.this.getHorizontalAdvance(glyphID) * 1000.0 / CFFFont.this.getUnitsPerEmX();
        }

        @Override
        public String getBase14Name() {
            return null;
        }

        @Override
        public boolean isSerifFont() throws InvalidFontException, UnsupportedFontException {
            int gid1 = CFFFont.this.getGlyphForChar(108);
            int gid2 = CFFFont.this.getGlyphForChar(73);
            return CFFFont.this.isSerifFont(gid1, gid2, this.getItalicAngle());
        }

        @Override
        public boolean isSmallCapFont() throws InvalidFontException, UnsupportedFontException {
            if (!this.isAllCapFont()) {
                int gid1 = CFFFont.this.getGlyphForChar(104);
                int gid2 = CFFFont.this.getGlyphForChar(120);
                if (gid2 != 0) {
                    Rect bbox = CFFFont.this.getGlyphBBox(gid2);
                    return CFFFont.this.isSmallCapFont(gid1, bbox.ymax);
                }
            }
            return false;
        }

        @Override
        public boolean isAllCapFont() throws InvalidFontException, UnsupportedFontException {
            int gid1 = CFFFont.this.getGlyphForChar(75);
            int gid2 = CFFFont.this.getGlyphForChar(107);
            return CFFFont.this.isAllCapFont(gid1, gid2);
        }

        @Override
        public abstract CodePage[] getXDCCodePages() throws InvalidFontException, UnsupportedFontException;
    }

    private class CFFSWFFont3Description
    implements SWFFontDescription {
        private final boolean wasEmbedded;
        private final LineMetrics metrics;

        CFFSWFFont3Description(boolean wasEmbedded) throws UnsupportedFontException, InvalidFontException {
            this.wasEmbedded = wasEmbedded;
            this.metrics = CFFFont.this.getCoolTypeLineMetrics();
        }

        @Override
        public boolean canDisplay(char c) throws UnsupportedFontException, InvalidFontException {
            return CFFFont.this.getGlyphForChar(c) != 0;
        }

        @Override
        public double getHorizontalAdvance(char ccode) throws UnsupportedFontException, InvalidFontException {
            int gid = CFFFont.this.getGlyphForChar(ccode);
            return CFFFont.this.getHorizontalAdvance(gid);
        }

        @Override
        public void getOutline(char ccode, OutlineConsumer consumer) throws UnsupportedFontException, InvalidFontException {
            int gid = CFFFont.this.getGlyphForChar(ccode);
            CFFFont.this.getGlyphOutline(gid, consumer);
        }

        @Override
        public double getEmScale() throws InvalidFontException, UnsupportedFontException {
            return CFFFont.this.getUnitsPerEmX();
        }

        @Override
        public double getAscent() throws InvalidFontException, UnsupportedFontException {
            return this.metrics.ascender * CFFFont.this.getUnitsPerEmX() / CFFFont.this.getUnitsPerEmY();
        }

        @Override
        public double getDescent() throws InvalidFontException, UnsupportedFontException {
            return -this.metrics.descender * CFFFont.this.getUnitsPerEmX() / CFFFont.this.getUnitsPerEmY();
        }

        @Override
        public double getLineGap() throws InvalidFontException, UnsupportedFontException {
            return this.metrics.linegap * CFFFont.this.getUnitsPerEmX() / CFFFont.this.getUnitsPerEmY();
        }

        @Override
        public String getCopyright() throws InvalidFontException, UnsupportedFontException {
            return CFFFont.this.getCopyright();
        }

        @Override
        public String getPostscriptName() throws InvalidFontException, UnsupportedFontException {
            return CFFFont.this.getName();
        }

        @Override
        public String getTrademark() throws InvalidFontException, UnsupportedFontException {
            return CFFFont.this.getNotice();
        }

        @Override
        public String getFamily() throws InvalidFontException, UnsupportedFontException {
            return CFFFont.this.getPreferredCSSFamilyName();
        }

        @Override
        public String getFullName() throws InvalidFontException, UnsupportedFontException {
            return CFFFont.this.getFullName();
        }

        @Override
        public int getNumGlyphs() throws InvalidFontException, UnsupportedFontException {
            return CFFFont.this.getNumGlyphs();
        }

        @Override
        public Permission getPermissions() throws InvalidFontException, UnsupportedFontException {
            Permission perm = CFFFont.this.getEmbeddingPermission(this.wasEmbedded);
            if (perm.equals(Permission.ILLEGAL_VALUE)) {
                return Permission.EDITABLE;
            }
            return perm;
        }

        @Override
        public boolean isBold() throws InvalidFontException, UnsupportedFontException {
            return CFFFont.this.getCSSWeight() >= 700;
        }

        @Override
        public boolean isItalic() throws InvalidFontException, UnsupportedFontException {
            return CFFFont.this.isCSSStyleItalic();
        }

        @Override
        public int getFirstChar() throws InvalidFontException, UnsupportedFontException {
            return CFFFont.this.getFirstChar();
        }

        @Override
        public int getLastChar() throws InvalidFontException, UnsupportedFontException {
            return CFFFont.this.getLastChar();
        }

        @Override
        public String getSubFamily() throws InvalidFontException, UnsupportedFontException {
            return null;
        }
    }
}

