/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.content;

import com.adobe.xfa.Bool;
import com.adobe.xfa.Element;
import com.adobe.xfa.Node;
import com.adobe.xfa.ScriptTable;
import com.adobe.xfa.content.BooleanScript;
import com.adobe.xfa.content.Content;
import com.adobe.xfa.ut.ExFull;
import com.adobe.xfa.ut.MsgFormatPos;
import com.adobe.xfa.ut.ResId;

public final class BooleanValue
extends Content {
    public BooleanValue(Element parent, Node prevSibling) {
        super(parent, prevSibling, null, "boolean", "boolean", null, 32, "boolean");
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        return super.equals(object) && this.getValue() == ((BooleanValue)object).getValue();
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ Boolean.valueOf(this.getValue()).hashCode();
    }

    @Override
    public ScriptTable getScriptTable() {
        return BooleanScript.getScriptTable();
    }

    public boolean getValue() {
        String sValue = this.getStrValue();
        try {
            return Bool.getBool(sValue) == Bool.trueValue();
        }
        catch (ExFull ex) {
            MsgFormatPos message = new MsgFormatPos(ResId.FoundBadElementValueException);
            message.format(sValue);
            message.format(this.getSOMExpression());
            message.format("0");
            this.getModel().addErrorList(new ExFull(message), 3, this);
            return false;
        }
    }

    public void setValue(boolean bValue) {
        this.setStrValue(Bool.toString(bValue), true, false);
    }

    @Override
    public String toString() {
        return Bool.toString(this.getValue());
    }

    public boolean valueHasTypeMismatch() {
        String sValue = this.getStrValue();
        try {
            Bool.getBool(sValue);
            return false;
        }
        catch (ExFull ex) {
            return true;
        }
    }
}

