/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.personalization.tags;

import com.adobe.granite.xss.XSSAPI;
import com.day.cq.personalization.ClientContextUtil;
import java.io.IOException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.scripting.SlingBindings;
import org.apache.sling.scripting.jsp.util.TagUtil;

public class StoreRendererTag
extends TagSupport {
    private static final long serialVersionUID = 4646561799994266940L;
    private String store;

    @Override
    public void setPageContext(PageContext pageContext) {
        super.setPageContext(pageContext);
    }

    public void setStore(String store) {
        this.store = store;
    }

    @Override
    public int doEndTag() throws JspException {
        JspWriter out = this.pageContext.getOut();
        SlingHttpServletRequest request = TagUtil.getRequest(this.pageContext);
        try {
            out.println(this.getScript(request));
        }
        catch (IOException e) {
            throw new JspException("Could not write script for context profile property", e);
        }
        return 6;
    }

    String getScript(SlingHttpServletRequest request) {
        SlingBindings bindings = (SlingBindings)request.getAttribute(SlingBindings.class.getName());
        XSSAPI xssAPI = bindings.getSling().getService(XSSAPI.class).getRequestSpecificAPI(request);
        StringBuilder res = new StringBuilder();
        String prefixId = ClientContextUtil.getId(request.getResource().getPath());
        String id = prefixId + "-" + this.store;
        res.append("<div");
        res.append(" id=\"").append(xssAPI.encodeForHTMLAttr(id)).append("\"");
        res.append(" class=\"cq-cc-").append(xssAPI.encodeForHTMLAttr(this.store)).append("\"");
        res.append(">");
        res.append("</div>");
        res.append("<script type=\"text/javascript\">\n");
        res.append("if( window.CQ_Analytics ) {");
        res.append("CQ_Analytics.ClientContextUtils.renderStore(");
        res.append("'").append(xssAPI.encodeForJSString(id)).append("',");
        res.append("'").append(xssAPI.encodeForJSString(this.store)).append("'");
        res.append(");");
        res.append("}");
        res.append("</script>");
        return res.toString();
    }
}

