/*
 * Decompiled with CFR 0.152.
 */
package com.day.util;

import com.day.text.GlobPattern;
import com.day.text.Text;
import com.day.util.HandleExpander;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;

public class URLExpander
implements HandleExpander {
    @Override
    public String[] expand(String pattern) {
        try {
            URI uri = new URI(pattern);
            if (uri.getScheme() == null || uri.getScheme().equals("file")) {
                ArrayList list = new ArrayList();
                String path = uri.getPath();
                this.traverse_directory(list, new StringBuffer(path.length()), path.toCharArray(), 0);
                return list.toArray(new String[list.size()]);
            }
            URL url = uri.toURL();
            throw new UnsupportedOperationException("hmpf. still have to do this");
        }
        catch (URISyntaxException uRISyntaxException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new String[0];
    }

    private void traverse_directory(ArrayList list, StringBuffer dir, char[] ptr, int p) {
        int lastslash = p;
        int first = p;
        while (p < ptr.length && ptr[p] != '*' && ptr[p] != '?' && ptr[p] != '[' && ptr[p] != ']') {
            if (ptr[p] == '/') {
                lastslash = p;
            }
            ++p;
        }
        if (p == ptr.length) {
            dir.append('/');
            dir.append(ptr, first, p - first);
            String path = dir.toString();
            if (new File(path).isFile()) {
                list.add(path);
            }
        } else {
            if (lastslash > first) {
                dir.append('/');
                dir.append(ptr, first, lastslash - first);
                ++lastslash;
            }
            while (p < ptr.length && ptr[p] != '/') {
                ++p;
            }
            GlobPattern glob = new GlobPattern(new String(ptr, lastslash, p - lastslash));
            File directory = new File(dir.toString());
            File[] files = directory.listFiles();
            if (files == null) {
                return;
            }
            for (int i = 0; i < files.length; ++i) {
                String name = files[i].getName();
                if (!glob.matches(name)) continue;
                int len = dir.length();
                dir.append('/');
                dir.append(name);
                if (files[i].isDirectory() && p < ptr.length) {
                    this.traverse_directory(list, dir, ptr, p + 1);
                } else if (files[i].isFile() && p == ptr.length) {
                    String filename = dir.toString();
                    list.add(Text.fullPath(filename, ""));
                }
                dir.setLength(len);
            }
        }
    }
}

