/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.commons;

import com.google.common.base.Function;
import com.google.common.collect.AbstractIterator;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.apache.jackrabbit.guava.common.base.Strings;
import org.apache.jackrabbit.guava.common.collect.Iterators;
import org.apache.jackrabbit.guava.common.collect.PeekingIterator;
import org.apache.jackrabbit.guava.common.io.Closeables;
import org.apache.jackrabbit.guava.common.io.FileWriteMode;
import org.apache.jackrabbit.guava.common.io.Files;
import org.apache.jackrabbit.oak.commons.GuavaDeprecation;
import org.apache.jackrabbit.oak.commons.sort.EscapeUtils;
import org.apache.jackrabbit.oak.commons.sort.ExternalSort;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileIOUtils {
    public static final Comparator<String> lexComparator = new Comparator<String>(){

        @Override
        public int compare(String s1, String s2) {
            return s1.compareTo(s2);
        }
    };
    @Deprecated(since="1.20.0", forRemoval=true)
    public static final Function<String, String> passThruTransformer = new Function<String, String>(){

        @Override
        @Nullable
        public String apply(@Nullable String input) {
            return input;
        }
    };

    private FileIOUtils() {
    }

    public static void sort(File file) throws IOException {
        File sorted = File.createTempFile("fleioutilssort", null);
        FileIOUtils.merge(ExternalSort.sortInBatch(file, lexComparator, true), sorted);
        Files.move((File)sorted, (File)file);
    }

    public static void sort(File file, Comparator<String> comparator) throws IOException {
        File sorted = File.createTempFile("fleioutilssort", null);
        FileIOUtils.merge(ExternalSort.sortInBatch(file, comparator, true), sorted, comparator);
        Files.move((File)sorted, (File)file);
    }

    public static void merge(List<File> files, File output) throws IOException {
        ExternalSort.mergeSortedFiles(files, output, lexComparator, true);
    }

    public static void merge(List<File> files, File output, Comparator<String> comparator) throws IOException {
        ExternalSort.mergeSortedFiles(files, output, comparator, true);
    }

    public static File copy(InputStream stream) throws IOException {
        File file = File.createTempFile("fleioutilscopy", null);
        FileIOUtils.copyInputStreamToFile(stream, file);
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void append(List<File> files, File appendTo, boolean delete) throws IOException {
        boolean threw;
        OutputStream appendStream;
        block9: {
            appendStream = null;
            threw = true;
            try {
                appendStream = Files.asByteSink((File)appendTo, (FileWriteMode[])new FileWriteMode[]{FileWriteMode.APPEND}).openBufferedStream();
                for (File f : files) {
                    FileInputStream iStream = new FileInputStream(f);
                    try {
                        IOUtils.copyLarge(iStream, appendStream);
                    }
                    finally {
                        IOUtils.closeQuietly(iStream);
                    }
                }
                threw = false;
                if (!delete) break block9;
            }
            catch (Throwable throwable) {
                if (delete) {
                    for (File f : files) {
                        f.delete();
                    }
                }
                Closeables.close(appendStream, (boolean)threw);
                throw throwable;
            }
            for (File f : files) {
                f.delete();
            }
        }
        Closeables.close((Closeable)appendStream, (boolean)threw);
    }

    public static void writeAsLine(BufferedWriter writer, String str, boolean escape) throws IOException {
        if (escape) {
            writer.write(EscapeUtils.escapeLineBreak(str));
        } else {
            writer.write(str);
        }
        writer.newLine();
    }

    public static int writeStrings(Iterator<String> iterator, File f, boolean escape) throws IOException {
        return FileIOUtils.writeStrings(iterator, f, escape, null, "");
    }

    public static int writeStrings(Iterator<String> iterator, File f, boolean escape, @Nullable Logger logger, @Nullable String message) throws IOException {
        return FileIOUtils.writeStrings(iterator, f, escape, java.util.function.Function.identity(), logger, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int writeStrings(Iterator<String> iterator, File f, boolean escape, @NotNull java.util.function.Function<String, String> transformer, @Nullable Logger logger, @Nullable String message) throws IOException {
        BufferedWriter writer = Files.newWriter((File)f, (Charset)StandardCharsets.UTF_8);
        boolean threw = true;
        int count = 0;
        try {
            while (iterator.hasNext()) {
                FileIOUtils.writeAsLine(writer, transformer.apply(iterator.next()), escape);
                if (logger == null || ++count % 1000 != 0) continue;
                logger.info(Strings.nullToEmpty((String)message) + count);
            }
            threw = false;
        }
        finally {
            Closeables.close((Closeable)writer, (boolean)threw);
        }
        return count;
    }

    @Deprecated(since="1.20.0", forRemoval=true)
    public static int writeStrings(Iterator<String> iterator, File f, boolean escape, @NotNull Function<String, String> transformer, @Nullable Logger logger, @Nullable String message) throws IOException {
        GuavaDeprecation.handleCall("OAK-8677");
        java.util.function.Function<String, String> tr2 = s -> (String)transformer.apply((String)s);
        return FileIOUtils.writeStrings(iterator, f, escape, tr2, logger, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> readStringsAsSet(InputStream stream, boolean unescape) throws IOException {
        BufferedReader reader = null;
        HashSet<String> set = new HashSet<String>();
        boolean threw = true;
        try {
            reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));
            String line = null;
            while ((line = reader.readLine()) != null) {
                if (unescape) {
                    set.add(EscapeUtils.unescapeLineBreaks(line));
                    continue;
                }
                set.add(line);
            }
            threw = false;
        }
        catch (Throwable throwable) {
            Closeables.close(reader, (boolean)threw);
            throw throwable;
        }
        Closeables.close((Closeable)reader, (boolean)threw);
        return set;
    }

    public static Comparator<String> lineBreakAwareComparator(Comparator<String> delegate) {
        return new TransformingComparator(delegate, new java.util.function.Function<String, String>(){

            @Override
            @Nullable
            public String apply(@Nullable String input) {
                return EscapeUtils.unescapeLineBreaks(input);
            }
        });
    }

    public static void copyInputStreamToFile(InputStream source, File destination) throws IOException {
        boolean success = false;
        try {
            FileUtils.copyInputStreamToFile(source, destination);
            success = true;
        }
        finally {
            if (!success) {
                FileUtils.forceDelete(destination);
            }
        }
    }

    @Deprecated(since="1.20.0", forRemoval=true)
    public static class BurnOnCloseFileIterator<T>
    extends AbstractIterator<T>
    implements Closeable {
        private final Logger log = LoggerFactory.getLogger(this.getClass());
        private final LineIterator iterator;
        private final Function<String, T> transformer;
        private final File backingFile;

        public BurnOnCloseFileIterator(LineIterator iterator, Function<String, T> transformer) {
            this(iterator, null, transformer);
        }

        public BurnOnCloseFileIterator(LineIterator iterator, File backingFile, Function<String, T> transformer) {
            GuavaDeprecation.handleCall("OAK-8666");
            this.iterator = iterator;
            this.transformer = transformer;
            this.backingFile = backingFile;
        }

        @Override
        protected T computeNext() {
            if (this.iterator.hasNext()) {
                return this.transformer.apply(this.iterator.next());
            }
            try {
                this.close();
            }
            catch (IOException e) {
                this.log.warn("Error closing iterator", e);
            }
            return this.endOfData();
        }

        @Override
        public void close() throws IOException {
            LineIterator.closeQuietly(this.iterator);
            if (this.backingFile != null && this.backingFile.exists()) {
                FileUtils.forceDelete(this.backingFile);
            }
        }

        public static BurnOnCloseFileIterator<String> wrap(LineIterator iter) {
            return new BurnOnCloseFileIterator<String>(iter, new Function<String, String>(){

                @Override
                public String apply(String s) {
                    return s;
                }
            });
        }

        public static BurnOnCloseFileIterator<String> wrap(LineIterator iter, File backingFile) {
            return new BurnOnCloseFileIterator<String>(iter, backingFile, new Function<String, String>(){

                @Override
                public String apply(String s) {
                    return s;
                }
            });
        }
    }

    @Deprecated(since="1.20.0", forRemoval=true)
    public static class FileLineDifferenceIterator
    extends AbstractIterator<String>
    implements Closeable {
        private final PeekingIterator<String> peekMarked;
        private final LineIterator marked;
        private final LineIterator all;
        private Function<String, String> transformer = new Function<String, String>(){

            @Override
            public String apply(String input) {
                return input;
            }
        };

        public FileLineDifferenceIterator(LineIterator marked, LineIterator available) throws IOException {
            this(marked, available, null);
        }

        public FileLineDifferenceIterator(File marked, File available, @Nullable Function<String, String> transformer) throws IOException {
            this(FileUtils.lineIterator(marked, StandardCharsets.UTF_8.toString()), FileUtils.lineIterator(available, StandardCharsets.UTF_8.toString()), transformer);
        }

        public FileLineDifferenceIterator(LineIterator marked, LineIterator available, @Nullable Function<String, String> transformer) throws IOException {
            GuavaDeprecation.handleCall("OAK-8676");
            this.marked = marked;
            this.peekMarked = Iterators.peekingIterator((Iterator)marked);
            this.all = available;
            if (transformer != null) {
                this.transformer = transformer;
            }
        }

        @Override
        protected String computeNext() {
            String diff = this.computeNextDiff();
            if (diff == null) {
                this.close();
                return (String)this.endOfData();
            }
            return diff;
        }

        @Override
        public void close() {
            LineIterator.closeQuietly(this.marked);
            LineIterator.closeQuietly(this.all);
        }

        private String computeNextDiff() {
            if (!this.all.hasNext()) {
                return null;
            }
            if (!this.peekMarked.hasNext()) {
                return this.all.next();
            }
            String diff = null;
            block0: while (this.all.hasNext() && diff == null) {
                diff = this.all.next();
                while (this.peekMarked.hasNext()) {
                    String marked = (String)this.peekMarked.peek();
                    int comparisonResult = this.transformer.apply(diff).compareTo(this.transformer.apply(marked));
                    if (comparisonResult > 0) {
                        this.peekMarked.next();
                        continue;
                    }
                    if (comparisonResult == 0) {
                        this.peekMarked.next();
                        diff = null;
                        continue block0;
                    }
                    return diff;
                }
            }
            return diff;
        }
    }

    public static class TransformingComparator
    implements Comparator<String> {
        private Comparator<String> delegate;
        private java.util.function.Function<String, String> func;

        @Deprecated(since="1.50.0", forRemoval=true)
        public TransformingComparator(Comparator<String> delegate, final Function<String, String> func) {
            GuavaDeprecation.handleCall("OAK-10109");
            this.delegate = delegate;
            this.func = new java.util.function.Function<String, String>(){

                @Override
                public String apply(String t) {
                    return (String)func.apply(t);
                }
            };
        }

        public TransformingComparator(Comparator<String> delegate, java.util.function.Function<String, String> func) {
            this.delegate = delegate;
            this.func = func;
        }

        @Override
        public int compare(String s1, String s2) {
            return this.delegate.compare(this.func.apply(s1), this.func.apply(s2));
        }
    }
}

