/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene;

import com.google.common.primitives.Ints;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.index.lucene.util.fv.SimSearchUtils;
import org.apache.jackrabbit.oak.plugins.index.search.FieldNames;
import org.apache.jackrabbit.oak.plugins.index.search.spi.binary.BlobByteSource;
import org.apache.jackrabbit.util.ISO8601;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.IntField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.FieldInfo;

public final class FieldFactory {
    private static final FieldType OAK_TYPE = new FieldType();
    private static final FieldType OAK_TYPE_NOT_STORED = new FieldType();
    private static final int[] TYPABLE_TAGS = new int[]{Type.DATE.tag(), Type.BOOLEAN.tag(), Type.DOUBLE.tag(), Type.LONG.tag()};

    public static boolean canCreateTypedField(Type<?> type) {
        return Ints.contains(TYPABLE_TAGS, type.tag());
    }

    private FieldFactory() {
    }

    public static Field newPathField(String path) {
        return new StringField(":path", path, Field.Store.YES);
    }

    public static Field newPropertyField(String name, String value, boolean tokenized, boolean stored) {
        if (tokenized) {
            return new OakTextField(name, value, stored);
        }
        return new StringField(name, value, Field.Store.NO);
    }

    public static Collection<Field> newSimilarityFields(String name, Blob value) throws IOException {
        ArrayList<Field> fields = new ArrayList<Field>(1);
        byte[] bytes = new BlobByteSource(value).read();
        fields.add(FieldFactory.newSimilarityField(name, bytes));
        return fields;
    }

    public static Collection<Field> newBinSimilarityFields(String name, Blob value) throws IOException {
        ArrayList<Field> fields = new ArrayList<Field>(1);
        byte[] bytes = new BlobByteSource(value).read();
        fields.add(FieldFactory.newBinarySimilarityField(name, bytes));
        return fields;
    }

    public static Collection<Field> newSimilarityFields(String name, String value) {
        ArrayList<Field> fields = new ArrayList<Field>(1);
        fields.add(FieldFactory.newSimilarityField(name, value));
        return fields;
    }

    public static Collection<Field> newBinSimilarityFields(String name, String value) {
        ArrayList<Field> fields = new ArrayList<Field>(1);
        byte[] bytes = SimSearchUtils.toByteArray((String)value);
        fields.add(FieldFactory.newBinarySimilarityField(name, bytes));
        return fields;
    }

    private static StoredField newBinarySimilarityField(String name, byte[] bytes) {
        return new StoredField(FieldNames.createBinSimilarityFieldName((String)name), bytes);
    }

    private static Field newSimilarityField(String name, byte[] bytes) {
        return FieldFactory.newSimilarityField(name, SimSearchUtils.toDoubleString((byte[])bytes));
    }

    private static Field newSimilarityField(String name, String value) {
        return new TextField(FieldNames.createSimilarityFieldName((String)name), value, Field.Store.YES);
    }

    public static Field newFulltextField(String value) {
        return FieldFactory.newFulltextField(value, false);
    }

    public static Field newFulltextField(String name, String value) {
        return FieldFactory.newFulltextField(name, value, false);
    }

    public static Field newFulltextField(String value, boolean stored) {
        return new TextField(":fulltext", value, stored ? Field.Store.YES : Field.Store.NO);
    }

    public static Field newFulltextField(String name, String value, boolean stored) {
        return new TextField(FieldNames.createFulltextFieldName((String)name), value, stored ? Field.Store.YES : Field.Store.NO);
    }

    public static Field newAncestorsField(String path) {
        return new TextField(":ancestors", path, Field.Store.NO);
    }

    public static Field newDepthField(String path) {
        return new IntField(":depth", PathUtils.getDepth(path), Field.Store.NO);
    }

    public static Field newSuggestField(String ... values) {
        StringBuilder builder = new StringBuilder();
        for (String v : values) {
            if (builder.length() > 0) {
                builder.append('\n');
            }
            builder.append(v);
        }
        return new OakTextField(":suggest", builder.toString(), false);
    }

    public static Long dateToLong(String date) {
        if (date == null) {
            return null;
        }
        Calendar c = ISO8601.parse(date);
        if (c != null) {
            return c.getTimeInMillis();
        }
        throw new RuntimeException("Unable to parse the provided date field : " + date + " to convert to millis. Supported format is \u00b1YYYY-MM-DDThh:mm:ss.SSSTZD");
    }

    static {
        OAK_TYPE.setIndexed(true);
        OAK_TYPE.setOmitNorms(true);
        OAK_TYPE.setStored(true);
        OAK_TYPE.setIndexOptions(FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS);
        OAK_TYPE.setTokenized(true);
        OAK_TYPE.freeze();
        OAK_TYPE_NOT_STORED.setIndexed(true);
        OAK_TYPE_NOT_STORED.setOmitNorms(true);
        OAK_TYPE_NOT_STORED.setStored(false);
        OAK_TYPE_NOT_STORED.setIndexOptions(FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS);
        OAK_TYPE_NOT_STORED.setTokenized(true);
        OAK_TYPE_NOT_STORED.freeze();
        Arrays.sort(TYPABLE_TAGS);
    }

    private static final class OakTextField
    extends Field {
        public OakTextField(String name, String value, boolean stored) {
            super(name, value, stored ? OAK_TYPE : OAK_TYPE_NOT_STORED);
        }
    }
}

