/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.nodetype;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.core.GuavaDeprecation;
import org.apache.jackrabbit.oak.plugins.tree.TreeUtil;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypePredicate
implements Predicate<NodeState>,
com.google.common.base.Predicate<NodeState> {
    private final NodeState root;
    private final Iterable<String> names;
    private boolean initialized;
    private Set<String> primaryTypes;
    private Set<String> mixinTypes;

    @NotNull
    public static TypePredicate isOrderable(@NotNull NodeState root) {
        HashSet<String> orderable = Sets.newHashSet();
        NodeState types = Preconditions.checkNotNull(root).getChildNode("jcr:system").getChildNode("jcr:nodeTypes");
        for (ChildNodeEntry childNodeEntry : types.getChildNodeEntries()) {
            NodeState type = childNodeEntry.getNodeState();
            if (!type.getBoolean("jcr:hasOrderableChildNodes")) continue;
            orderable.add(childNodeEntry.getName());
        }
        return new TypePredicate(root, orderable);
    }

    public TypePredicate(@NotNull NodeState root, @NotNull String name) {
        this(root, Collections.singleton(name));
    }

    public TypePredicate(@NotNull NodeState root, @NotNull Iterable<String> names) {
        this.root = root;
        this.names = names;
    }

    public TypePredicate(@NotNull NodeState root, @NotNull String[] names) {
        this(root, Arrays.asList(names));
    }

    private static Set<String> add(Set<String> names, String name) {
        if (names == null) {
            return Sets.newHashSet(name);
        }
        names.add(name);
        return names;
    }

    private void addNodeType(NodeState types, String name) {
        NodeState type = types.getChildNode(name);
        for (String primary : type.getNames("rep:primarySubtypes")) {
            this.primaryTypes = TypePredicate.add(this.primaryTypes, primary);
        }
        if (type.getBoolean("jcr:isMixin")) {
            this.mixinTypes = TypePredicate.add(this.mixinTypes, name);
            for (String mixin : type.getNames("rep:mixinSubtypes")) {
                this.mixinTypes = TypePredicate.add(this.mixinTypes, mixin);
            }
        } else {
            this.primaryTypes = TypePredicate.add(this.primaryTypes, name);
        }
    }

    private void init() {
        if (!this.initialized) {
            NodeState types = Preconditions.checkNotNull(this.root).getChildNode("jcr:system").getChildNode("jcr:nodeTypes");
            for (String name : Preconditions.checkNotNull(this.names)) {
                this.addNodeType(types, name);
            }
            this.initialized = true;
        }
    }

    public boolean test(String primary, Set<String> mixins) {
        this.init();
        if (this.primaryTypes != null && this.primaryTypes.contains(primary)) {
            return true;
        }
        return this.mixinTypes != null && Iterables.any(mixins, Predicates.in(this.mixinTypes));
    }

    @Override
    public boolean test(@Nullable Tree input) {
        if (input != null) {
            this.init();
            if (this.primaryTypes != null && this.primaryTypes.contains(TreeUtil.getPrimaryTypeName(input))) {
                return true;
            }
            if (this.mixinTypes != null && Iterables.any(TreeUtil.getNames(input, "jcr:mixinTypes"), Predicates.in(this.mixinTypes))) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean test(@Nullable NodeState input) {
        if (input != null) {
            this.init();
            if (this.primaryTypes != null && this.primaryTypes.contains(input.getName("jcr:primaryType"))) {
                return true;
            }
            if (this.mixinTypes != null && Iterables.any(input.getNames("jcr:mixinTypes"), Predicates.in(this.mixinTypes))) {
                return true;
            }
        }
        return false;
    }

    @Override
    @Deprecated(since="1.26.0", forRemoval=true)
    public boolean apply(@Nullable NodeState input) {
        GuavaDeprecation.handleCall((String)"OAK-8874");
        return this.test(input);
    }

    @Override
    @Deprecated(since="1.26.0", forRemoval=true)
    public boolean apply(@Nullable Tree input) {
        GuavaDeprecation.handleCall((String)"OAK-8874");
        return this.test(input);
    }

    @Deprecated(since="1.26.0", forRemoval=true)
    public boolean apply(String primary, Set<String> mixins) {
        GuavaDeprecation.handleCall((String)"OAK-8874");
        return this.test(primary, mixins);
    }

    public String toString() {
        return Iterables.toString(this.names);
    }
}

