/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.util.function;

import java.util.Objects;
import org.osgi.annotation.versioning.ConsumerType;
import org.osgi.util.function.Exceptions;

@FunctionalInterface
@ConsumerType
public interface Consumer<T> {
    public void accept(T var1) throws Exception;

    default public Consumer<T> andThen(Consumer<? super T> after) {
        Objects.requireNonNull(after);
        return t -> {
            this.accept(t);
            after.accept(t);
        };
    }

    public static <T> java.util.function.Consumer<T> asJavaConsumer(Consumer<T> wrapped) {
        Objects.requireNonNull(wrapped);
        return t -> {
            try {
                wrapped.accept(t);
            }
            catch (Exception e) {
                throw Exceptions.throwUnchecked(e);
            }
        };
    }

    public static <T> java.util.function.Consumer<T> asJavaConsumerIgnoreException(Consumer<T> wrapped) {
        Objects.requireNonNull(wrapped);
        return t -> {
            try {
                wrapped.accept(t);
            }
            catch (Exception exception) {
                // empty catch block
            }
        };
    }

    public static <T> Consumer<T> asConsumer(java.util.function.Consumer<T> wrapped) {
        Objects.requireNonNull(wrapped);
        return wrapped::accept;
    }
}

