/*
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2020 Adobe
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 */

package com.adobe.cq.dam.download.api;

import java.util.Collection;
import java.util.Map;

import org.osgi.annotation.versioning.ProviderType;

import com.adobe.cq.dam.download.spi.DownloadTargetProcessor;

/**
 * <p>
 * Provides a means for specifying which binaries should be included in a
 * download.
 * </p>
 * <p>
 * The manifest primarily consists of one or more {@link DownloadTarget} items
 * that the consumer needs to download. The {@link DownloadService} will convert
 * these targets into one or more URIs that will be provided as the output of
 * the download process.
 * </p>
 *
 * @see DownloadService
 * @see DownloadTarget
 * @see DownloadTargetProcessor
 */
@ProviderType
public interface DownloadManifest {

    /**
     * Retrieves the total number of targets that are included in the manifest.
     * @return Number of targets.
     */
    int getTargetCount();

    /**
     * Adds a new {@link DownloadTarget} item to the manifest. This flavor accepts
     * an instance of DownloadTarget, which might be helpful in cases where more
     * control over the target may be required.
     * @param target The target to add to the manifest's list of targets.
     */
    void addTarget(DownloadTarget target);

    /**
     * Retrieves all of the {@link DownloadTarget} items that have been added to the manifest.
     * @return The manifest's targets.
     */
    Collection<DownloadTarget> getTargets();

    /**
     * Retrieves all the parameter options to be applied on this download
     * @return map of the parameters
     */
    Map<String, Object> getParameters();
}
