/*
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2019 Adobe
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 */
package com.adobe.cq.inbox.api.preferences.domain.view;

import org.osgi.annotation.versioning.ProviderType;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import java.net.URL;
import java.util.List;

/**
 * A view configuration applicable to workflow-users
 * This is different from {@link ViewPreferences}, which are user specific view preferences
 */
@ProviderType
public interface ViewConfiguration {

    /**
     * Returns the custom branding text of inbox
     * @return The custom branding text
     */
    @Nonnull String getCustomBrandingText();


    /**
     * Set the custom branding text.
     * @param text Custom Branding text
     */
    void setCustomBrandingText(@Nullable String text);

    /**
     * Returns the url where a user should be directed to (from inbox) for help
     * If not set, AEM's default help behavior will be in effect
     * @return The custom help url
     */
    @Nullable URL getCustomHelpUrl();


    /**
     * Set the custom help link url
     * @param url The url where a user should be directed to (from inbox) for help
     */
    void setCustomHelpUrl(@Nullable URL url);


    /**
     * Return the JCR path of image to be used as the branding logo
     * @return The logo path
     */
    @Nullable String getCustomLogoPath();

    /**
     * Set the JCR path of image to be used as the branding logo
     * @param path If null, the default branding logo will be used
     */
    void setCustomLogoPath(@Nullable String path);


    /**
     * The column in the inbox
     * @return a list of {@link ViewConfigurationColumn}
     */
    @Nonnull
    List<ViewConfigurationColumn> getColumns();

    /**
     * Returns if end user configuration is enabled by the inbox admin or not.
     * @return true if end user configuration is enabled and false if not enabled.
     */
    boolean isEndUserConfigurationEnabled();

    /**
     * Set the isEndUserConfigurationEnabled property.
     * @param isEndUserConfigurationEnabled true or false
     */
    void setIsEndUserConfigurationEnabled(boolean isEndUserConfigurationEnabled);

}
