/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2017 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 *
 **************************************************************************/
package com.adobe.cq.sites.ui.models.admin.security;

import com.adobe.granite.ui.components.AttrBuilder;
import com.adobe.granite.ui.components.Tag;
import com.adobe.granite.ui.components.Value;
import com.adobe.granite.ui.components.htl.ComponentHelper;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.scripting.SlingBindings;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.RequestAttribute;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.models.annotations.injectorspecific.SlingObject;

import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.script.SimpleBindings;

import com.adobe.granite.ui.components.Options;

/**
 * Representation of the login path field, used when the authentication requirement is enabled to access a given content resource.
 *
 * The login path could be enabled / disabled from the UI (for instance in the page properties view)
 *
 * The content resource is derived from the content path attribute of the request.
 */
@Model(adaptables = SlingHttpServletRequest.class)
public final class LoginPath extends ComponentHelper {

    private static final String MN_AUTHENTICATION_REQUIRED = "granite:loginPath";

    @Self
    private SlingHttpServletRequest slingRequest;

    @Inject
    @SlingObject
    private Resource resource;

    @Inject
    private ResourceResolver resolver;

    @Inject @Named("org.apache.sling.api.scripting.SlingBindings")
    private SlingBindings slingBindings;

    @RequestAttribute(optional = true, name = Value.CONTENTPATH_ATTRIBUTE)
    private String contentPath;

    private String value;

    @Override
    protected void activate() throws Exception {
    }

    @PostConstruct
    protected void initModel() throws RepositoryException {
        init(new SimpleBindings(slingBindings));

        if (contentPath != null) {
            Resource contentResource = resolver.getResource(contentPath);

            if (contentResource != null) {
                Resource parentResource = contentResource.getParent();
                if (parentResource != null) {
                    value = parentResource.getValueMap().get(MN_AUTHENTICATION_REQUIRED, String.class);
                }
            }
        }
    }

    public String getValue() {
        return value;
    }

    public Options getPathOptions() {
        AttrBuilder attrs = new AttrBuilder(slingRequest, getXss());

        attrs.addClass("js-sites-properties-LoginPath");
        attrs.add("data-foundation-autocomplete-value", getValue());

        return new Options().tag(new Tag(attrs));
    }
}

