/*******************************************************************************
 *  ADOBE CONFIDENTIAL
 *  ___________________
 *
 *  Copyright 2022 Adobe
 *  All Rights Reserved.
 *
 *  NOTICE: All information contained herein is, and remains
 *  the property of Adobe and its suppliers, if any. The intellectual
 *  and technical concepts contained herein are proprietary to Adobe
 *  and its suppliers and are protected by all applicable intellectual
 *  property laws, including trade secret and copyright laws.
 *  Dissemination of this information or reproduction of this material
 *  is strictly forbidden unless prior written permission is obtained
 *  from Adobe.
 ******************************************************************************/

package com.adobe.cq.wcm.spi;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import org.apache.sling.api.resource.Resource;
import org.osgi.annotation.versioning.ConsumerType;

/**
 * Implementations of this service interface declare themselves capable of handling asset delivery, primarily by accepting a {@link Resource} and an optional {@link Map} of desired transformations to be applied while delivering it.<br>
 * Implementations must provide a {@link #getDeliveryURL} method for this purpose, which should return a URL if it can handle the asset and its requested transforms, or {@code null} otherwise.<br>
 * Multiple implementations of this service may exist at any given time, potentially with different service rankings; consumers of this service may choose to handle them as they deem fit.
 */
@ConsumerType
public interface AssetDelivery {
    
    /**
     * This method returns the url to retrieve a specific asset with provided collection of Parameters.
     * @param resource Resource for which delivery URL is needed
     * @param parameterMap Collection of parameters that are required to fetch the url such as width, height quality etc.
     * @return delivery url from which asset can be retrieved, null if delivery url cannot be generated.
     */
    @Nullable
    String getDeliveryURL(@Nonnull Resource resource, @Nullable Map<String, Object> parameterMap);
}
