/**
 * 
 */
package com.adobe.fontengine.font.opentype;

import java.util.Map;

import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.Subset;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.opentype.LayoutTable.ClassConsumer;
import com.adobe.fontengine.font.opentype.LookupTableHarvester.CoverageLookupHarvester;

class ContextFormat2Harvester implements CoverageLookupHarvester, ClassConsumer {
	  private Map lookups;
	  private Subset gids;
	  private boolean classCoveredBySet;
	  private final LookupTableHarvester harvester;
	  
	  ContextFormat2Harvester(LookupTableHarvester harvester, Map lookups)
	  {
		  this.lookups = lookups;
		  this.harvester = harvester;
	  }
	  
	  public boolean glyph(int glyphID, int classID) throws UnsupportedFontException, InvalidFontException 
	  {
		  if (gids.getExistingSubsetGid(glyphID) != -1) 
		  {
			  classCoveredBySet = true;
			  return false;
		  }
		  return true;
	  }
	  
	  public boolean lookupApplies(int coverageGlyph, int stOffset, int coverageIndex, Subset gids) throws InvalidFontException, UnsupportedFontException {
		  this.gids = gids;
		  
		  int classDefOffset = harvester.lookupTable.data.getOffset (stOffset, 4);
		  int classIndex = harvester.lookupTable.getClassIndex(coverageGlyph, classDefOffset);
		  int subclassSetOffset = harvester.lookupTable.data.getOffset(stOffset, 8 + 2*classIndex);
		  if (subclassSetOffset == 0)
			  return false;
		  
		  boolean applies = false;
		  
		  int subclassRuleCount = harvester.lookupTable.data.getuint16(subclassSetOffset);
		  for (int i = 0; i < subclassRuleCount; i++) {
			  int subclassRuleOffset = harvester.lookupTable.data.getOffset(subclassSetOffset, 2 + 2*i);
			  int j;
			  int classCount = harvester.lookupTable.data.getuint16(subclassRuleOffset);
			  classCoveredBySet = true;
			  for (j = 0; j < classCount-1; j++) {
				  classCoveredBySet = false;
				  int theClass = harvester.lookupTable.data.getuint16(subclassRuleOffset + 4 + 2*j);
				  harvester.lookupTable.iterateClass(classDefOffset, harvester.numGlyphs, this, theClass);		
				  if (!classCoveredBySet)
					  break;
			  }
			  
			  if (classCoveredBySet) {
				  int lookupCount = harvester.lookupTable.data.getuint16(subclassRuleOffset+2);
				  for (j = 0; j < lookupCount; j++)
				  {
					  int lookupIndex = harvester.lookupTable.data.getuint16(subclassRuleOffset + 4 + 2*(classCount-1) + 4*j + 2);
					  // Note that this is a little bit loose. If we wanted the tightest set, we'd
					  // only harvest on the glyphs that this lookup applies to. However, I'll work on the
					  // assumption that if this sublookup applies to other glyphs in 'gids', then there will be
					  // a path that gets us there in most fonts, so we'll want it eventually anyway.(That's a
					  // good sounding justification for matching cooltype's behavior anyway...)
					  harvester.harvest(gids, lookupIndex, lookups);
				  }
				  
				  applies = true;
			  }
		  }
		  
		  return applies;
	  }
	  
	  public boolean keepGoing() {
		return true;
	}
  }