/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2005 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */
package com.adobe.xfa;

/**
 * A type-safe enumeration class of the XFA ImagingBBox attribute.
 * The enum also allows four comma space measurements.
 *
 * @exclude from published api -- Mike Tardif, May 2006.
 */
public final class ImagingBBoxEnum extends Attribute {

	public ImagingBBoxEnum(String NS, String localName, String qName, String value) {
		this(NS, localName, qName, value, true);
	}
	
	private ImagingBBoxEnum(String NS, String localName, String qName, String value, boolean internSymbols) {
		super(NS, localName, qName, value, internSymbols);
	}


	/**
	 * Construct an ImagingBBoxEnumfrom a string value.
	 * 
	 * @param name
	 *            a string corresponding to one of the enumerated values
	 * @exception InvalidPropertyValueException
	 *                if we're given an invalid value.
	 */
	public ImagingBBoxEnum(String name, String value) {
		super(name, value);
	}

	public Attribute newAttribute(String value) {
		// It's safe to return the wrapper, since it's guaranteed to refer to
		// a static implementation which will remain in scope.
		return newAttribute(getNS(), getLocalName(), getQName(), value, false);
	}

	/* (non-Javadoc)
	 * @see com.adobe.xfa.Attribute#newAttribute(java.lang.String, java.lang.String, java.lang.String, java.lang.String)
	 */
	public Attribute newAttribute(String NS, String localName, String qName, String value) {
		return newAttribute(NS, localName, qName, value, true);
	}
	
	/* (non-Javadoc)
	 * @see com.adobe.xfa.Attribute#newAttribute(java.lang.String, java.lang.String, java.lang.String, java.lang.String, boolean)
	 */
	public Attribute newAttribute(String NS, String localName, String qName, String value, boolean internSymbols) {
		return new ImagingBBoxEnum(NS, localName, qName, value, internSymbols);
	}

}
