package com.adobe.xfa.text;

/**
 * @exclude from published api.
 */

class Composition {
	private final int[] mpcSourceRun;
	private int mnLength;
	private int mnSplit;
	private boolean mbDoComposition;
	private int mcPrecomposedChar;

	private final static int COMPOSE_ON  = 0x10000000;
	private final static int COMPOSE_OFF = 0x00000000;

	private static class CompositionData {
		final int mnData;
		final int[] mpcSequence;

		CompositionData (int c, int onoff, int[] sequence) {
			mnData = c | onoff;
			mpcSequence = sequence;
		}
	}

	private final static int gcPre_00C0[] = {0x0041, 0x0300};
	private final static int gcPre_00C1[] = {0x0041, 0x0301};
	private final static int gcPre_00C2[] = {0x0041, 0x0302};
	private final static int gcPre_00C3[] = {0x0041, 0x0303};
	private final static int gcPre_00C4[] = {0x0041, 0x0308};
	private final static int gcPre_00C5[] = {0x0041, 0x030A};
	private final static int gcPre_00C7[] = {0x0043, 0x0327};
	private final static int gcPre_00C8[] = {0x0045, 0x0300};
	private final static int gcPre_00C9[] = {0x0045, 0x0301};
	private final static int gcPre_00CA[] = {0x0045, 0x0302};
	private final static int gcPre_00CB[] = {0x0045, 0x0308};
	private final static int gcPre_00CC[] = {0x0049, 0x0300};
	private final static int gcPre_00CD[] = {0x0049, 0x0301};
	private final static int gcPre_00CE[] = {0x0049, 0x0302};
	private final static int gcPre_00CF[] = {0x0049, 0x0308};
	private final static int gcPre_00D1[] = {0x004E, 0x0303};
	private final static int gcPre_00D2[] = {0x004F, 0x0300};
	private final static int gcPre_00D3[] = {0x004F, 0x0301};
	private final static int gcPre_00D4[] = {0x004F, 0x0302};
	private final static int gcPre_00D5[] = {0x004F, 0x0303};
	private final static int gcPre_00D6[] = {0x004F, 0x0308};
	private final static int gcPre_00D9[] = {0x0055, 0x0300};
	private final static int gcPre_00DA[] = {0x0055, 0x0301};
	private final static int gcPre_00DB[] = {0x0055, 0x0302};
	private final static int gcPre_00DC[] = {0x0055, 0x0308};
	private final static int gcPre_00DD[] = {0x0059, 0x0301};
	private final static int gcPre_00E0[] = {0x0061, 0x0300};
	private final static int gcPre_00E1[] = {0x0061, 0x0301};
	private final static int gcPre_00E2[] = {0x0061, 0x0302};
	private final static int gcPre_00E3[] = {0x0061, 0x0303};
	private final static int gcPre_00E4[] = {0x0061, 0x0308};
	private final static int gcPre_00E5[] = {0x0061, 0x030A};
	private final static int gcPre_00E7[] = {0x0063, 0x0327};
	private final static int gcPre_00E8[] = {0x0065, 0x0300};
	private final static int gcPre_00E9[] = {0x0065, 0x0301};
	private final static int gcPre_00EA[] = {0x0065, 0x0302};
	private final static int gcPre_00EB[] = {0x0065, 0x0308};
	private final static int gcPre_00EC[] = {0x0069, 0x0300};
	private final static int gcPre_00ED[] = {0x0069, 0x0301};
	private final static int gcPre_00EE[] = {0x0069, 0x0302};
	private final static int gcPre_00EF[] = {0x0069, 0x0308};
	private final static int gcPre_00F1[] = {0x006E, 0x0303};
	private final static int gcPre_00F2[] = {0x006F, 0x0300};
	private final static int gcPre_00F3[] = {0x006F, 0x0301};
	private final static int gcPre_00F4[] = {0x006F, 0x0302};
	private final static int gcPre_00F5[] = {0x006F, 0x0303};
	private final static int gcPre_00F6[] = {0x006F, 0x0308};
	private final static int gcPre_00F9[] = {0x0075, 0x0300};
	private final static int gcPre_00FA[] = {0x0075, 0x0301};
	private final static int gcPre_00FB[] = {0x0075, 0x0302};
	private final static int gcPre_00FC[] = {0x0075, 0x0308};
	private final static int gcPre_00FD[] = {0x0079, 0x0301};
	private final static int gcPre_00FF[] = {0x0079, 0x0308};
	private final static int gcPre_0100[] = {0x0041, 0x0304};
	private final static int gcPre_0101[] = {0x0061, 0x0304};
	private final static int gcPre_0102[] = {0x0041, 0x0306};
	private final static int gcPre_0103[] = {0x0061, 0x0306};
	private final static int gcPre_0104[] = {0x0041, 0x0328};
	private final static int gcPre_0105[] = {0x0061, 0x0328};
	private final static int gcPre_0106[] = {0x0043, 0x0301};
	private final static int gcPre_0107[] = {0x0063, 0x0301};
	private final static int gcPre_0108[] = {0x0043, 0x0302};
	private final static int gcPre_0109[] = {0x0063, 0x0302};
	private final static int gcPre_010A[] = {0x0043, 0x0307};
	private final static int gcPre_010B[] = {0x0063, 0x0307};
	private final static int gcPre_010C[] = {0x0043, 0x030C};
	private final static int gcPre_010D[] = {0x0063, 0x030C};
	private final static int gcPre_010E[] = {0x0044, 0x030C};
	private final static int gcPre_010F[] = {0x0064, 0x030C};
	private final static int gcPre_0112[] = {0x0045, 0x0304};
	private final static int gcPre_0113[] = {0x0065, 0x0304};
	private final static int gcPre_0114[] = {0x0045, 0x0306};
	private final static int gcPre_0115[] = {0x0065, 0x0306};
	private final static int gcPre_0116[] = {0x0045, 0x0307};
	private final static int gcPre_0117[] = {0x0065, 0x0307};
	private final static int gcPre_0118[] = {0x0045, 0x0328};
	private final static int gcPre_0119[] = {0x0065, 0x0328};
	private final static int gcPre_011A[] = {0x0045, 0x030C};
	private final static int gcPre_011B[] = {0x0065, 0x030C};
	private final static int gcPre_011C[] = {0x0047, 0x0302};
	private final static int gcPre_011D[] = {0x0067, 0x0302};
	private final static int gcPre_011E[] = {0x0047, 0x0306};
	private final static int gcPre_011F[] = {0x0067, 0x0306};
	private final static int gcPre_0120[] = {0x0047, 0x0307};
	private final static int gcPre_0121[] = {0x0067, 0x0307};
	private final static int gcPre_0122[] = {0x0047, 0x0327};
	private final static int gcPre_0123[] = {0x0067, 0x0327};
	private final static int gcPre_0124[] = {0x0048, 0x0302};
	private final static int gcPre_0125[] = {0x0068, 0x0302};
	private final static int gcPre_0128[] = {0x0049, 0x0303};
	private final static int gcPre_0129[] = {0x0069, 0x0303};
	private final static int gcPre_012A[] = {0x0049, 0x0304};
	private final static int gcPre_012B[] = {0x0069, 0x0304};
	private final static int gcPre_012C[] = {0x0049, 0x0306};
	private final static int gcPre_012D[] = {0x0069, 0x0306};
	private final static int gcPre_012E[] = {0x0049, 0x0328};
	private final static int gcPre_012F[] = {0x0069, 0x0328};
	private final static int gcPre_0130[] = {0x0049, 0x0307};
	private final static int gcPre_0134[] = {0x004A, 0x0302};
	private final static int gcPre_0135[] = {0x006A, 0x0302};
	private final static int gcPre_0136[] = {0x004B, 0x0327};
	private final static int gcPre_0137[] = {0x006B, 0x0327};
	private final static int gcPre_0139[] = {0x004C, 0x0301};
	private final static int gcPre_013A[] = {0x006C, 0x0301};
	private final static int gcPre_013B[] = {0x004C, 0x0327};
	private final static int gcPre_013C[] = {0x006C, 0x0327};
	private final static int gcPre_013D[] = {0x004C, 0x030C};
	private final static int gcPre_013E[] = {0x006C, 0x030C};
	private final static int gcPre_0143[] = {0x004E, 0x0301};
	private final static int gcPre_0144[] = {0x006E, 0x0301};
	private final static int gcPre_0145[] = {0x004E, 0x0327};
	private final static int gcPre_0146[] = {0x006E, 0x0327};
	private final static int gcPre_0147[] = {0x004E, 0x030C};
	private final static int gcPre_0148[] = {0x006E, 0x030C};
	private final static int gcPre_014C[] = {0x004F, 0x0304};
	private final static int gcPre_014D[] = {0x006F, 0x0304};
	private final static int gcPre_014E[] = {0x004F, 0x0306};
	private final static int gcPre_014F[] = {0x006F, 0x0306};
	private final static int gcPre_0150[] = {0x004F, 0x030B};
	private final static int gcPre_0151[] = {0x006F, 0x030B};
	private final static int gcPre_0154[] = {0x0052, 0x0301};
	private final static int gcPre_0155[] = {0x0072, 0x0301};
	private final static int gcPre_0156[] = {0x0052, 0x0327};
	private final static int gcPre_0157[] = {0x0072, 0x0327};
	private final static int gcPre_0158[] = {0x0052, 0x030C};
	private final static int gcPre_0159[] = {0x0072, 0x030C};
	private final static int gcPre_015A[] = {0x0053, 0x0301};
	private final static int gcPre_015B[] = {0x0073, 0x0301};
	private final static int gcPre_015C[] = {0x0053, 0x0302};
	private final static int gcPre_015D[] = {0x0073, 0x0302};
	private final static int gcPre_015E[] = {0x0053, 0x0327};
	private final static int gcPre_015F[] = {0x0073, 0x0327};
	private final static int gcPre_0160[] = {0x0053, 0x030C};
	private final static int gcPre_0161[] = {0x0073, 0x030C};
	private final static int gcPre_0162[] = {0x0054, 0x0327};
	private final static int gcPre_0163[] = {0x0074, 0x0327};
	private final static int gcPre_0164[] = {0x0054, 0x030C};
	private final static int gcPre_0165[] = {0x0074, 0x030C};
	private final static int gcPre_0168[] = {0x0055, 0x0303};
	private final static int gcPre_0169[] = {0x0075, 0x0303};
	private final static int gcPre_016A[] = {0x0055, 0x0304};
	private final static int gcPre_016B[] = {0x0075, 0x0304};
	private final static int gcPre_016C[] = {0x0055, 0x0306};
	private final static int gcPre_016D[] = {0x0075, 0x0306};
	private final static int gcPre_016E[] = {0x0055, 0x030A};
	private final static int gcPre_016F[] = {0x0075, 0x030A};
	private final static int gcPre_0170[] = {0x0055, 0x030B};
	private final static int gcPre_0171[] = {0x0075, 0x030B};
	private final static int gcPre_0172[] = {0x0055, 0x0328};
	private final static int gcPre_0173[] = {0x0075, 0x0328};
	private final static int gcPre_0174[] = {0x0057, 0x0302};
	private final static int gcPre_0175[] = {0x0077, 0x0302};
	private final static int gcPre_0176[] = {0x0059, 0x0302};
	private final static int gcPre_0177[] = {0x0079, 0x0302};
	private final static int gcPre_0178[] = {0x0059, 0x0308};
	private final static int gcPre_0179[] = {0x005A, 0x0301};
	private final static int gcPre_017A[] = {0x007A, 0x0301};
	private final static int gcPre_017B[] = {0x005A, 0x0307};
	private final static int gcPre_017C[] = {0x007A, 0x0307};
	private final static int gcPre_017D[] = {0x005A, 0x030C};
	private final static int gcPre_017E[] = {0x007A, 0x030C};
	private final static int gcPre_01A0[] = {0x004F, 0x031B};
	private final static int gcPre_01A1[] = {0x006F, 0x031B};
	private final static int gcPre_01AF[] = {0x0055, 0x031B};
	private final static int gcPre_01B0[] = {0x0075, 0x031B};
	private final static int gcPre_01CD[] = {0x0041, 0x030C};
	private final static int gcPre_01CE[] = {0x0061, 0x030C};
	private final static int gcPre_01CF[] = {0x0049, 0x030C};
	private final static int gcPre_01D0[] = {0x0069, 0x030C};
	private final static int gcPre_01D1[] = {0x004F, 0x030C};
	private final static int gcPre_01D2[] = {0x006F, 0x030C};
	private final static int gcPre_01D3[] = {0x0055, 0x030C};
	private final static int gcPre_01D4[] = {0x0075, 0x030C};
	private final static int gcPre_01D5[] = {0x00DC, 0x0304};
	private final static int gcPre_01D6[] = {0x00FC, 0x0304};
	private final static int gcPre_01D7[] = {0x00DC, 0x0301};
	private final static int gcPre_01D8[] = {0x00FC, 0x0301};
	private final static int gcPre_01D9[] = {0x00DC, 0x030C};
	private final static int gcPre_01DA[] = {0x00FC, 0x030C};
	private final static int gcPre_01DB[] = {0x00DC, 0x0300};
	private final static int gcPre_01DC[] = {0x00FC, 0x0300};
	private final static int gcPre_01DE[] = {0x00C4, 0x0304};
	private final static int gcPre_01DF[] = {0x00E4, 0x0304};
	private final static int gcPre_01E0[] = {0x0226, 0x0304};
	private final static int gcPre_01E1[] = {0x0227, 0x0304};
	private final static int gcPre_01E2[] = {0x00C6, 0x0304};
	private final static int gcPre_01E3[] = {0x00E6, 0x0304};
	private final static int gcPre_01E6[] = {0x0047, 0x030C};
	private final static int gcPre_01E7[] = {0x0067, 0x030C};
	private final static int gcPre_01E8[] = {0x004B, 0x030C};
	private final static int gcPre_01E9[] = {0x006B, 0x030C};
	private final static int gcPre_01EA[] = {0x004F, 0x0328};
	private final static int gcPre_01EB[] = {0x006F, 0x0328};
	private final static int gcPre_01EC[] = {0x01EA, 0x0304};
	private final static int gcPre_01ED[] = {0x01EB, 0x0304};
	private final static int gcPre_01EE[] = {0x01B7, 0x030C};
	private final static int gcPre_01EF[] = {0x0292, 0x030C};
	private final static int gcPre_01F0[] = {0x006A, 0x030C};
	private final static int gcPre_01F4[] = {0x0047, 0x0301};
	private final static int gcPre_01F5[] = {0x0067, 0x0301};
	private final static int gcPre_01F8[] = {0x004E, 0x0300};
	private final static int gcPre_01F9[] = {0x006E, 0x0300};
	private final static int gcPre_01FA[] = {0x00C5, 0x0301};
	private final static int gcPre_01FB[] = {0x00E5, 0x0301};
	private final static int gcPre_01FC[] = {0x00C6, 0x0301};
	private final static int gcPre_01FD[] = {0x00E6, 0x0301};
	private final static int gcPre_01FE[] = {0x00D8, 0x0301};
	private final static int gcPre_01FF[] = {0x00F8, 0x0301};
	private final static int gcPre_0200[] = {0x0041, 0x030F};
	private final static int gcPre_0201[] = {0x0061, 0x030F};
	private final static int gcPre_0202[] = {0x0041, 0x0311};
	private final static int gcPre_0203[] = {0x0061, 0x0311};
	private final static int gcPre_0204[] = {0x0045, 0x030F};
	private final static int gcPre_0205[] = {0x0065, 0x030F};
	private final static int gcPre_0206[] = {0x0045, 0x0311};
	private final static int gcPre_0207[] = {0x0065, 0x0311};
	private final static int gcPre_0208[] = {0x0049, 0x030F};
	private final static int gcPre_0209[] = {0x0069, 0x030F};
	private final static int gcPre_020A[] = {0x0049, 0x0311};
	private final static int gcPre_020B[] = {0x0069, 0x0311};
	private final static int gcPre_020C[] = {0x004F, 0x030F};
	private final static int gcPre_020D[] = {0x006F, 0x030F};
	private final static int gcPre_020E[] = {0x004F, 0x0311};
	private final static int gcPre_020F[] = {0x006F, 0x0311};
	private final static int gcPre_0210[] = {0x0052, 0x030F};
	private final static int gcPre_0211[] = {0x0072, 0x030F};
	private final static int gcPre_0212[] = {0x0052, 0x0311};
	private final static int gcPre_0213[] = {0x0072, 0x0311};
	private final static int gcPre_0214[] = {0x0055, 0x030F};
	private final static int gcPre_0215[] = {0x0075, 0x030F};
	private final static int gcPre_0216[] = {0x0055, 0x0311};
	private final static int gcPre_0217[] = {0x0075, 0x0311};
	private final static int gcPre_0218[] = {0x0053, 0x0326};
	private final static int gcPre_0219[] = {0x0073, 0x0326};
	private final static int gcPre_021A[] = {0x0054, 0x0326};
	private final static int gcPre_021B[] = {0x0074, 0x0326};
	private final static int gcPre_021E[] = {0x0048, 0x030C};
	private final static int gcPre_021F[] = {0x0068, 0x030C};
	private final static int gcPre_0226[] = {0x0041, 0x0307};
	private final static int gcPre_0227[] = {0x0061, 0x0307};
	private final static int gcPre_0228[] = {0x0045, 0x0327};
	private final static int gcPre_0229[] = {0x0065, 0x0327};
	private final static int gcPre_022A[] = {0x00D6, 0x0304};
	private final static int gcPre_022B[] = {0x00F6, 0x0304};
	private final static int gcPre_022C[] = {0x00D5, 0x0304};
	private final static int gcPre_022D[] = {0x00F5, 0x0304};
	private final static int gcPre_022E[] = {0x004F, 0x0307};
	private final static int gcPre_022F[] = {0x006F, 0x0307};
	private final static int gcPre_0230[] = {0x022E, 0x0304};
	private final static int gcPre_0231[] = {0x022F, 0x0304};
	private final static int gcPre_0232[] = {0x0059, 0x0304};
	private final static int gcPre_0233[] = {0x0079, 0x0304};
	private final static int gcPre_0385[] = {0x00A8, 0x0301};
	private final static int gcPre_0386[] = {0x0391, 0x0301};
	private final static int gcPre_0388[] = {0x0395, 0x0301};
	private final static int gcPre_0389[] = {0x0397, 0x0301};
	private final static int gcPre_038A[] = {0x0399, 0x0301};
	private final static int gcPre_038C[] = {0x039F, 0x0301};
	private final static int gcPre_038E[] = {0x03A5, 0x0301};
	private final static int gcPre_038F[] = {0x03A9, 0x0301};
	private final static int gcPre_0390[] = {0x03CA, 0x0301};
	private final static int gcPre_03AA[] = {0x0399, 0x0308};
	private final static int gcPre_03AB[] = {0x03A5, 0x0308};
	private final static int gcPre_03AC[] = {0x03B1, 0x0301};
	private final static int gcPre_03AD[] = {0x03B5, 0x0301};
	private final static int gcPre_03AE[] = {0x03B7, 0x0301};
	private final static int gcPre_03AF[] = {0x03B9, 0x0301};
	private final static int gcPre_03B0[] = {0x03CB, 0x0301};
	private final static int gcPre_03CA[] = {0x03B9, 0x0308};
	private final static int gcPre_03CB[] = {0x03C5, 0x0308};
	private final static int gcPre_03CC[] = {0x03BF, 0x0301};
	private final static int gcPre_03CD[] = {0x03C5, 0x0301};
	private final static int gcPre_03CE[] = {0x03C9, 0x0301};
	private final static int gcPre_03D3[] = {0x03D2, 0x0301};
	private final static int gcPre_03D4[] = {0x03D2, 0x0308};
	private final static int gcPre_0400[] = {0x0415, 0x0300};
	private final static int gcPre_0401[] = {0x0415, 0x0308};
	private final static int gcPre_0403[] = {0x0413, 0x0301};
	private final static int gcPre_0407[] = {0x0406, 0x0308};
	private final static int gcPre_040C[] = {0x041A, 0x0301};
	private final static int gcPre_040D[] = {0x0418, 0x0300};
	private final static int gcPre_040E[] = {0x0423, 0x0306};
	private final static int gcPre_0419[] = {0x0418, 0x0306};
	private final static int gcPre_0439[] = {0x0438, 0x0306};
	private final static int gcPre_0450[] = {0x0435, 0x0300};
	private final static int gcPre_0451[] = {0x0435, 0x0308};
	private final static int gcPre_0453[] = {0x0433, 0x0301};
	private final static int gcPre_0457[] = {0x0456, 0x0308};
	private final static int gcPre_045C[] = {0x043A, 0x0301};
	private final static int gcPre_045D[] = {0x0438, 0x0300};
	private final static int gcPre_045E[] = {0x0443, 0x0306};
	private final static int gcPre_0476[] = {0x0474, 0x030F};
	private final static int gcPre_0477[] = {0x0475, 0x030F};
	private final static int gcPre_04C1[] = {0x0416, 0x0306};
	private final static int gcPre_04C2[] = {0x0436, 0x0306};
	private final static int gcPre_04D0[] = {0x0410, 0x0306};
	private final static int gcPre_04D1[] = {0x0430, 0x0306};
	private final static int gcPre_04D2[] = {0x0410, 0x0308};
	private final static int gcPre_04D3[] = {0x0430, 0x0308};
	private final static int gcPre_04D6[] = {0x0415, 0x0306};
	private final static int gcPre_04D7[] = {0x0435, 0x0306};
	private final static int gcPre_04DA[] = {0x04D8, 0x0308};
	private final static int gcPre_04DB[] = {0x04D9, 0x0308};
	private final static int gcPre_04DC[] = {0x0416, 0x0308};
	private final static int gcPre_04DD[] = {0x0436, 0x0308};
	private final static int gcPre_04DE[] = {0x0417, 0x0308};
	private final static int gcPre_04DF[] = {0x0437, 0x0308};
	private final static int gcPre_04E2[] = {0x0418, 0x0304};
	private final static int gcPre_04E3[] = {0x0438, 0x0304};
	private final static int gcPre_04E4[] = {0x0418, 0x0308};
	private final static int gcPre_04E5[] = {0x0438, 0x0308};
	private final static int gcPre_04E6[] = {0x041E, 0x0308};
	private final static int gcPre_04E7[] = {0x043E, 0x0308};
	private final static int gcPre_04EA[] = {0x04E8, 0x0308};
	private final static int gcPre_04EB[] = {0x04E9, 0x0308};
	private final static int gcPre_04EC[] = {0x042D, 0x0308};
	private final static int gcPre_04ED[] = {0x044D, 0x0308};
	private final static int gcPre_04EE[] = {0x0423, 0x0304};
	private final static int gcPre_04EF[] = {0x0443, 0x0304};
	private final static int gcPre_04F0[] = {0x0423, 0x0308};
	private final static int gcPre_04F1[] = {0x0443, 0x0308};
	private final static int gcPre_04F2[] = {0x0423, 0x030B};
	private final static int gcPre_04F3[] = {0x0443, 0x030B};
	private final static int gcPre_04F4[] = {0x0427, 0x0308};
	private final static int gcPre_04F5[] = {0x0447, 0x0308};
	private final static int gcPre_04F8[] = {0x042B, 0x0308};
	private final static int gcPre_04F9[] = {0x044B, 0x0308};
	private final static int gcPre_0622[] = {0x0627, 0x0653};
	private final static int gcPre_0623[] = {0x0627, 0x0654};
	private final static int gcPre_0624[] = {0x0648, 0x0654};
	private final static int gcPre_0625[] = {0x0627, 0x0655};
	private final static int gcPre_0626[] = {0x064A, 0x0654};
	private final static int gcPre_06C0[] = {0x06D5, 0x0654};
	private final static int gcPre_06C2[] = {0x06C1, 0x0654};
	private final static int gcPre_06D3[] = {0x06D2, 0x0654};
	private final static int gcPre_0929[] = {0x0928, 0x093C};
	private final static int gcPre_0931[] = {0x0930, 0x093C};
	private final static int gcPre_0934[] = {0x0933, 0x093C};
	private final static int gcPre_0958[] = {0x0915, 0x093C};
	private final static int gcPre_0959[] = {0x0916, 0x093C};
	private final static int gcPre_095A[] = {0x0917, 0x093C};
	private final static int gcPre_095B[] = {0x091C, 0x093C};
	private final static int gcPre_095C[] = {0x0921, 0x093C};
	private final static int gcPre_095D[] = {0x0922, 0x093C};
	private final static int gcPre_095E[] = {0x092B, 0x093C};
	private final static int gcPre_095F[] = {0x092F, 0x093C};
	private final static int gcPre_09DC[] = {0x09A1, 0x09BC};
	private final static int gcPre_09DD[] = {0x09A2, 0x09BC};
	private final static int gcPre_09DF[] = {0x09AF, 0x09BC};
	private final static int gcPre_0A33[] = {0x0A32, 0x0A3C};
	private final static int gcPre_0A36[] = {0x0A38, 0x0A3C};
	private final static int gcPre_0A59[] = {0x0A16, 0x0A3C};
	private final static int gcPre_0A5A[] = {0x0A17, 0x0A3C};
	private final static int gcPre_0A5B[] = {0x0A1C, 0x0A3C};
	private final static int gcPre_0A5E[] = {0x0A2B, 0x0A3C};
	private final static int gcPre_0B5C[] = {0x0B21, 0x0B3C};
	private final static int gcPre_0B5D[] = {0x0B22, 0x0B3C};
	private final static int gcPre_0B94[] = {0x0B92, 0x0BD7};
	private final static int gcPre_0F43[] = {0x0F42, 0x0FB7};
	private final static int gcPre_0F4D[] = {0x0F4C, 0x0FB7};
	private final static int gcPre_0F52[] = {0x0F51, 0x0FB7};
	private final static int gcPre_0F57[] = {0x0F56, 0x0FB7};
	private final static int gcPre_0F5C[] = {0x0F5B, 0x0FB7};
	private final static int gcPre_0F69[] = {0x0F40, 0x0FB5};
	private final static int gcPre_1026[] = {0x1025, 0x102E};
	private final static int gcPre_1E00[] = {0x0041, 0x0325};
	private final static int gcPre_1E01[] = {0x0061, 0x0325};
	private final static int gcPre_1E02[] = {0x0042, 0x0307};
	private final static int gcPre_1E03[] = {0x0062, 0x0307};
	private final static int gcPre_1E04[] = {0x0042, 0x0323};
	private final static int gcPre_1E05[] = {0x0062, 0x0323};
	private final static int gcPre_1E06[] = {0x0042, 0x0331};
	private final static int gcPre_1E07[] = {0x0062, 0x0331};
	private final static int gcPre_1E08[] = {0x00C7, 0x0301};
	private final static int gcPre_1E09[] = {0x00E7, 0x0301};
	private final static int gcPre_1E0A[] = {0x0044, 0x0307};
	private final static int gcPre_1E0B[] = {0x0064, 0x0307};
	private final static int gcPre_1E0C[] = {0x0044, 0x0323};
	private final static int gcPre_1E0D[] = {0x0064, 0x0323};
	private final static int gcPre_1E0E[] = {0x0044, 0x0331};
	private final static int gcPre_1E0F[] = {0x0064, 0x0331};
	private final static int gcPre_1E10[] = {0x0044, 0x0327};
	private final static int gcPre_1E11[] = {0x0064, 0x0327};
	private final static int gcPre_1E12[] = {0x0044, 0x032D};
	private final static int gcPre_1E13[] = {0x0064, 0x032D};
	private final static int gcPre_1E14[] = {0x0112, 0x0300};
	private final static int gcPre_1E15[] = {0x0113, 0x0300};
	private final static int gcPre_1E16[] = {0x0112, 0x0301};
	private final static int gcPre_1E17[] = {0x0113, 0x0301};
	private final static int gcPre_1E18[] = {0x0045, 0x032D};
	private final static int gcPre_1E19[] = {0x0065, 0x032D};
	private final static int gcPre_1E1A[] = {0x0045, 0x0330};
	private final static int gcPre_1E1B[] = {0x0065, 0x0330};
	private final static int gcPre_1E1C[] = {0x0228, 0x0306};
	private final static int gcPre_1E1D[] = {0x0229, 0x0306};
	private final static int gcPre_1E1E[] = {0x0046, 0x0307};
	private final static int gcPre_1E1F[] = {0x0066, 0x0307};
	private final static int gcPre_1E20[] = {0x0047, 0x0304};
	private final static int gcPre_1E21[] = {0x0067, 0x0304};
	private final static int gcPre_1E22[] = {0x0048, 0x0307};
	private final static int gcPre_1E23[] = {0x0068, 0x0307};
	private final static int gcPre_1E24[] = {0x0048, 0x0323};
	private final static int gcPre_1E25[] = {0x0068, 0x0323};
	private final static int gcPre_1E26[] = {0x0048, 0x0308};
	private final static int gcPre_1E27[] = {0x0068, 0x0308};
	private final static int gcPre_1E28[] = {0x0048, 0x0327};
	private final static int gcPre_1E29[] = {0x0068, 0x0327};
	private final static int gcPre_1E2A[] = {0x0048, 0x032E};
	private final static int gcPre_1E2B[] = {0x0068, 0x032E};
	private final static int gcPre_1E2C[] = {0x0049, 0x0330};
	private final static int gcPre_1E2D[] = {0x0069, 0x0330};
	private final static int gcPre_1E2E[] = {0x00CF, 0x0301};
	private final static int gcPre_1E2F[] = {0x00EF, 0x0301};
	private final static int gcPre_1E30[] = {0x004B, 0x0301};
	private final static int gcPre_1E31[] = {0x006B, 0x0301};
	private final static int gcPre_1E32[] = {0x004B, 0x0323};
	private final static int gcPre_1E33[] = {0x006B, 0x0323};
	private final static int gcPre_1E34[] = {0x004B, 0x0331};
	private final static int gcPre_1E35[] = {0x006B, 0x0331};
	private final static int gcPre_1E36[] = {0x004C, 0x0323};
	private final static int gcPre_1E37[] = {0x006C, 0x0323};
	private final static int gcPre_1E38[] = {0x1E36, 0x0304};
	private final static int gcPre_1E39[] = {0x1E37, 0x0304};
	private final static int gcPre_1E3A[] = {0x004C, 0x0331};
	private final static int gcPre_1E3B[] = {0x006C, 0x0331};
	private final static int gcPre_1E3C[] = {0x004C, 0x032D};
	private final static int gcPre_1E3D[] = {0x006C, 0x032D};
	private final static int gcPre_1E3E[] = {0x004D, 0x0301};
	private final static int gcPre_1E3F[] = {0x006D, 0x0301};
	private final static int gcPre_1E40[] = {0x004D, 0x0307};
	private final static int gcPre_1E41[] = {0x006D, 0x0307};
	private final static int gcPre_1E42[] = {0x004D, 0x0323};
	private final static int gcPre_1E43[] = {0x006D, 0x0323};
	private final static int gcPre_1E44[] = {0x004E, 0x0307};
	private final static int gcPre_1E45[] = {0x006E, 0x0307};
	private final static int gcPre_1E46[] = {0x004E, 0x0323};
	private final static int gcPre_1E47[] = {0x006E, 0x0323};
	private final static int gcPre_1E48[] = {0x004E, 0x0331};
	private final static int gcPre_1E49[] = {0x006E, 0x0331};
	private final static int gcPre_1E4A[] = {0x004E, 0x032D};
	private final static int gcPre_1E4B[] = {0x006E, 0x032D};
	private final static int gcPre_1E4C[] = {0x00D5, 0x0301};
	private final static int gcPre_1E4D[] = {0x00F5, 0x0301};
	private final static int gcPre_1E4E[] = {0x00D5, 0x0308};
	private final static int gcPre_1E4F[] = {0x00F5, 0x0308};
	private final static int gcPre_1E50[] = {0x014C, 0x0300};
	private final static int gcPre_1E51[] = {0x014D, 0x0300};
	private final static int gcPre_1E52[] = {0x014C, 0x0301};
	private final static int gcPre_1E53[] = {0x014D, 0x0301};
	private final static int gcPre_1E54[] = {0x0050, 0x0301};
	private final static int gcPre_1E55[] = {0x0070, 0x0301};
	private final static int gcPre_1E56[] = {0x0050, 0x0307};
	private final static int gcPre_1E57[] = {0x0070, 0x0307};
	private final static int gcPre_1E58[] = {0x0052, 0x0307};
	private final static int gcPre_1E59[] = {0x0072, 0x0307};
	private final static int gcPre_1E5A[] = {0x0052, 0x0323};
	private final static int gcPre_1E5B[] = {0x0072, 0x0323};
	private final static int gcPre_1E5C[] = {0x1E5A, 0x0304};
	private final static int gcPre_1E5D[] = {0x1E5B, 0x0304};
	private final static int gcPre_1E5E[] = {0x0052, 0x0331};
	private final static int gcPre_1E5F[] = {0x0072, 0x0331};
	private final static int gcPre_1E60[] = {0x0053, 0x0307};
	private final static int gcPre_1E61[] = {0x0073, 0x0307};
	private final static int gcPre_1E62[] = {0x0053, 0x0323};
	private final static int gcPre_1E63[] = {0x0073, 0x0323};
	private final static int gcPre_1E64[] = {0x015A, 0x0307};
	private final static int gcPre_1E65[] = {0x015B, 0x0307};
	private final static int gcPre_1E66[] = {0x0160, 0x0307};
	private final static int gcPre_1E67[] = {0x0161, 0x0307};
	private final static int gcPre_1E68[] = {0x1E62, 0x0307};
	private final static int gcPre_1E69[] = {0x1E63, 0x0307};
	private final static int gcPre_1E6A[] = {0x0054, 0x0307};
	private final static int gcPre_1E6B[] = {0x0074, 0x0307};
	private final static int gcPre_1E6C[] = {0x0054, 0x0323};
	private final static int gcPre_1E6D[] = {0x0074, 0x0323};
	private final static int gcPre_1E6E[] = {0x0054, 0x0331};
	private final static int gcPre_1E6F[] = {0x0074, 0x0331};
	private final static int gcPre_1E70[] = {0x0054, 0x032D};
	private final static int gcPre_1E71[] = {0x0074, 0x032D};
	private final static int gcPre_1E72[] = {0x0055, 0x0324};
	private final static int gcPre_1E73[] = {0x0075, 0x0324};
	private final static int gcPre_1E74[] = {0x0055, 0x0330};
	private final static int gcPre_1E75[] = {0x0075, 0x0330};
	private final static int gcPre_1E76[] = {0x0055, 0x032D};
	private final static int gcPre_1E77[] = {0x0075, 0x032D};
	private final static int gcPre_1E78[] = {0x0168, 0x0301};
	private final static int gcPre_1E79[] = {0x0169, 0x0301};
	private final static int gcPre_1E7A[] = {0x016A, 0x0308};
	private final static int gcPre_1E7B[] = {0x016B, 0x0308};
	private final static int gcPre_1E7C[] = {0x0056, 0x0303};
	private final static int gcPre_1E7D[] = {0x0076, 0x0303};
	private final static int gcPre_1E7E[] = {0x0056, 0x0323};
	private final static int gcPre_1E7F[] = {0x0076, 0x0323};
	private final static int gcPre_1E80[] = {0x0057, 0x0300};
	private final static int gcPre_1E81[] = {0x0077, 0x0300};
	private final static int gcPre_1E82[] = {0x0057, 0x0301};
	private final static int gcPre_1E83[] = {0x0077, 0x0301};
	private final static int gcPre_1E84[] = {0x0057, 0x0308};
	private final static int gcPre_1E85[] = {0x0077, 0x0308};
	private final static int gcPre_1E86[] = {0x0057, 0x0307};
	private final static int gcPre_1E87[] = {0x0077, 0x0307};
	private final static int gcPre_1E88[] = {0x0057, 0x0323};
	private final static int gcPre_1E89[] = {0x0077, 0x0323};
	private final static int gcPre_1E8A[] = {0x0058, 0x0307};
	private final static int gcPre_1E8B[] = {0x0078, 0x0307};
	private final static int gcPre_1E8C[] = {0x0058, 0x0308};
	private final static int gcPre_1E8D[] = {0x0078, 0x0308};
	private final static int gcPre_1E8E[] = {0x0059, 0x0307};
	private final static int gcPre_1E8F[] = {0x0079, 0x0307};
	private final static int gcPre_1E90[] = {0x005A, 0x0302};
	private final static int gcPre_1E91[] = {0x007A, 0x0302};
	private final static int gcPre_1E92[] = {0x005A, 0x0323};
	private final static int gcPre_1E93[] = {0x007A, 0x0323};
	private final static int gcPre_1E94[] = {0x005A, 0x0331};
	private final static int gcPre_1E95[] = {0x007A, 0x0331};
	private final static int gcPre_1E96[] = {0x0068, 0x0331};
	private final static int gcPre_1E97[] = {0x0074, 0x0308};
	private final static int gcPre_1E98[] = {0x0077, 0x030A};
	private final static int gcPre_1E99[] = {0x0079, 0x030A};
	private final static int gcPre_1E9B[] = {0x017F, 0x0307};
	private final static int gcPre_1EA0[] = {0x0041, 0x0323};
	private final static int gcPre_1EA1[] = {0x0061, 0x0323};
	private final static int gcPre_1EA2[] = {0x0041, 0x0309};
	private final static int gcPre_1EA3[] = {0x0061, 0x0309};
	private final static int gcPre_1EA4[] = {0x00C2, 0x0301};
	private final static int gcPre_1EA5[] = {0x00E2, 0x0301};
	private final static int gcPre_1EA6[] = {0x00C2, 0x0300};
	private final static int gcPre_1EA7[] = {0x00E2, 0x0300};
	private final static int gcPre_1EA8[] = {0x00C2, 0x0309};
	private final static int gcPre_1EA9[] = {0x00E2, 0x0309};
	private final static int gcPre_1EAA[] = {0x00C2, 0x0303};
	private final static int gcPre_1EAB[] = {0x00E2, 0x0303};
	private final static int gcPre_1EAC[] = {0x1EA0, 0x0302};
	private final static int gcPre_1EAD[] = {0x1EA1, 0x0302};
	private final static int gcPre_1EAE[] = {0x0102, 0x0301};
	private final static int gcPre_1EAF[] = {0x0103, 0x0301};
	private final static int gcPre_1EB0[] = {0x0102, 0x0300};
	private final static int gcPre_1EB1[] = {0x0103, 0x0300};
	private final static int gcPre_1EB2[] = {0x0102, 0x0309};
	private final static int gcPre_1EB3[] = {0x0103, 0x0309};
	private final static int gcPre_1EB4[] = {0x0102, 0x0303};
	private final static int gcPre_1EB5[] = {0x0103, 0x0303};
	private final static int gcPre_1EB6[] = {0x1EA0, 0x0306};
	private final static int gcPre_1EB7[] = {0x1EA1, 0x0306};
	private final static int gcPre_1EB8[] = {0x0045, 0x0323};
	private final static int gcPre_1EB9[] = {0x0065, 0x0323};
	private final static int gcPre_1EBA[] = {0x0045, 0x0309};
	private final static int gcPre_1EBB[] = {0x0065, 0x0309};
	private final static int gcPre_1EBC[] = {0x0045, 0x0303};
	private final static int gcPre_1EBD[] = {0x0065, 0x0303};
	private final static int gcPre_1EBE[] = {0x00CA, 0x0301};
	private final static int gcPre_1EBF[] = {0x00EA, 0x0301};
	private final static int gcPre_1EC0[] = {0x00CA, 0x0300};
	private final static int gcPre_1EC1[] = {0x00EA, 0x0300};
	private final static int gcPre_1EC2[] = {0x00CA, 0x0309};
	private final static int gcPre_1EC3[] = {0x00EA, 0x0309};
	private final static int gcPre_1EC4[] = {0x00CA, 0x0303};
	private final static int gcPre_1EC5[] = {0x00EA, 0x0303};
	private final static int gcPre_1EC6[] = {0x1EB8, 0x0302};
	private final static int gcPre_1EC7[] = {0x1EB9, 0x0302};
	private final static int gcPre_1EC8[] = {0x0049, 0x0309};
	private final static int gcPre_1EC9[] = {0x0069, 0x0309};
	private final static int gcPre_1ECA[] = {0x0049, 0x0323};
	private final static int gcPre_1ECB[] = {0x0069, 0x0323};
	private final static int gcPre_1ECC[] = {0x004F, 0x0323};
	private final static int gcPre_1ECD[] = {0x006F, 0x0323};
	private final static int gcPre_1ECE[] = {0x004F, 0x0309};
	private final static int gcPre_1ECF[] = {0x006F, 0x0309};
	private final static int gcPre_1ED0[] = {0x00D4, 0x0301};
	private final static int gcPre_1ED1[] = {0x00F4, 0x0301};
	private final static int gcPre_1ED2[] = {0x00D4, 0x0300};
	private final static int gcPre_1ED3[] = {0x00F4, 0x0300};
	private final static int gcPre_1ED4[] = {0x00D4, 0x0309};
	private final static int gcPre_1ED5[] = {0x00F4, 0x0309};
	private final static int gcPre_1ED6[] = {0x00D4, 0x0303};
	private final static int gcPre_1ED7[] = {0x00F4, 0x0303};
	private final static int gcPre_1ED8[] = {0x1ECC, 0x0302};
	private final static int gcPre_1ED9[] = {0x1ECD, 0x0302};
	private final static int gcPre_1EDA[] = {0x01A0, 0x0301};
	private final static int gcPre_1EDB[] = {0x01A1, 0x0301};
	private final static int gcPre_1EDC[] = {0x01A0, 0x0300};
	private final static int gcPre_1EDD[] = {0x01A1, 0x0300};
	private final static int gcPre_1EDE[] = {0x01A0, 0x0309};
	private final static int gcPre_1EDF[] = {0x01A1, 0x0309};
	private final static int gcPre_1EE0[] = {0x01A0, 0x0303};
	private final static int gcPre_1EE1[] = {0x01A1, 0x0303};
	private final static int gcPre_1EE2[] = {0x01A0, 0x0323};
	private final static int gcPre_1EE3[] = {0x01A1, 0x0323};
	private final static int gcPre_1EE4[] = {0x0055, 0x0323};
	private final static int gcPre_1EE5[] = {0x0075, 0x0323};
	private final static int gcPre_1EE6[] = {0x0055, 0x0309};
	private final static int gcPre_1EE7[] = {0x0075, 0x0309};
	private final static int gcPre_1EE8[] = {0x01AF, 0x0301};
	private final static int gcPre_1EE9[] = {0x01B0, 0x0301};
	private final static int gcPre_1EEA[] = {0x01AF, 0x0300};
	private final static int gcPre_1EEB[] = {0x01B0, 0x0300};
	private final static int gcPre_1EEC[] = {0x01AF, 0x0309};
	private final static int gcPre_1EED[] = {0x01B0, 0x0309};
	private final static int gcPre_1EEE[] = {0x01AF, 0x0303};
	private final static int gcPre_1EEF[] = {0x01B0, 0x0303};
	private final static int gcPre_1EF0[] = {0x01AF, 0x0323};
	private final static int gcPre_1EF1[] = {0x01B0, 0x0323};
	private final static int gcPre_1EF2[] = {0x0059, 0x0300};
	private final static int gcPre_1EF3[] = {0x0079, 0x0300};
	private final static int gcPre_1EF4[] = {0x0059, 0x0323};
	private final static int gcPre_1EF5[] = {0x0079, 0x0323};
	private final static int gcPre_1EF6[] = {0x0059, 0x0309};
	private final static int gcPre_1EF7[] = {0x0079, 0x0309};
	private final static int gcPre_1EF8[] = {0x0059, 0x0303};
	private final static int gcPre_1EF9[] = {0x0079, 0x0303};
	private final static int gcPre_1F00[] = {0x03B1, 0x0313};
	private final static int gcPre_1F01[] = {0x03B1, 0x0314};
	private final static int gcPre_1F02[] = {0x1F00, 0x0300};
	private final static int gcPre_1F03[] = {0x1F01, 0x0300};
	private final static int gcPre_1F04[] = {0x1F00, 0x0301};
	private final static int gcPre_1F05[] = {0x1F01, 0x0301};
	private final static int gcPre_1F06[] = {0x1F00, 0x0342};
	private final static int gcPre_1F07[] = {0x1F01, 0x0342};
	private final static int gcPre_1F08[] = {0x0391, 0x0313};
	private final static int gcPre_1F09[] = {0x0391, 0x0314};
	private final static int gcPre_1F0A[] = {0x1F08, 0x0300};
	private final static int gcPre_1F0B[] = {0x1F09, 0x0300};
	private final static int gcPre_1F0C[] = {0x1F08, 0x0301};
	private final static int gcPre_1F0D[] = {0x1F09, 0x0301};
	private final static int gcPre_1F0E[] = {0x1F08, 0x0342};
	private final static int gcPre_1F0F[] = {0x1F09, 0x0342};
	private final static int gcPre_1F10[] = {0x03B5, 0x0313};
	private final static int gcPre_1F11[] = {0x03B5, 0x0314};
	private final static int gcPre_1F12[] = {0x1F10, 0x0300};
	private final static int gcPre_1F13[] = {0x1F11, 0x0300};
	private final static int gcPre_1F14[] = {0x1F10, 0x0301};
	private final static int gcPre_1F15[] = {0x1F11, 0x0301};
	private final static int gcPre_1F18[] = {0x0395, 0x0313};
	private final static int gcPre_1F19[] = {0x0395, 0x0314};
	private final static int gcPre_1F1A[] = {0x1F18, 0x0300};
	private final static int gcPre_1F1B[] = {0x1F19, 0x0300};
	private final static int gcPre_1F1C[] = {0x1F18, 0x0301};
	private final static int gcPre_1F1D[] = {0x1F19, 0x0301};
	private final static int gcPre_1F20[] = {0x03B7, 0x0313};
	private final static int gcPre_1F21[] = {0x03B7, 0x0314};
	private final static int gcPre_1F22[] = {0x1F20, 0x0300};
	private final static int gcPre_1F23[] = {0x1F21, 0x0300};
	private final static int gcPre_1F24[] = {0x1F20, 0x0301};
	private final static int gcPre_1F25[] = {0x1F21, 0x0301};
	private final static int gcPre_1F26[] = {0x1F20, 0x0342};
	private final static int gcPre_1F27[] = {0x1F21, 0x0342};
	private final static int gcPre_1F28[] = {0x0397, 0x0313};
	private final static int gcPre_1F29[] = {0x0397, 0x0314};
	private final static int gcPre_1F2A[] = {0x1F28, 0x0300};
	private final static int gcPre_1F2B[] = {0x1F29, 0x0300};
	private final static int gcPre_1F2C[] = {0x1F28, 0x0301};
	private final static int gcPre_1F2D[] = {0x1F29, 0x0301};
	private final static int gcPre_1F2E[] = {0x1F28, 0x0342};
	private final static int gcPre_1F2F[] = {0x1F29, 0x0342};
	private final static int gcPre_1F30[] = {0x03B9, 0x0313};
	private final static int gcPre_1F31[] = {0x03B9, 0x0314};
	private final static int gcPre_1F32[] = {0x1F30, 0x0300};
	private final static int gcPre_1F33[] = {0x1F31, 0x0300};
	private final static int gcPre_1F34[] = {0x1F30, 0x0301};
	private final static int gcPre_1F35[] = {0x1F31, 0x0301};
	private final static int gcPre_1F36[] = {0x1F30, 0x0342};
	private final static int gcPre_1F37[] = {0x1F31, 0x0342};
	private final static int gcPre_1F38[] = {0x0399, 0x0313};
	private final static int gcPre_1F39[] = {0x0399, 0x0314};
	private final static int gcPre_1F3A[] = {0x1F38, 0x0300};
	private final static int gcPre_1F3B[] = {0x1F39, 0x0300};
	private final static int gcPre_1F3C[] = {0x1F38, 0x0301};
	private final static int gcPre_1F3D[] = {0x1F39, 0x0301};
	private final static int gcPre_1F3E[] = {0x1F38, 0x0342};
	private final static int gcPre_1F3F[] = {0x1F39, 0x0342};
	private final static int gcPre_1F40[] = {0x03BF, 0x0313};
	private final static int gcPre_1F41[] = {0x03BF, 0x0314};
	private final static int gcPre_1F42[] = {0x1F40, 0x0300};
	private final static int gcPre_1F43[] = {0x1F41, 0x0300};
	private final static int gcPre_1F44[] = {0x1F40, 0x0301};
	private final static int gcPre_1F45[] = {0x1F41, 0x0301};
	private final static int gcPre_1F48[] = {0x039F, 0x0313};
	private final static int gcPre_1F49[] = {0x039F, 0x0314};
	private final static int gcPre_1F4A[] = {0x1F48, 0x0300};
	private final static int gcPre_1F4B[] = {0x1F49, 0x0300};
	private final static int gcPre_1F4C[] = {0x1F48, 0x0301};
	private final static int gcPre_1F4D[] = {0x1F49, 0x0301};
	private final static int gcPre_1F50[] = {0x03C5, 0x0313};
	private final static int gcPre_1F51[] = {0x03C5, 0x0314};
	private final static int gcPre_1F52[] = {0x1F50, 0x0300};
	private final static int gcPre_1F53[] = {0x1F51, 0x0300};
	private final static int gcPre_1F54[] = {0x1F50, 0x0301};
	private final static int gcPre_1F55[] = {0x1F51, 0x0301};
	private final static int gcPre_1F56[] = {0x1F50, 0x0342};
	private final static int gcPre_1F57[] = {0x1F51, 0x0342};
	private final static int gcPre_1F59[] = {0x03A5, 0x0314};
	private final static int gcPre_1F5B[] = {0x1F59, 0x0300};
	private final static int gcPre_1F5D[] = {0x1F59, 0x0301};
	private final static int gcPre_1F5F[] = {0x1F59, 0x0342};
	private final static int gcPre_1F60[] = {0x03C9, 0x0313};
	private final static int gcPre_1F61[] = {0x03C9, 0x0314};
	private final static int gcPre_1F62[] = {0x1F60, 0x0300};
	private final static int gcPre_1F63[] = {0x1F61, 0x0300};
	private final static int gcPre_1F64[] = {0x1F60, 0x0301};
	private final static int gcPre_1F65[] = {0x1F61, 0x0301};
	private final static int gcPre_1F66[] = {0x1F60, 0x0342};
	private final static int gcPre_1F67[] = {0x1F61, 0x0342};
	private final static int gcPre_1F68[] = {0x03A9, 0x0313};
	private final static int gcPre_1F69[] = {0x03A9, 0x0314};
	private final static int gcPre_1F6A[] = {0x1F68, 0x0300};
	private final static int gcPre_1F6B[] = {0x1F69, 0x0300};
	private final static int gcPre_1F6C[] = {0x1F68, 0x0301};
	private final static int gcPre_1F6D[] = {0x1F69, 0x0301};
	private final static int gcPre_1F6E[] = {0x1F68, 0x0342};
	private final static int gcPre_1F6F[] = {0x1F69, 0x0342};
	private final static int gcPre_1F70[] = {0x03B1, 0x0300};
	private final static int gcPre_1F72[] = {0x03B5, 0x0300};
	private final static int gcPre_1F74[] = {0x03B7, 0x0300};
	private final static int gcPre_1F76[] = {0x03B9, 0x0300};
	private final static int gcPre_1F78[] = {0x03BF, 0x0300};
	private final static int gcPre_1F7A[] = {0x03C5, 0x0300};
	private final static int gcPre_1F7C[] = {0x03C9, 0x0300};
	private final static int gcPre_1F80[] = {0x1F00, 0x0345};
	private final static int gcPre_1F81[] = {0x1F01, 0x0345};
	private final static int gcPre_1F82[] = {0x1F02, 0x0345};
	private final static int gcPre_1F83[] = {0x1F03, 0x0345};
	private final static int gcPre_1F84[] = {0x1F04, 0x0345};
	private final static int gcPre_1F85[] = {0x1F05, 0x0345};
	private final static int gcPre_1F86[] = {0x1F06, 0x0345};
	private final static int gcPre_1F87[] = {0x1F07, 0x0345};
	private final static int gcPre_1F88[] = {0x1F08, 0x0345};
	private final static int gcPre_1F89[] = {0x1F09, 0x0345};
	private final static int gcPre_1F8A[] = {0x1F0A, 0x0345};
	private final static int gcPre_1F8B[] = {0x1F0B, 0x0345};
	private final static int gcPre_1F8C[] = {0x1F0C, 0x0345};
	private final static int gcPre_1F8D[] = {0x1F0D, 0x0345};
	private final static int gcPre_1F8E[] = {0x1F0E, 0x0345};
	private final static int gcPre_1F8F[] = {0x1F0F, 0x0345};
	private final static int gcPre_1F90[] = {0x1F20, 0x0345};
	private final static int gcPre_1F91[] = {0x1F21, 0x0345};
	private final static int gcPre_1F92[] = {0x1F22, 0x0345};
	private final static int gcPre_1F93[] = {0x1F23, 0x0345};
	private final static int gcPre_1F94[] = {0x1F24, 0x0345};
	private final static int gcPre_1F95[] = {0x1F25, 0x0345};
	private final static int gcPre_1F96[] = {0x1F26, 0x0345};
	private final static int gcPre_1F97[] = {0x1F27, 0x0345};
	private final static int gcPre_1F98[] = {0x1F28, 0x0345};
	private final static int gcPre_1F99[] = {0x1F29, 0x0345};
	private final static int gcPre_1F9A[] = {0x1F2A, 0x0345};
	private final static int gcPre_1F9B[] = {0x1F2B, 0x0345};
	private final static int gcPre_1F9C[] = {0x1F2C, 0x0345};
	private final static int gcPre_1F9D[] = {0x1F2D, 0x0345};
	private final static int gcPre_1F9E[] = {0x1F2E, 0x0345};
	private final static int gcPre_1F9F[] = {0x1F2F, 0x0345};
	private final static int gcPre_1FA0[] = {0x1F60, 0x0345};
	private final static int gcPre_1FA1[] = {0x1F61, 0x0345};
	private final static int gcPre_1FA2[] = {0x1F62, 0x0345};
	private final static int gcPre_1FA3[] = {0x1F63, 0x0345};
	private final static int gcPre_1FA4[] = {0x1F64, 0x0345};
	private final static int gcPre_1FA5[] = {0x1F65, 0x0345};
	private final static int gcPre_1FA6[] = {0x1F66, 0x0345};
	private final static int gcPre_1FA7[] = {0x1F67, 0x0345};
	private final static int gcPre_1FA8[] = {0x1F68, 0x0345};
	private final static int gcPre_1FA9[] = {0x1F69, 0x0345};
	private final static int gcPre_1FAA[] = {0x1F6A, 0x0345};
	private final static int gcPre_1FAB[] = {0x1F6B, 0x0345};
	private final static int gcPre_1FAC[] = {0x1F6C, 0x0345};
	private final static int gcPre_1FAD[] = {0x1F6D, 0x0345};
	private final static int gcPre_1FAE[] = {0x1F6E, 0x0345};
	private final static int gcPre_1FAF[] = {0x1F6F, 0x0345};
	private final static int gcPre_1FB0[] = {0x03B1, 0x0306};
	private final static int gcPre_1FB1[] = {0x03B1, 0x0304};
	private final static int gcPre_1FB2[] = {0x1F70, 0x0345};
	private final static int gcPre_1FB3[] = {0x03B1, 0x0345};
	private final static int gcPre_1FB4[] = {0x03AC, 0x0345};
	private final static int gcPre_1FB6[] = {0x03B1, 0x0342};
	private final static int gcPre_1FB7[] = {0x1FB6, 0x0345};
	private final static int gcPre_1FB8[] = {0x0391, 0x0306};
	private final static int gcPre_1FB9[] = {0x0391, 0x0304};
	private final static int gcPre_1FBA[] = {0x0391, 0x0300};
	private final static int gcPre_1FBC[] = {0x0391, 0x0345};
	private final static int gcPre_1FC1[] = {0x00A8, 0x0342};
	private final static int gcPre_1FC2[] = {0x1F74, 0x0345};
	private final static int gcPre_1FC3[] = {0x03B7, 0x0345};
	private final static int gcPre_1FC4[] = {0x03AE, 0x0345};
	private final static int gcPre_1FC6[] = {0x03B7, 0x0342};
	private final static int gcPre_1FC7[] = {0x1FC6, 0x0345};
	private final static int gcPre_1FC8[] = {0x0395, 0x0300};
	private final static int gcPre_1FCA[] = {0x0397, 0x0300};
	private final static int gcPre_1FCC[] = {0x0397, 0x0345};
	private final static int gcPre_1FCD[] = {0x1FBF, 0x0300};
	private final static int gcPre_1FCE[] = {0x1FBF, 0x0301};
	private final static int gcPre_1FCF[] = {0x1FBF, 0x0342};
	private final static int gcPre_1FD0[] = {0x03B9, 0x0306};
	private final static int gcPre_1FD1[] = {0x03B9, 0x0304};
	private final static int gcPre_1FD2[] = {0x03CA, 0x0300};
	private final static int gcPre_1FD6[] = {0x03B9, 0x0342};
	private final static int gcPre_1FD7[] = {0x03CA, 0x0342};
	private final static int gcPre_1FD8[] = {0x0399, 0x0306};
	private final static int gcPre_1FD9[] = {0x0399, 0x0304};
	private final static int gcPre_1FDA[] = {0x0399, 0x0300};
	private final static int gcPre_1FDD[] = {0x1FFE, 0x0300};
	private final static int gcPre_1FDE[] = {0x1FFE, 0x0301};
	private final static int gcPre_1FDF[] = {0x1FFE, 0x0342};
	private final static int gcPre_1FE0[] = {0x03C5, 0x0306};
	private final static int gcPre_1FE1[] = {0x03C5, 0x0304};
	private final static int gcPre_1FE2[] = {0x03CB, 0x0300};
	private final static int gcPre_1FE4[] = {0x03C1, 0x0313};
	private final static int gcPre_1FE5[] = {0x03C1, 0x0314};
	private final static int gcPre_1FE6[] = {0x03C5, 0x0342};
	private final static int gcPre_1FE7[] = {0x03CB, 0x0342};
	private final static int gcPre_1FE8[] = {0x03A5, 0x0306};
	private final static int gcPre_1FE9[] = {0x03A5, 0x0304};
	private final static int gcPre_1FEA[] = {0x03A5, 0x0300};
	private final static int gcPre_1FEC[] = {0x03A1, 0x0314};
	private final static int gcPre_1FED[] = {0x00A8, 0x0300};
	private final static int gcPre_1FF2[] = {0x1F7C, 0x0345};
	private final static int gcPre_1FF3[] = {0x03C9, 0x0345};
	private final static int gcPre_1FF4[] = {0x03CE, 0x0345};
	private final static int gcPre_1FF6[] = {0x03C9, 0x0342};
	private final static int gcPre_1FF7[] = {0x1FF6, 0x0345};
	private final static int gcPre_1FF8[] = {0x039F, 0x0300};
	private final static int gcPre_1FFA[] = {0x03A9, 0x0300};
	private final static int gcPre_1FFC[] = {0x03A9, 0x0345};
	private final static int gcPre_219A[] = {0x2190, 0x0338};
	private final static int gcPre_219B[] = {0x2192, 0x0338};
	private final static int gcPre_21AE[] = {0x2194, 0x0338};
	private final static int gcPre_21CD[] = {0x21D0, 0x0338};
	private final static int gcPre_21CE[] = {0x21D4, 0x0338};
	private final static int gcPre_21CF[] = {0x21D2, 0x0338};
	private final static int gcPre_2204[] = {0x2203, 0x0338};
	private final static int gcPre_2209[] = {0x2208, 0x0338};
	private final static int gcPre_220C[] = {0x220B, 0x0338};
	private final static int gcPre_2224[] = {0x2223, 0x0338};
	private final static int gcPre_2226[] = {0x2225, 0x0338};
	private final static int gcPre_2241[] = {0x223C, 0x0338};
	private final static int gcPre_2244[] = {0x2243, 0x0338};
	private final static int gcPre_2247[] = {0x2245, 0x0338};
	private final static int gcPre_2249[] = {0x2248, 0x0338};
	private final static int gcPre_2260[] = {0x003D, 0x0338};
	private final static int gcPre_2262[] = {0x2261, 0x0338};
	private final static int gcPre_226D[] = {0x224D, 0x0338};
	private final static int gcPre_226E[] = {0x003C, 0x0338};
	private final static int gcPre_226F[] = {0x003E, 0x0338};
	private final static int gcPre_2270[] = {0x2264, 0x0338};
	private final static int gcPre_2271[] = {0x2265, 0x0338};
	private final static int gcPre_2274[] = {0x2272, 0x0338};
	private final static int gcPre_2275[] = {0x2273, 0x0338};
	private final static int gcPre_2278[] = {0x2276, 0x0338};
	private final static int gcPre_2279[] = {0x2277, 0x0338};
	private final static int gcPre_2280[] = {0x227A, 0x0338};
	private final static int gcPre_2281[] = {0x227B, 0x0338};
	private final static int gcPre_2284[] = {0x2282, 0x0338};
	private final static int gcPre_2285[] = {0x2283, 0x0338};
	private final static int gcPre_2288[] = {0x2286, 0x0338};
	private final static int gcPre_2289[] = {0x2287, 0x0338};
	private final static int gcPre_22AC[] = {0x22A2, 0x0338};
	private final static int gcPre_22AD[] = {0x22A8, 0x0338};
	private final static int gcPre_22AE[] = {0x22A9, 0x0338};
	private final static int gcPre_22AF[] = {0x22AB, 0x0338};
	private final static int gcPre_22E0[] = {0x227C, 0x0338};
	private final static int gcPre_22E1[] = {0x227D, 0x0338};
	private final static int gcPre_22E2[] = {0x2291, 0x0338};
	private final static int gcPre_22E3[] = {0x2292, 0x0338};
	private final static int gcPre_22EA[] = {0x22B2, 0x0338};
	private final static int gcPre_22EB[] = {0x22B3, 0x0338};
	private final static int gcPre_22EC[] = {0x22B4, 0x0338};
	private final static int gcPre_22ED[] = {0x22B5, 0x0338};
	private final static int gcPre_2ADC[] = {0x2ADD, 0x0338};
	private final static int gcPre_304C[] = {0x304B, 0x3099};
	private final static int gcPre_304E[] = {0x304D, 0x3099};
	private final static int gcPre_3050[] = {0x304F, 0x3099};
	private final static int gcPre_3052[] = {0x3051, 0x3099};
	private final static int gcPre_3054[] = {0x3053, 0x3099};
	private final static int gcPre_3056[] = {0x3055, 0x3099};
	private final static int gcPre_3058[] = {0x3057, 0x3099};
	private final static int gcPre_305A[] = {0x3059, 0x3099};
	private final static int gcPre_305C[] = {0x305B, 0x3099};
	private final static int gcPre_305E[] = {0x305D, 0x3099};
	private final static int gcPre_3060[] = {0x305F, 0x3099};
	private final static int gcPre_3062[] = {0x3061, 0x3099};
	private final static int gcPre_3065[] = {0x3064, 0x3099};
	private final static int gcPre_3067[] = {0x3066, 0x3099};
	private final static int gcPre_3069[] = {0x3068, 0x3099};
	private final static int gcPre_3070[] = {0x306F, 0x3099};
	private final static int gcPre_3071[] = {0x306F, 0x309A};
	private final static int gcPre_3073[] = {0x3072, 0x3099};
	private final static int gcPre_3074[] = {0x3072, 0x309A};
	private final static int gcPre_3076[] = {0x3075, 0x3099};
	private final static int gcPre_3077[] = {0x3075, 0x309A};
	private final static int gcPre_3079[] = {0x3078, 0x3099};
	private final static int gcPre_307A[] = {0x3078, 0x309A};
	private final static int gcPre_307C[] = {0x307B, 0x3099};
	private final static int gcPre_307D[] = {0x307B, 0x309A};
	private final static int gcPre_3094[] = {0x3046, 0x3099};
	private final static int gcPre_309E[] = {0x309D, 0x3099};
	private final static int gcPre_30AC[] = {0x30AB, 0x3099};
	private final static int gcPre_30AE[] = {0x30AD, 0x3099};
	private final static int gcPre_30B0[] = {0x30AF, 0x3099};
	private final static int gcPre_30B2[] = {0x30B1, 0x3099};
	private final static int gcPre_30B4[] = {0x30B3, 0x3099};
	private final static int gcPre_30B6[] = {0x30B5, 0x3099};
	private final static int gcPre_30B8[] = {0x30B7, 0x3099};
	private final static int gcPre_30BA[] = {0x30B9, 0x3099};
	private final static int gcPre_30BC[] = {0x30BB, 0x3099};
	private final static int gcPre_30BE[] = {0x30BD, 0x3099};
	private final static int gcPre_30C0[] = {0x30BF, 0x3099};
	private final static int gcPre_30C2[] = {0x30C1, 0x3099};
	private final static int gcPre_30C5[] = {0x30C4, 0x3099};
	private final static int gcPre_30C7[] = {0x30C6, 0x3099};
	private final static int gcPre_30C9[] = {0x30C8, 0x3099};
	private final static int gcPre_30D0[] = {0x30CF, 0x3099};
	private final static int gcPre_30D1[] = {0x30CF, 0x309A};
	private final static int gcPre_30D3[] = {0x30D2, 0x3099};
	private final static int gcPre_30D4[] = {0x30D2, 0x309A};
	private final static int gcPre_30D6[] = {0x30D5, 0x3099};
	private final static int gcPre_30D7[] = {0x30D5, 0x309A};
	private final static int gcPre_30D9[] = {0x30D8, 0x3099};
	private final static int gcPre_30DA[] = {0x30D8, 0x309A};
	private final static int gcPre_30DC[] = {0x30DB, 0x3099};
	private final static int gcPre_30DD[] = {0x30DB, 0x309A};
	private final static int gcPre_30F4[] = {0x30A6, 0x3099};
	private final static int gcPre_30F7[] = {0x30EF, 0x3099};
	private final static int gcPre_30F8[] = {0x30F0, 0x3099};
	private final static int gcPre_30F9[] = {0x30F1, 0x3099};
	private final static int gcPre_30FA[] = {0x30F2, 0x3099};
	private final static int gcPre_30FE[] = {0x30FD, 0x3099};
	private final static int gcPre_FB1D[] = {0x05D9, 0x05B4};
	private final static int gcPre_FB1F[] = {0x05F2, 0x05B7};
	private final static int gcPre_FB2A[] = {0x05E9, 0x05C1};
	private final static int gcPre_FB2B[] = {0x05E9, 0x05C2};
	private final static int gcPre_FB2C[] = {0xFB49, 0x05C1};
	private final static int gcPre_FB2D[] = {0xFB49, 0x05C2};
	private final static int gcPre_FB2E[] = {0x05D0, 0x05B7};
	private final static int gcPre_FB2F[] = {0x05D0, 0x05B8};
	private final static int gcPre_FB30[] = {0x05D0, 0x05BC};
	private final static int gcPre_FB31[] = {0x05D1, 0x05BC};
	private final static int gcPre_FB32[] = {0x05D2, 0x05BC};
	private final static int gcPre_FB33[] = {0x05D3, 0x05BC};
	private final static int gcPre_FB34[] = {0x05D4, 0x05BC};
	private final static int gcPre_FB35[] = {0x05D5, 0x05BC};
	private final static int gcPre_FB36[] = {0x05D6, 0x05BC};
	private final static int gcPre_FB38[] = {0x05D8, 0x05BC};
	private final static int gcPre_FB39[] = {0x05D9, 0x05BC};
	private final static int gcPre_FB3A[] = {0x05DA, 0x05BC};
	private final static int gcPre_FB3B[] = {0x05DB, 0x05BC};
	private final static int gcPre_FB3C[] = {0x05DC, 0x05BC};
	private final static int gcPre_FB3E[] = {0x05DE, 0x05BC};
	private final static int gcPre_FB40[] = {0x05E0, 0x05BC};
	private final static int gcPre_FB41[] = {0x05E1, 0x05BC};
	private final static int gcPre_FB43[] = {0x05E3, 0x05BC};
	private final static int gcPre_FB44[] = {0x05E4, 0x05BC};
	private final static int gcPre_FB46[] = {0x05E6, 0x05BC};
	private final static int gcPre_FB47[] = {0x05E7, 0x05BC};
	private final static int gcPre_FB48[] = {0x05E8, 0x05BC};
	private final static int gcPre_FB49[] = {0x05E9, 0x05BC};
	private final static int gcPre_FB4A[] = {0x05EA, 0x05BC};
	private final static int gcPre_FB4B[] = {0x05D5, 0x05B9};
	private final static int gcPre_FB4C[] = {0x05D1, 0x05BF};
	private final static int gcPre_FB4D[] = {0x05DB, 0x05BF};
	private final static int gcPre_FB4E[] = {0x05E4, 0x05BF};
	private final static int gcPre_FC5B[] = {0x0630, 0x0670};
	private final static int gcPre_FC5C[] = {0x0631, 0x0670};
	private final static int gcPre_FC5D[] = {0x0649, 0x0670};
	private final static int gcPre_FC90[] = {0x0649, 0x0670};
	private final static int gcPre_FCD9[] = {0x0647, 0x0670};
	private final static int gcPre_FCF2[] = {0x0640, 0x064E, 0x0651};
	private final static int gcPre_FCF3[] = {0x0640, 0x064F, 0x0651};
	private final static int gcPre_FCF4[] = {0x0640, 0x0650, 0x0651};
	private final static int gcPre_FD3C[] = {0x0627, 0x064B};
	private final static int gcPre_FD3D[] = {0x0627, 0x064B};
	private final static int gcPre_FE71[] = {0x0640, 0x064B};
	private final static int gcPre_FE77[] = {0x0640, 0x064E};
	private final static int gcPre_FE79[] = {0x0640, 0x064F};
	private final static int gcPre_FE7B[] = {0x0640, 0x0650};
	private final static int gcPre_FE7D[] = {0x0640, 0x0651};
	private final static int gcPre_FE7F[] = {0x0640, 0x0652};
	private final static int gcPre_1D15E[] = {0x1D157, 0x1D165};
	private final static int gcPre_1D15F[] = {0x1D158, 0x1D165};
	private final static int gcPre_1D160[] = {0x1D15F, 0x1D16E};
	private final static int gcPre_1D161[] = {0x1D15F, 0x1D16F};
	private final static int gcPre_1D162[] = {0x1D15F, 0x1D170};
	private final static int gcPre_1D163[] = {0x1D15F, 0x1D171};
	private final static int gcPre_1D164[] = {0x1D15F, 0x1D172};
	private final static int gcPre_1D1BB[] = {0x1D1B9, 0x1D165};
	private final static int gcPre_1D1BC[] = {0x1D1BA, 0x1D165};
	private final static int gcPre_1D1BD[] = {0x1D1BB, 0x1D16E};
	private final static int gcPre_1D1BE[] = {0x1D1BC, 0x1D16E};
	private final static int gcPre_1D1BF[] = {0x1D1BB, 0x1D16F};
	private final static int gcPre_1D1C0[] = {0x1D1BC, 0x1D16F};

	private final static CompositionData goCompositionData[] = {
		new CompositionData (0x226E, COMPOSE_OFF, gcPre_226E),
		new CompositionData (0x2260, COMPOSE_OFF, gcPre_2260),
		new CompositionData (0x226F, COMPOSE_OFF, gcPre_226F),
		new CompositionData (0x00C0, COMPOSE_OFF, gcPre_00C0),
		new CompositionData (0x00C1, COMPOSE_OFF, gcPre_00C1),
		new CompositionData (0x00C2, COMPOSE_OFF, gcPre_00C2),
		new CompositionData (0x00C3, COMPOSE_OFF, gcPre_00C3),
		new CompositionData (0x0100, COMPOSE_OFF, gcPre_0100),
		new CompositionData (0x0102, COMPOSE_OFF, gcPre_0102),
		new CompositionData (0x0226, COMPOSE_OFF, gcPre_0226),
		new CompositionData (0x00C4, COMPOSE_OFF, gcPre_00C4),
		new CompositionData (0x1EA2, COMPOSE_OFF, gcPre_1EA2),
		new CompositionData (0x00C5, COMPOSE_OFF, gcPre_00C5),
		new CompositionData (0x01CD, COMPOSE_OFF, gcPre_01CD),
		new CompositionData (0x0200, COMPOSE_OFF, gcPre_0200),
		new CompositionData (0x0202, COMPOSE_OFF, gcPre_0202),
		new CompositionData (0x1EA0, COMPOSE_OFF, gcPre_1EA0),
		new CompositionData (0x1E00, COMPOSE_OFF, gcPre_1E00),
		new CompositionData (0x0104, COMPOSE_OFF, gcPre_0104),
		new CompositionData (0x1E02, COMPOSE_OFF, gcPre_1E02),
		new CompositionData (0x1E04, COMPOSE_OFF, gcPre_1E04),
		new CompositionData (0x1E06, COMPOSE_OFF, gcPre_1E06),
		new CompositionData (0x0106, COMPOSE_OFF, gcPre_0106),
		new CompositionData (0x0108, COMPOSE_OFF, gcPre_0108),
		new CompositionData (0x010A, COMPOSE_OFF, gcPre_010A),
		new CompositionData (0x010C, COMPOSE_OFF, gcPre_010C),
		new CompositionData (0x00C7, COMPOSE_OFF, gcPre_00C7),
		new CompositionData (0x1E0A, COMPOSE_OFF, gcPre_1E0A),
		new CompositionData (0x010E, COMPOSE_OFF, gcPre_010E),
		new CompositionData (0x1E0C, COMPOSE_OFF, gcPre_1E0C),
		new CompositionData (0x1E10, COMPOSE_OFF, gcPre_1E10),
		new CompositionData (0x1E12, COMPOSE_OFF, gcPre_1E12),
		new CompositionData (0x1E0E, COMPOSE_OFF, gcPre_1E0E),
		new CompositionData (0x00C8, COMPOSE_OFF, gcPre_00C8),
		new CompositionData (0x00C9, COMPOSE_OFF, gcPre_00C9),
		new CompositionData (0x00CA, COMPOSE_OFF, gcPre_00CA),
		new CompositionData (0x1EBC, COMPOSE_OFF, gcPre_1EBC),
		new CompositionData (0x0112, COMPOSE_OFF, gcPre_0112),
		new CompositionData (0x0114, COMPOSE_OFF, gcPre_0114),
		new CompositionData (0x0116, COMPOSE_OFF, gcPre_0116),
		new CompositionData (0x00CB, COMPOSE_OFF, gcPre_00CB),
		new CompositionData (0x1EBA, COMPOSE_OFF, gcPre_1EBA),
		new CompositionData (0x011A, COMPOSE_OFF, gcPre_011A),
		new CompositionData (0x0204, COMPOSE_OFF, gcPre_0204),
		new CompositionData (0x0206, COMPOSE_OFF, gcPre_0206),
		new CompositionData (0x1EB8, COMPOSE_OFF, gcPre_1EB8),
		new CompositionData (0x0228, COMPOSE_OFF, gcPre_0228),
		new CompositionData (0x0118, COMPOSE_OFF, gcPre_0118),
		new CompositionData (0x1E18, COMPOSE_OFF, gcPre_1E18),
		new CompositionData (0x1E1A, COMPOSE_OFF, gcPre_1E1A),
		new CompositionData (0x1E1E, COMPOSE_OFF, gcPre_1E1E),
		new CompositionData (0x01F4, COMPOSE_OFF, gcPre_01F4),
		new CompositionData (0x011C, COMPOSE_OFF, gcPre_011C),
		new CompositionData (0x1E20, COMPOSE_OFF, gcPre_1E20),
		new CompositionData (0x011E, COMPOSE_OFF, gcPre_011E),
		new CompositionData (0x0120, COMPOSE_OFF, gcPre_0120),
		new CompositionData (0x01E6, COMPOSE_OFF, gcPre_01E6),
		new CompositionData (0x0122, COMPOSE_OFF, gcPre_0122),
		new CompositionData (0x0124, COMPOSE_OFF, gcPre_0124),
		new CompositionData (0x1E22, COMPOSE_OFF, gcPre_1E22),
		new CompositionData (0x1E26, COMPOSE_OFF, gcPre_1E26),
		new CompositionData (0x021E, COMPOSE_OFF, gcPre_021E),
		new CompositionData (0x1E24, COMPOSE_OFF, gcPre_1E24),
		new CompositionData (0x1E28, COMPOSE_OFF, gcPre_1E28),
		new CompositionData (0x1E2A, COMPOSE_OFF, gcPre_1E2A),
		new CompositionData (0x00CC, COMPOSE_OFF, gcPre_00CC),
		new CompositionData (0x00CD, COMPOSE_OFF, gcPre_00CD),
		new CompositionData (0x00CE, COMPOSE_OFF, gcPre_00CE),
		new CompositionData (0x0128, COMPOSE_OFF, gcPre_0128),
		new CompositionData (0x012A, COMPOSE_OFF, gcPre_012A),
		new CompositionData (0x012C, COMPOSE_OFF, gcPre_012C),
		new CompositionData (0x0130, COMPOSE_OFF, gcPre_0130),
		new CompositionData (0x00CF, COMPOSE_OFF, gcPre_00CF),
		new CompositionData (0x1EC8, COMPOSE_OFF, gcPre_1EC8),
		new CompositionData (0x01CF, COMPOSE_OFF, gcPre_01CF),
		new CompositionData (0x0208, COMPOSE_OFF, gcPre_0208),
		new CompositionData (0x020A, COMPOSE_OFF, gcPre_020A),
		new CompositionData (0x1ECA, COMPOSE_OFF, gcPre_1ECA),
		new CompositionData (0x012E, COMPOSE_OFF, gcPre_012E),
		new CompositionData (0x1E2C, COMPOSE_OFF, gcPre_1E2C),
		new CompositionData (0x0134, COMPOSE_OFF, gcPre_0134),
		new CompositionData (0x1E30, COMPOSE_OFF, gcPre_1E30),
		new CompositionData (0x01E8, COMPOSE_OFF, gcPre_01E8),
		new CompositionData (0x1E32, COMPOSE_OFF, gcPre_1E32),
		new CompositionData (0x0136, COMPOSE_OFF, gcPre_0136),
		new CompositionData (0x1E34, COMPOSE_OFF, gcPre_1E34),
		new CompositionData (0x0139, COMPOSE_OFF, gcPre_0139),
		new CompositionData (0x013D, COMPOSE_OFF, gcPre_013D),
		new CompositionData (0x1E36, COMPOSE_OFF, gcPre_1E36),
		new CompositionData (0x013B, COMPOSE_OFF, gcPre_013B),
		new CompositionData (0x1E3C, COMPOSE_OFF, gcPre_1E3C),
		new CompositionData (0x1E3A, COMPOSE_OFF, gcPre_1E3A),
		new CompositionData (0x1E3E, COMPOSE_OFF, gcPre_1E3E),
		new CompositionData (0x1E40, COMPOSE_OFF, gcPre_1E40),
		new CompositionData (0x1E42, COMPOSE_OFF, gcPre_1E42),
		new CompositionData (0x01F8, COMPOSE_OFF, gcPre_01F8),
		new CompositionData (0x0143, COMPOSE_OFF, gcPre_0143),
		new CompositionData (0x00D1, COMPOSE_OFF, gcPre_00D1),
		new CompositionData (0x1E44, COMPOSE_OFF, gcPre_1E44),
		new CompositionData (0x0147, COMPOSE_OFF, gcPre_0147),
		new CompositionData (0x1E46, COMPOSE_OFF, gcPre_1E46),
		new CompositionData (0x0145, COMPOSE_OFF, gcPre_0145),
		new CompositionData (0x1E4A, COMPOSE_OFF, gcPre_1E4A),
		new CompositionData (0x1E48, COMPOSE_OFF, gcPre_1E48),
		new CompositionData (0x00D2, COMPOSE_OFF, gcPre_00D2),
		new CompositionData (0x00D3, COMPOSE_OFF, gcPre_00D3),
		new CompositionData (0x00D4, COMPOSE_OFF, gcPre_00D4),
		new CompositionData (0x00D5, COMPOSE_OFF, gcPre_00D5),
		new CompositionData (0x014C, COMPOSE_OFF, gcPre_014C),
		new CompositionData (0x014E, COMPOSE_OFF, gcPre_014E),
		new CompositionData (0x022E, COMPOSE_OFF, gcPre_022E),
		new CompositionData (0x00D6, COMPOSE_OFF, gcPre_00D6),
		new CompositionData (0x1ECE, COMPOSE_OFF, gcPre_1ECE),
		new CompositionData (0x0150, COMPOSE_OFF, gcPre_0150),
		new CompositionData (0x01D1, COMPOSE_OFF, gcPre_01D1),
		new CompositionData (0x020C, COMPOSE_OFF, gcPre_020C),
		new CompositionData (0x020E, COMPOSE_OFF, gcPre_020E),
		new CompositionData (0x01A0, COMPOSE_OFF, gcPre_01A0),
		new CompositionData (0x1ECC, COMPOSE_OFF, gcPre_1ECC),
		new CompositionData (0x01EA, COMPOSE_OFF, gcPre_01EA),
		new CompositionData (0x1E54, COMPOSE_OFF, gcPre_1E54),
		new CompositionData (0x1E56, COMPOSE_OFF, gcPre_1E56),
		new CompositionData (0x0154, COMPOSE_OFF, gcPre_0154),
		new CompositionData (0x1E58, COMPOSE_OFF, gcPre_1E58),
		new CompositionData (0x0158, COMPOSE_OFF, gcPre_0158),
		new CompositionData (0x0210, COMPOSE_OFF, gcPre_0210),
		new CompositionData (0x0212, COMPOSE_OFF, gcPre_0212),
		new CompositionData (0x1E5A, COMPOSE_OFF, gcPre_1E5A),
		new CompositionData (0x0156, COMPOSE_OFF, gcPre_0156),
		new CompositionData (0x1E5E, COMPOSE_OFF, gcPre_1E5E),
		new CompositionData (0x015A, COMPOSE_OFF, gcPre_015A),
		new CompositionData (0x015C, COMPOSE_OFF, gcPre_015C),
		new CompositionData (0x1E60, COMPOSE_OFF, gcPre_1E60),
		new CompositionData (0x0160, COMPOSE_OFF, gcPre_0160),
		new CompositionData (0x1E62, COMPOSE_OFF, gcPre_1E62),
		new CompositionData (0x0218, COMPOSE_OFF, gcPre_0218),
		new CompositionData (0x015E, COMPOSE_OFF, gcPre_015E),
		new CompositionData (0x1E6A, COMPOSE_OFF, gcPre_1E6A),
		new CompositionData (0x0164, COMPOSE_OFF, gcPre_0164),
		new CompositionData (0x1E6C, COMPOSE_OFF, gcPre_1E6C),
		new CompositionData (0x021A, COMPOSE_OFF, gcPre_021A),
		new CompositionData (0x0162, COMPOSE_OFF, gcPre_0162),
		new CompositionData (0x1E70, COMPOSE_OFF, gcPre_1E70),
		new CompositionData (0x1E6E, COMPOSE_OFF, gcPre_1E6E),
		new CompositionData (0x00D9, COMPOSE_OFF, gcPre_00D9),
		new CompositionData (0x00DA, COMPOSE_OFF, gcPre_00DA),
		new CompositionData (0x00DB, COMPOSE_OFF, gcPre_00DB),
		new CompositionData (0x0168, COMPOSE_OFF, gcPre_0168),
		new CompositionData (0x016A, COMPOSE_OFF, gcPre_016A),
		new CompositionData (0x016C, COMPOSE_OFF, gcPre_016C),
		new CompositionData (0x00DC, COMPOSE_OFF, gcPre_00DC),
		new CompositionData (0x1EE6, COMPOSE_OFF, gcPre_1EE6),
		new CompositionData (0x016E, COMPOSE_OFF, gcPre_016E),
		new CompositionData (0x0170, COMPOSE_OFF, gcPre_0170),
		new CompositionData (0x01D3, COMPOSE_OFF, gcPre_01D3),
		new CompositionData (0x0214, COMPOSE_OFF, gcPre_0214),
		new CompositionData (0x0216, COMPOSE_OFF, gcPre_0216),
		new CompositionData (0x01AF, COMPOSE_OFF, gcPre_01AF),
		new CompositionData (0x1EE4, COMPOSE_OFF, gcPre_1EE4),
		new CompositionData (0x1E72, COMPOSE_OFF, gcPre_1E72),
		new CompositionData (0x0172, COMPOSE_OFF, gcPre_0172),
		new CompositionData (0x1E76, COMPOSE_OFF, gcPre_1E76),
		new CompositionData (0x1E74, COMPOSE_OFF, gcPre_1E74),
		new CompositionData (0x1E7C, COMPOSE_OFF, gcPre_1E7C),
		new CompositionData (0x1E7E, COMPOSE_OFF, gcPre_1E7E),
		new CompositionData (0x1E80, COMPOSE_OFF, gcPre_1E80),
		new CompositionData (0x1E82, COMPOSE_OFF, gcPre_1E82),
		new CompositionData (0x0174, COMPOSE_OFF, gcPre_0174),
		new CompositionData (0x1E86, COMPOSE_OFF, gcPre_1E86),
		new CompositionData (0x1E84, COMPOSE_OFF, gcPre_1E84),
		new CompositionData (0x1E88, COMPOSE_OFF, gcPre_1E88),
		new CompositionData (0x1E8A, COMPOSE_OFF, gcPre_1E8A),
		new CompositionData (0x1E8C, COMPOSE_OFF, gcPre_1E8C),
		new CompositionData (0x1EF2, COMPOSE_OFF, gcPre_1EF2),
		new CompositionData (0x00DD, COMPOSE_OFF, gcPre_00DD),
		new CompositionData (0x0176, COMPOSE_OFF, gcPre_0176),
		new CompositionData (0x1EF8, COMPOSE_OFF, gcPre_1EF8),
		new CompositionData (0x0232, COMPOSE_OFF, gcPre_0232),
		new CompositionData (0x1E8E, COMPOSE_OFF, gcPre_1E8E),
		new CompositionData (0x0178, COMPOSE_OFF, gcPre_0178),
		new CompositionData (0x1EF6, COMPOSE_OFF, gcPre_1EF6),
		new CompositionData (0x1EF4, COMPOSE_OFF, gcPre_1EF4),
		new CompositionData (0x0179, COMPOSE_OFF, gcPre_0179),
		new CompositionData (0x1E90, COMPOSE_OFF, gcPre_1E90),
		new CompositionData (0x017B, COMPOSE_OFF, gcPre_017B),
		new CompositionData (0x017D, COMPOSE_OFF, gcPre_017D),
		new CompositionData (0x1E92, COMPOSE_OFF, gcPre_1E92),
		new CompositionData (0x1E94, COMPOSE_OFF, gcPre_1E94),
		new CompositionData (0x00E0, COMPOSE_OFF, gcPre_00E0),
		new CompositionData (0x00E1, COMPOSE_OFF, gcPre_00E1),
		new CompositionData (0x00E2, COMPOSE_OFF, gcPre_00E2),
		new CompositionData (0x00E3, COMPOSE_OFF, gcPre_00E3),
		new CompositionData (0x0101, COMPOSE_OFF, gcPre_0101),
		new CompositionData (0x0103, COMPOSE_OFF, gcPre_0103),
		new CompositionData (0x0227, COMPOSE_OFF, gcPre_0227),
		new CompositionData (0x00E4, COMPOSE_OFF, gcPre_00E4),
		new CompositionData (0x1EA3, COMPOSE_OFF, gcPre_1EA3),
		new CompositionData (0x00E5, COMPOSE_OFF, gcPre_00E5),
		new CompositionData (0x01CE, COMPOSE_OFF, gcPre_01CE),
		new CompositionData (0x0201, COMPOSE_OFF, gcPre_0201),
		new CompositionData (0x0203, COMPOSE_OFF, gcPre_0203),
		new CompositionData (0x1EA1, COMPOSE_OFF, gcPre_1EA1),
		new CompositionData (0x1E01, COMPOSE_OFF, gcPre_1E01),
		new CompositionData (0x0105, COMPOSE_OFF, gcPre_0105),
		new CompositionData (0x1E03, COMPOSE_OFF, gcPre_1E03),
		new CompositionData (0x1E05, COMPOSE_OFF, gcPre_1E05),
		new CompositionData (0x1E07, COMPOSE_OFF, gcPre_1E07),
		new CompositionData (0x0107, COMPOSE_OFF, gcPre_0107),
		new CompositionData (0x0109, COMPOSE_OFF, gcPre_0109),
		new CompositionData (0x010B, COMPOSE_OFF, gcPre_010B),
		new CompositionData (0x010D, COMPOSE_OFF, gcPre_010D),
		new CompositionData (0x00E7, COMPOSE_OFF, gcPre_00E7),
		new CompositionData (0x1E0B, COMPOSE_OFF, gcPre_1E0B),
		new CompositionData (0x010F, COMPOSE_OFF, gcPre_010F),
		new CompositionData (0x1E0D, COMPOSE_OFF, gcPre_1E0D),
		new CompositionData (0x1E11, COMPOSE_OFF, gcPre_1E11),
		new CompositionData (0x1E13, COMPOSE_OFF, gcPre_1E13),
		new CompositionData (0x1E0F, COMPOSE_OFF, gcPre_1E0F),
		new CompositionData (0x00E8, COMPOSE_OFF, gcPre_00E8),
		new CompositionData (0x00E9, COMPOSE_OFF, gcPre_00E9),
		new CompositionData (0x00EA, COMPOSE_OFF, gcPre_00EA),
		new CompositionData (0x1EBD, COMPOSE_OFF, gcPre_1EBD),
		new CompositionData (0x0113, COMPOSE_OFF, gcPre_0113),
		new CompositionData (0x0115, COMPOSE_OFF, gcPre_0115),
		new CompositionData (0x0117, COMPOSE_OFF, gcPre_0117),
		new CompositionData (0x00EB, COMPOSE_OFF, gcPre_00EB),
		new CompositionData (0x1EBB, COMPOSE_OFF, gcPre_1EBB),
		new CompositionData (0x011B, COMPOSE_OFF, gcPre_011B),
		new CompositionData (0x0205, COMPOSE_OFF, gcPre_0205),
		new CompositionData (0x0207, COMPOSE_OFF, gcPre_0207),
		new CompositionData (0x1EB9, COMPOSE_OFF, gcPre_1EB9),
		new CompositionData (0x0229, COMPOSE_OFF, gcPre_0229),
		new CompositionData (0x0119, COMPOSE_OFF, gcPre_0119),
		new CompositionData (0x1E19, COMPOSE_OFF, gcPre_1E19),
		new CompositionData (0x1E1B, COMPOSE_OFF, gcPre_1E1B),
		new CompositionData (0x1E1F, COMPOSE_OFF, gcPre_1E1F),
		new CompositionData (0x01F5, COMPOSE_OFF, gcPre_01F5),
		new CompositionData (0x011D, COMPOSE_OFF, gcPre_011D),
		new CompositionData (0x1E21, COMPOSE_OFF, gcPre_1E21),
		new CompositionData (0x011F, COMPOSE_OFF, gcPre_011F),
		new CompositionData (0x0121, COMPOSE_OFF, gcPre_0121),
		new CompositionData (0x01E7, COMPOSE_OFF, gcPre_01E7),
		new CompositionData (0x0123, COMPOSE_OFF, gcPre_0123),
		new CompositionData (0x0125, COMPOSE_OFF, gcPre_0125),
		new CompositionData (0x1E23, COMPOSE_OFF, gcPre_1E23),
		new CompositionData (0x1E27, COMPOSE_OFF, gcPre_1E27),
		new CompositionData (0x021F, COMPOSE_OFF, gcPre_021F),
		new CompositionData (0x1E25, COMPOSE_OFF, gcPre_1E25),
		new CompositionData (0x1E29, COMPOSE_OFF, gcPre_1E29),
		new CompositionData (0x1E2B, COMPOSE_OFF, gcPre_1E2B),
		new CompositionData (0x1E96, COMPOSE_OFF, gcPre_1E96),
		new CompositionData (0x00EC, COMPOSE_OFF, gcPre_00EC),
		new CompositionData (0x00ED, COMPOSE_OFF, gcPre_00ED),
		new CompositionData (0x00EE, COMPOSE_OFF, gcPre_00EE),
		new CompositionData (0x0129, COMPOSE_OFF, gcPre_0129),
		new CompositionData (0x012B, COMPOSE_OFF, gcPre_012B),
		new CompositionData (0x012D, COMPOSE_OFF, gcPre_012D),
		new CompositionData (0x00EF, COMPOSE_OFF, gcPre_00EF),
		new CompositionData (0x1EC9, COMPOSE_OFF, gcPre_1EC9),
		new CompositionData (0x01D0, COMPOSE_OFF, gcPre_01D0),
		new CompositionData (0x0209, COMPOSE_OFF, gcPre_0209),
		new CompositionData (0x020B, COMPOSE_OFF, gcPre_020B),
		new CompositionData (0x1ECB, COMPOSE_OFF, gcPre_1ECB),
		new CompositionData (0x012F, COMPOSE_OFF, gcPre_012F),
		new CompositionData (0x1E2D, COMPOSE_OFF, gcPre_1E2D),
		new CompositionData (0x0135, COMPOSE_OFF, gcPre_0135),
		new CompositionData (0x01F0, COMPOSE_OFF, gcPre_01F0),
		new CompositionData (0x1E31, COMPOSE_OFF, gcPre_1E31),
		new CompositionData (0x01E9, COMPOSE_OFF, gcPre_01E9),
		new CompositionData (0x1E33, COMPOSE_OFF, gcPre_1E33),
		new CompositionData (0x0137, COMPOSE_OFF, gcPre_0137),
		new CompositionData (0x1E35, COMPOSE_OFF, gcPre_1E35),
		new CompositionData (0x013A, COMPOSE_OFF, gcPre_013A),
		new CompositionData (0x013E, COMPOSE_OFF, gcPre_013E),
		new CompositionData (0x1E37, COMPOSE_OFF, gcPre_1E37),
		new CompositionData (0x013C, COMPOSE_OFF, gcPre_013C),
		new CompositionData (0x1E3D, COMPOSE_OFF, gcPre_1E3D),
		new CompositionData (0x1E3B, COMPOSE_OFF, gcPre_1E3B),
		new CompositionData (0x1E3F, COMPOSE_OFF, gcPre_1E3F),
		new CompositionData (0x1E41, COMPOSE_OFF, gcPre_1E41),
		new CompositionData (0x1E43, COMPOSE_OFF, gcPre_1E43),
		new CompositionData (0x01F9, COMPOSE_OFF, gcPre_01F9),
		new CompositionData (0x0144, COMPOSE_OFF, gcPre_0144),
		new CompositionData (0x00F1, COMPOSE_OFF, gcPre_00F1),
		new CompositionData (0x1E45, COMPOSE_OFF, gcPre_1E45),
		new CompositionData (0x0148, COMPOSE_OFF, gcPre_0148),
		new CompositionData (0x1E47, COMPOSE_OFF, gcPre_1E47),
		new CompositionData (0x0146, COMPOSE_OFF, gcPre_0146),
		new CompositionData (0x1E4B, COMPOSE_OFF, gcPre_1E4B),
		new CompositionData (0x1E49, COMPOSE_OFF, gcPre_1E49),
		new CompositionData (0x00F2, COMPOSE_OFF, gcPre_00F2),
		new CompositionData (0x00F3, COMPOSE_OFF, gcPre_00F3),
		new CompositionData (0x00F4, COMPOSE_OFF, gcPre_00F4),
		new CompositionData (0x00F5, COMPOSE_OFF, gcPre_00F5),
		new CompositionData (0x014D, COMPOSE_OFF, gcPre_014D),
		new CompositionData (0x014F, COMPOSE_OFF, gcPre_014F),
		new CompositionData (0x022F, COMPOSE_OFF, gcPre_022F),
		new CompositionData (0x00F6, COMPOSE_OFF, gcPre_00F6),
		new CompositionData (0x1ECF, COMPOSE_OFF, gcPre_1ECF),
		new CompositionData (0x0151, COMPOSE_OFF, gcPre_0151),
		new CompositionData (0x01D2, COMPOSE_OFF, gcPre_01D2),
		new CompositionData (0x020D, COMPOSE_OFF, gcPre_020D),
		new CompositionData (0x020F, COMPOSE_OFF, gcPre_020F),
		new CompositionData (0x01A1, COMPOSE_OFF, gcPre_01A1),
		new CompositionData (0x1ECD, COMPOSE_OFF, gcPre_1ECD),
		new CompositionData (0x01EB, COMPOSE_OFF, gcPre_01EB),
		new CompositionData (0x1E55, COMPOSE_OFF, gcPre_1E55),
		new CompositionData (0x1E57, COMPOSE_OFF, gcPre_1E57),
		new CompositionData (0x0155, COMPOSE_OFF, gcPre_0155),
		new CompositionData (0x1E59, COMPOSE_OFF, gcPre_1E59),
		new CompositionData (0x0159, COMPOSE_OFF, gcPre_0159),
		new CompositionData (0x0211, COMPOSE_OFF, gcPre_0211),
		new CompositionData (0x0213, COMPOSE_OFF, gcPre_0213),
		new CompositionData (0x1E5B, COMPOSE_OFF, gcPre_1E5B),
		new CompositionData (0x0157, COMPOSE_OFF, gcPre_0157),
		new CompositionData (0x1E5F, COMPOSE_OFF, gcPre_1E5F),
		new CompositionData (0x015B, COMPOSE_OFF, gcPre_015B),
		new CompositionData (0x015D, COMPOSE_OFF, gcPre_015D),
		new CompositionData (0x1E61, COMPOSE_OFF, gcPre_1E61),
		new CompositionData (0x0161, COMPOSE_OFF, gcPre_0161),
		new CompositionData (0x1E63, COMPOSE_OFF, gcPre_1E63),
		new CompositionData (0x0219, COMPOSE_OFF, gcPre_0219),
		new CompositionData (0x015F, COMPOSE_OFF, gcPre_015F),
		new CompositionData (0x1E6B, COMPOSE_OFF, gcPre_1E6B),
		new CompositionData (0x1E97, COMPOSE_OFF, gcPre_1E97),
		new CompositionData (0x0165, COMPOSE_OFF, gcPre_0165),
		new CompositionData (0x1E6D, COMPOSE_OFF, gcPre_1E6D),
		new CompositionData (0x021B, COMPOSE_OFF, gcPre_021B),
		new CompositionData (0x0163, COMPOSE_OFF, gcPre_0163),
		new CompositionData (0x1E71, COMPOSE_OFF, gcPre_1E71),
		new CompositionData (0x1E6F, COMPOSE_OFF, gcPre_1E6F),
		new CompositionData (0x00F9, COMPOSE_OFF, gcPre_00F9),
		new CompositionData (0x00FA, COMPOSE_OFF, gcPre_00FA),
		new CompositionData (0x00FB, COMPOSE_OFF, gcPre_00FB),
		new CompositionData (0x0169, COMPOSE_OFF, gcPre_0169),
		new CompositionData (0x016B, COMPOSE_OFF, gcPre_016B),
		new CompositionData (0x016D, COMPOSE_OFF, gcPre_016D),
		new CompositionData (0x00FC, COMPOSE_OFF, gcPre_00FC),
		new CompositionData (0x1EE7, COMPOSE_OFF, gcPre_1EE7),
		new CompositionData (0x016F, COMPOSE_OFF, gcPre_016F),
		new CompositionData (0x0171, COMPOSE_OFF, gcPre_0171),
		new CompositionData (0x01D4, COMPOSE_OFF, gcPre_01D4),
		new CompositionData (0x0215, COMPOSE_OFF, gcPre_0215),
		new CompositionData (0x0217, COMPOSE_OFF, gcPre_0217),
		new CompositionData (0x01B0, COMPOSE_OFF, gcPre_01B0),
		new CompositionData (0x1EE5, COMPOSE_OFF, gcPre_1EE5),
		new CompositionData (0x1E73, COMPOSE_OFF, gcPre_1E73),
		new CompositionData (0x0173, COMPOSE_OFF, gcPre_0173),
		new CompositionData (0x1E77, COMPOSE_OFF, gcPre_1E77),
		new CompositionData (0x1E75, COMPOSE_OFF, gcPre_1E75),
		new CompositionData (0x1E7D, COMPOSE_OFF, gcPre_1E7D),
		new CompositionData (0x1E7F, COMPOSE_OFF, gcPre_1E7F),
		new CompositionData (0x1E81, COMPOSE_OFF, gcPre_1E81),
		new CompositionData (0x1E83, COMPOSE_OFF, gcPre_1E83),
		new CompositionData (0x0175, COMPOSE_OFF, gcPre_0175),
		new CompositionData (0x1E87, COMPOSE_OFF, gcPre_1E87),
		new CompositionData (0x1E85, COMPOSE_OFF, gcPre_1E85),
		new CompositionData (0x1E98, COMPOSE_OFF, gcPre_1E98),
		new CompositionData (0x1E89, COMPOSE_OFF, gcPre_1E89),
		new CompositionData (0x1E8B, COMPOSE_OFF, gcPre_1E8B),
		new CompositionData (0x1E8D, COMPOSE_OFF, gcPre_1E8D),
		new CompositionData (0x1EF3, COMPOSE_OFF, gcPre_1EF3),
		new CompositionData (0x00FD, COMPOSE_OFF, gcPre_00FD),
		new CompositionData (0x0177, COMPOSE_OFF, gcPre_0177),
		new CompositionData (0x1EF9, COMPOSE_OFF, gcPre_1EF9),
		new CompositionData (0x0233, COMPOSE_OFF, gcPre_0233),
		new CompositionData (0x1E8F, COMPOSE_OFF, gcPre_1E8F),
		new CompositionData (0x00FF, COMPOSE_OFF, gcPre_00FF),
		new CompositionData (0x1EF7, COMPOSE_OFF, gcPre_1EF7),
		new CompositionData (0x1E99, COMPOSE_OFF, gcPre_1E99),
		new CompositionData (0x1EF5, COMPOSE_OFF, gcPre_1EF5),
		new CompositionData (0x017A, COMPOSE_OFF, gcPre_017A),
		new CompositionData (0x1E91, COMPOSE_OFF, gcPre_1E91),
		new CompositionData (0x017C, COMPOSE_OFF, gcPre_017C),
		new CompositionData (0x017E, COMPOSE_OFF, gcPre_017E),
		new CompositionData (0x1E93, COMPOSE_OFF, gcPre_1E93),
		new CompositionData (0x1E95, COMPOSE_OFF, gcPre_1E95),
		new CompositionData (0x1FED, COMPOSE_OFF, gcPre_1FED),
		new CompositionData (0x0385, COMPOSE_OFF, gcPre_0385),
		new CompositionData (0x1FC1, COMPOSE_OFF, gcPre_1FC1),
		new CompositionData (0x1EA6, COMPOSE_OFF, gcPre_1EA6),
		new CompositionData (0x1EA4, COMPOSE_OFF, gcPre_1EA4),
		new CompositionData (0x1EAA, COMPOSE_OFF, gcPre_1EAA),
		new CompositionData (0x1EA8, COMPOSE_OFF, gcPre_1EA8),
		new CompositionData (0x01DE, COMPOSE_OFF, gcPre_01DE),
		new CompositionData (0x01FA, COMPOSE_OFF, gcPre_01FA),
		new CompositionData (0x01FC, COMPOSE_OFF, gcPre_01FC),
		new CompositionData (0x01E2, COMPOSE_OFF, gcPre_01E2),
		new CompositionData (0x1E08, COMPOSE_OFF, gcPre_1E08),
		new CompositionData (0x1EC0, COMPOSE_OFF, gcPre_1EC0),
		new CompositionData (0x1EBE, COMPOSE_OFF, gcPre_1EBE),
		new CompositionData (0x1EC4, COMPOSE_OFF, gcPre_1EC4),
		new CompositionData (0x1EC2, COMPOSE_OFF, gcPre_1EC2),
		new CompositionData (0x1E2E, COMPOSE_OFF, gcPre_1E2E),
		new CompositionData (0x1ED2, COMPOSE_OFF, gcPre_1ED2),
		new CompositionData (0x1ED0, COMPOSE_OFF, gcPre_1ED0),
		new CompositionData (0x1ED6, COMPOSE_OFF, gcPre_1ED6),
		new CompositionData (0x1ED4, COMPOSE_OFF, gcPre_1ED4),
		new CompositionData (0x1E4C, COMPOSE_OFF, gcPre_1E4C),
		new CompositionData (0x022C, COMPOSE_OFF, gcPre_022C),
		new CompositionData (0x1E4E, COMPOSE_OFF, gcPre_1E4E),
		new CompositionData (0x022A, COMPOSE_OFF, gcPre_022A),
		new CompositionData (0x01FE, COMPOSE_OFF, gcPre_01FE),
		new CompositionData (0x01DB, COMPOSE_OFF, gcPre_01DB),
		new CompositionData (0x01D7, COMPOSE_OFF, gcPre_01D7),
		new CompositionData (0x01D5, COMPOSE_OFF, gcPre_01D5),
		new CompositionData (0x01D9, COMPOSE_OFF, gcPre_01D9),
		new CompositionData (0x1EA7, COMPOSE_OFF, gcPre_1EA7),
		new CompositionData (0x1EA5, COMPOSE_OFF, gcPre_1EA5),
		new CompositionData (0x1EAB, COMPOSE_OFF, gcPre_1EAB),
		new CompositionData (0x1EA9, COMPOSE_OFF, gcPre_1EA9),
		new CompositionData (0x01DF, COMPOSE_OFF, gcPre_01DF),
		new CompositionData (0x01FB, COMPOSE_OFF, gcPre_01FB),
		new CompositionData (0x01FD, COMPOSE_OFF, gcPre_01FD),
		new CompositionData (0x01E3, COMPOSE_OFF, gcPre_01E3),
		new CompositionData (0x1E09, COMPOSE_OFF, gcPre_1E09),
		new CompositionData (0x1EC1, COMPOSE_OFF, gcPre_1EC1),
		new CompositionData (0x1EBF, COMPOSE_OFF, gcPre_1EBF),
		new CompositionData (0x1EC5, COMPOSE_OFF, gcPre_1EC5),
		new CompositionData (0x1EC3, COMPOSE_OFF, gcPre_1EC3),
		new CompositionData (0x1E2F, COMPOSE_OFF, gcPre_1E2F),
		new CompositionData (0x1ED3, COMPOSE_OFF, gcPre_1ED3),
		new CompositionData (0x1ED1, COMPOSE_OFF, gcPre_1ED1),
		new CompositionData (0x1ED7, COMPOSE_OFF, gcPre_1ED7),
		new CompositionData (0x1ED5, COMPOSE_OFF, gcPre_1ED5),
		new CompositionData (0x1E4D, COMPOSE_OFF, gcPre_1E4D),
		new CompositionData (0x022D, COMPOSE_OFF, gcPre_022D),
		new CompositionData (0x1E4F, COMPOSE_OFF, gcPre_1E4F),
		new CompositionData (0x022B, COMPOSE_OFF, gcPre_022B),
		new CompositionData (0x01FF, COMPOSE_OFF, gcPre_01FF),
		new CompositionData (0x01DC, COMPOSE_OFF, gcPre_01DC),
		new CompositionData (0x01D8, COMPOSE_OFF, gcPre_01D8),
		new CompositionData (0x01D6, COMPOSE_OFF, gcPre_01D6),
		new CompositionData (0x01DA, COMPOSE_OFF, gcPre_01DA),
		new CompositionData (0x1EB0, COMPOSE_OFF, gcPre_1EB0),
		new CompositionData (0x1EAE, COMPOSE_OFF, gcPre_1EAE),
		new CompositionData (0x1EB4, COMPOSE_OFF, gcPre_1EB4),
		new CompositionData (0x1EB2, COMPOSE_OFF, gcPre_1EB2),
		new CompositionData (0x1EB1, COMPOSE_OFF, gcPre_1EB1),
		new CompositionData (0x1EAF, COMPOSE_OFF, gcPre_1EAF),
		new CompositionData (0x1EB5, COMPOSE_OFF, gcPre_1EB5),
		new CompositionData (0x1EB3, COMPOSE_OFF, gcPre_1EB3),
		new CompositionData (0x1E14, COMPOSE_OFF, gcPre_1E14),
		new CompositionData (0x1E16, COMPOSE_OFF, gcPre_1E16),
		new CompositionData (0x1E15, COMPOSE_OFF, gcPre_1E15),
		new CompositionData (0x1E17, COMPOSE_OFF, gcPre_1E17),
		new CompositionData (0x1E50, COMPOSE_OFF, gcPre_1E50),
		new CompositionData (0x1E52, COMPOSE_OFF, gcPre_1E52),
		new CompositionData (0x1E51, COMPOSE_OFF, gcPre_1E51),
		new CompositionData (0x1E53, COMPOSE_OFF, gcPre_1E53),
		new CompositionData (0x1E64, COMPOSE_OFF, gcPre_1E64),
		new CompositionData (0x1E65, COMPOSE_OFF, gcPre_1E65),
		new CompositionData (0x1E66, COMPOSE_OFF, gcPre_1E66),
		new CompositionData (0x1E67, COMPOSE_OFF, gcPre_1E67),
		new CompositionData (0x1E78, COMPOSE_OFF, gcPre_1E78),
		new CompositionData (0x1E79, COMPOSE_OFF, gcPre_1E79),
		new CompositionData (0x1E7A, COMPOSE_OFF, gcPre_1E7A),
		new CompositionData (0x1E7B, COMPOSE_OFF, gcPre_1E7B),
		new CompositionData (0x1E9B, COMPOSE_OFF, gcPre_1E9B),
		new CompositionData (0x1EDC, COMPOSE_OFF, gcPre_1EDC),
		new CompositionData (0x1EDA, COMPOSE_OFF, gcPre_1EDA),
		new CompositionData (0x1EE0, COMPOSE_OFF, gcPre_1EE0),
		new CompositionData (0x1EDE, COMPOSE_OFF, gcPre_1EDE),
		new CompositionData (0x1EE2, COMPOSE_OFF, gcPre_1EE2),
		new CompositionData (0x1EDD, COMPOSE_OFF, gcPre_1EDD),
		new CompositionData (0x1EDB, COMPOSE_OFF, gcPre_1EDB),
		new CompositionData (0x1EE1, COMPOSE_OFF, gcPre_1EE1),
		new CompositionData (0x1EDF, COMPOSE_OFF, gcPre_1EDF),
		new CompositionData (0x1EE3, COMPOSE_OFF, gcPre_1EE3),
		new CompositionData (0x1EEA, COMPOSE_OFF, gcPre_1EEA),
		new CompositionData (0x1EE8, COMPOSE_OFF, gcPre_1EE8),
		new CompositionData (0x1EEE, COMPOSE_OFF, gcPre_1EEE),
		new CompositionData (0x1EEC, COMPOSE_OFF, gcPre_1EEC),
		new CompositionData (0x1EF0, COMPOSE_OFF, gcPre_1EF0),
		new CompositionData (0x1EEB, COMPOSE_OFF, gcPre_1EEB),
		new CompositionData (0x1EE9, COMPOSE_OFF, gcPre_1EE9),
		new CompositionData (0x1EEF, COMPOSE_OFF, gcPre_1EEF),
		new CompositionData (0x1EED, COMPOSE_OFF, gcPre_1EED),
		new CompositionData (0x1EF1, COMPOSE_OFF, gcPre_1EF1),
		new CompositionData (0x01EE, COMPOSE_OFF, gcPre_01EE),
		new CompositionData (0x01EC, COMPOSE_OFF, gcPre_01EC),
		new CompositionData (0x01ED, COMPOSE_OFF, gcPre_01ED),
		new CompositionData (0x01E0, COMPOSE_OFF, gcPre_01E0),
		new CompositionData (0x01E1, COMPOSE_OFF, gcPre_01E1),
		new CompositionData (0x1E1C, COMPOSE_OFF, gcPre_1E1C),
		new CompositionData (0x1E1D, COMPOSE_OFF, gcPre_1E1D),
		new CompositionData (0x0230, COMPOSE_OFF, gcPre_0230),
		new CompositionData (0x0231, COMPOSE_OFF, gcPre_0231),
		new CompositionData (0x01EF, COMPOSE_OFF, gcPre_01EF),
		new CompositionData (0x1FBA, COMPOSE_OFF, gcPre_1FBA),
		new CompositionData (0x0386, COMPOSE_OFF, gcPre_0386),
		new CompositionData (0x1FB9, COMPOSE_OFF, gcPre_1FB9),
		new CompositionData (0x1FB8, COMPOSE_OFF, gcPre_1FB8),
		new CompositionData (0x1F08, COMPOSE_OFF, gcPre_1F08),
		new CompositionData (0x1F09, COMPOSE_OFF, gcPre_1F09),
		new CompositionData (0x1FBC, COMPOSE_OFF, gcPre_1FBC),
		new CompositionData (0x1FC8, COMPOSE_OFF, gcPre_1FC8),
		new CompositionData (0x0388, COMPOSE_OFF, gcPre_0388),
		new CompositionData (0x1F18, COMPOSE_OFF, gcPre_1F18),
		new CompositionData (0x1F19, COMPOSE_OFF, gcPre_1F19),
		new CompositionData (0x1FCA, COMPOSE_OFF, gcPre_1FCA),
		new CompositionData (0x0389, COMPOSE_OFF, gcPre_0389),
		new CompositionData (0x1F28, COMPOSE_OFF, gcPre_1F28),
		new CompositionData (0x1F29, COMPOSE_OFF, gcPre_1F29),
		new CompositionData (0x1FCC, COMPOSE_OFF, gcPre_1FCC),
		new CompositionData (0x1FDA, COMPOSE_OFF, gcPre_1FDA),
		new CompositionData (0x038A, COMPOSE_OFF, gcPre_038A),
		new CompositionData (0x1FD9, COMPOSE_OFF, gcPre_1FD9),
		new CompositionData (0x1FD8, COMPOSE_OFF, gcPre_1FD8),
		new CompositionData (0x03AA, COMPOSE_OFF, gcPre_03AA),
		new CompositionData (0x1F38, COMPOSE_OFF, gcPre_1F38),
		new CompositionData (0x1F39, COMPOSE_OFF, gcPre_1F39),
		new CompositionData (0x1FF8, COMPOSE_OFF, gcPre_1FF8),
		new CompositionData (0x038C, COMPOSE_OFF, gcPre_038C),
		new CompositionData (0x1F48, COMPOSE_OFF, gcPre_1F48),
		new CompositionData (0x1F49, COMPOSE_OFF, gcPre_1F49),
		new CompositionData (0x1FEC, COMPOSE_OFF, gcPre_1FEC),
		new CompositionData (0x1FEA, COMPOSE_OFF, gcPre_1FEA),
		new CompositionData (0x038E, COMPOSE_OFF, gcPre_038E),
		new CompositionData (0x1FE9, COMPOSE_OFF, gcPre_1FE9),
		new CompositionData (0x1FE8, COMPOSE_OFF, gcPre_1FE8),
		new CompositionData (0x03AB, COMPOSE_OFF, gcPre_03AB),
		new CompositionData (0x1F59, COMPOSE_OFF, gcPre_1F59),
		new CompositionData (0x1FFA, COMPOSE_OFF, gcPre_1FFA),
		new CompositionData (0x038F, COMPOSE_OFF, gcPre_038F),
		new CompositionData (0x1F68, COMPOSE_OFF, gcPre_1F68),
		new CompositionData (0x1F69, COMPOSE_OFF, gcPre_1F69),
		new CompositionData (0x1FFC, COMPOSE_OFF, gcPre_1FFC),
		new CompositionData (0x1FB4, COMPOSE_OFF, gcPre_1FB4),
		new CompositionData (0x1FC4, COMPOSE_OFF, gcPre_1FC4),
		new CompositionData (0x1F70, COMPOSE_OFF, gcPre_1F70),
		new CompositionData (0x03AC, COMPOSE_OFF, gcPre_03AC),
		new CompositionData (0x1FB1, COMPOSE_OFF, gcPre_1FB1),
		new CompositionData (0x1FB0, COMPOSE_OFF, gcPre_1FB0),
		new CompositionData (0x1F00, COMPOSE_OFF, gcPre_1F00),
		new CompositionData (0x1F01, COMPOSE_OFF, gcPre_1F01),
		new CompositionData (0x1FB6, COMPOSE_OFF, gcPre_1FB6),
		new CompositionData (0x1FB3, COMPOSE_OFF, gcPre_1FB3),
		new CompositionData (0x1F72, COMPOSE_OFF, gcPre_1F72),
		new CompositionData (0x03AD, COMPOSE_OFF, gcPre_03AD),
		new CompositionData (0x1F10, COMPOSE_OFF, gcPre_1F10),
		new CompositionData (0x1F11, COMPOSE_OFF, gcPre_1F11),
		new CompositionData (0x1F74, COMPOSE_OFF, gcPre_1F74),
		new CompositionData (0x03AE, COMPOSE_OFF, gcPre_03AE),
		new CompositionData (0x1F20, COMPOSE_OFF, gcPre_1F20),
		new CompositionData (0x1F21, COMPOSE_OFF, gcPre_1F21),
		new CompositionData (0x1FC6, COMPOSE_OFF, gcPre_1FC6),
		new CompositionData (0x1FC3, COMPOSE_OFF, gcPre_1FC3),
		new CompositionData (0x1F76, COMPOSE_OFF, gcPre_1F76),
		new CompositionData (0x03AF, COMPOSE_OFF, gcPre_03AF),
		new CompositionData (0x1FD1, COMPOSE_OFF, gcPre_1FD1),
		new CompositionData (0x1FD0, COMPOSE_OFF, gcPre_1FD0),
		new CompositionData (0x03CA, COMPOSE_OFF, gcPre_03CA),
		new CompositionData (0x1F30, COMPOSE_OFF, gcPre_1F30),
		new CompositionData (0x1F31, COMPOSE_OFF, gcPre_1F31),
		new CompositionData (0x1FD6, COMPOSE_OFF, gcPre_1FD6),
		new CompositionData (0x1F78, COMPOSE_OFF, gcPre_1F78),
		new CompositionData (0x03CC, COMPOSE_OFF, gcPre_03CC),
		new CompositionData (0x1F40, COMPOSE_OFF, gcPre_1F40),
		new CompositionData (0x1F41, COMPOSE_OFF, gcPre_1F41),
		new CompositionData (0x1FE4, COMPOSE_OFF, gcPre_1FE4),
		new CompositionData (0x1FE5, COMPOSE_OFF, gcPre_1FE5),
		new CompositionData (0x1F7A, COMPOSE_OFF, gcPre_1F7A),
		new CompositionData (0x03CD, COMPOSE_OFF, gcPre_03CD),
		new CompositionData (0x1FE1, COMPOSE_OFF, gcPre_1FE1),
		new CompositionData (0x1FE0, COMPOSE_OFF, gcPre_1FE0),
		new CompositionData (0x03CB, COMPOSE_OFF, gcPre_03CB),
		new CompositionData (0x1F50, COMPOSE_OFF, gcPre_1F50),
		new CompositionData (0x1F51, COMPOSE_OFF, gcPre_1F51),
		new CompositionData (0x1FE6, COMPOSE_OFF, gcPre_1FE6),
		new CompositionData (0x1F7C, COMPOSE_OFF, gcPre_1F7C),
		new CompositionData (0x03CE, COMPOSE_OFF, gcPre_03CE),
		new CompositionData (0x1F60, COMPOSE_OFF, gcPre_1F60),
		new CompositionData (0x1F61, COMPOSE_OFF, gcPre_1F61),
		new CompositionData (0x1FF6, COMPOSE_OFF, gcPre_1FF6),
		new CompositionData (0x1FF3, COMPOSE_OFF, gcPre_1FF3),
		new CompositionData (0x1FD2, COMPOSE_OFF, gcPre_1FD2),
		new CompositionData (0x0390, COMPOSE_OFF, gcPre_0390),
		new CompositionData (0x1FD7, COMPOSE_OFF, gcPre_1FD7),
		new CompositionData (0x1FE2, COMPOSE_OFF, gcPre_1FE2),
		new CompositionData (0x03B0, COMPOSE_OFF, gcPre_03B0),
		new CompositionData (0x1FE7, COMPOSE_OFF, gcPre_1FE7),
		new CompositionData (0x1FF4, COMPOSE_OFF, gcPre_1FF4),
		new CompositionData (0x03D3, COMPOSE_OFF, gcPre_03D3),
		new CompositionData (0x03D4, COMPOSE_OFF, gcPre_03D4),
		new CompositionData (0x0407, COMPOSE_OFF, gcPre_0407),
		new CompositionData (0x04D0, COMPOSE_OFF, gcPre_04D0),
		new CompositionData (0x04D2, COMPOSE_OFF, gcPre_04D2),
		new CompositionData (0x0403, COMPOSE_OFF, gcPre_0403),
		new CompositionData (0x0400, COMPOSE_OFF, gcPre_0400),
		new CompositionData (0x04D6, COMPOSE_OFF, gcPre_04D6),
		new CompositionData (0x0401, COMPOSE_OFF, gcPre_0401),
		new CompositionData (0x04C1, COMPOSE_OFF, gcPre_04C1),
		new CompositionData (0x04DC, COMPOSE_OFF, gcPre_04DC),
		new CompositionData (0x04DE, COMPOSE_OFF, gcPre_04DE),
		new CompositionData (0x040D, COMPOSE_OFF, gcPre_040D),
		new CompositionData (0x04E2, COMPOSE_OFF, gcPre_04E2),
		new CompositionData (0x0419, COMPOSE_OFF, gcPre_0419),
		new CompositionData (0x04E4, COMPOSE_OFF, gcPre_04E4),
		new CompositionData (0x040C, COMPOSE_OFF, gcPre_040C),
		new CompositionData (0x04E6, COMPOSE_OFF, gcPre_04E6),
		new CompositionData (0x04EE, COMPOSE_OFF, gcPre_04EE),
		new CompositionData (0x040E, COMPOSE_OFF, gcPre_040E),
		new CompositionData (0x04F0, COMPOSE_OFF, gcPre_04F0),
		new CompositionData (0x04F2, COMPOSE_OFF, gcPre_04F2),
		new CompositionData (0x04F4, COMPOSE_OFF, gcPre_04F4),
		new CompositionData (0x04F8, COMPOSE_OFF, gcPre_04F8),
		new CompositionData (0x04EC, COMPOSE_OFF, gcPre_04EC),
		new CompositionData (0x04D1, COMPOSE_OFF, gcPre_04D1),
		new CompositionData (0x04D3, COMPOSE_OFF, gcPre_04D3),
		new CompositionData (0x0453, COMPOSE_OFF, gcPre_0453),
		new CompositionData (0x0450, COMPOSE_OFF, gcPre_0450),
		new CompositionData (0x04D7, COMPOSE_OFF, gcPre_04D7),
		new CompositionData (0x0451, COMPOSE_OFF, gcPre_0451),
		new CompositionData (0x04C2, COMPOSE_OFF, gcPre_04C2),
		new CompositionData (0x04DD, COMPOSE_OFF, gcPre_04DD),
		new CompositionData (0x04DF, COMPOSE_OFF, gcPre_04DF),
		new CompositionData (0x045D, COMPOSE_OFF, gcPre_045D),
		new CompositionData (0x04E3, COMPOSE_OFF, gcPre_04E3),
		new CompositionData (0x0439, COMPOSE_OFF, gcPre_0439),
		new CompositionData (0x04E5, COMPOSE_OFF, gcPre_04E5),
		new CompositionData (0x045C, COMPOSE_OFF, gcPre_045C),
		new CompositionData (0x04E7, COMPOSE_OFF, gcPre_04E7),
		new CompositionData (0x04EF, COMPOSE_OFF, gcPre_04EF),
		new CompositionData (0x045E, COMPOSE_OFF, gcPre_045E),
		new CompositionData (0x04F1, COMPOSE_OFF, gcPre_04F1),
		new CompositionData (0x04F3, COMPOSE_OFF, gcPre_04F3),
		new CompositionData (0x04F5, COMPOSE_OFF, gcPre_04F5),
		new CompositionData (0x04F9, COMPOSE_OFF, gcPre_04F9),
		new CompositionData (0x04ED, COMPOSE_OFF, gcPre_04ED),
		new CompositionData (0x0457, COMPOSE_OFF, gcPre_0457),
		new CompositionData (0x0476, COMPOSE_OFF, gcPre_0476),
		new CompositionData (0x0477, COMPOSE_OFF, gcPre_0477),
		new CompositionData (0x04DA, COMPOSE_OFF, gcPre_04DA),
		new CompositionData (0x04DB, COMPOSE_OFF, gcPre_04DB),
		new CompositionData (0x04EA, COMPOSE_OFF, gcPre_04EA),
		new CompositionData (0x04EB, COMPOSE_OFF, gcPre_04EB),
		new CompositionData (0xFB2E, COMPOSE_OFF, gcPre_FB2E),
		new CompositionData (0xFB2F, COMPOSE_OFF, gcPre_FB2F),
		new CompositionData (0xFB30, COMPOSE_OFF, gcPre_FB30),
		new CompositionData (0xFB31, COMPOSE_OFF, gcPre_FB31),
		new CompositionData (0xFB4C, COMPOSE_OFF, gcPre_FB4C),
		new CompositionData (0xFB32, COMPOSE_OFF, gcPre_FB32),
		new CompositionData (0xFB33, COMPOSE_OFF, gcPre_FB33),
		new CompositionData (0xFB34, COMPOSE_OFF, gcPre_FB34),
		new CompositionData (0xFB4B, COMPOSE_OFF, gcPre_FB4B),
		new CompositionData (0xFB35, COMPOSE_OFF, gcPre_FB35),
		new CompositionData (0xFB36, COMPOSE_OFF, gcPre_FB36),
		new CompositionData (0xFB38, COMPOSE_OFF, gcPre_FB38),
		new CompositionData (0xFB1D, COMPOSE_OFF, gcPre_FB1D),
		new CompositionData (0xFB39, COMPOSE_OFF, gcPre_FB39),
		new CompositionData (0xFB3A, COMPOSE_OFF, gcPre_FB3A),
		new CompositionData (0xFB3B, COMPOSE_OFF, gcPre_FB3B),
		new CompositionData (0xFB4D, COMPOSE_OFF, gcPre_FB4D),
		new CompositionData (0xFB3C, COMPOSE_OFF, gcPre_FB3C),
		new CompositionData (0xFB3E, COMPOSE_OFF, gcPre_FB3E),
		new CompositionData (0xFB40, COMPOSE_OFF, gcPre_FB40),
		new CompositionData (0xFB41, COMPOSE_OFF, gcPre_FB41),
		new CompositionData (0xFB43, COMPOSE_OFF, gcPre_FB43),
		new CompositionData (0xFB44, COMPOSE_OFF, gcPre_FB44),
		new CompositionData (0xFB4E, COMPOSE_OFF, gcPre_FB4E),
		new CompositionData (0xFB46, COMPOSE_OFF, gcPre_FB46),
		new CompositionData (0xFB47, COMPOSE_OFF, gcPre_FB47),
		new CompositionData (0xFB48, COMPOSE_OFF, gcPre_FB48),
		new CompositionData (0xFB49, COMPOSE_OFF, gcPre_FB49),
		new CompositionData (0xFB2A, COMPOSE_OFF, gcPre_FB2A),
		new CompositionData (0xFB2B, COMPOSE_OFF, gcPre_FB2B),
		new CompositionData (0xFB4A, COMPOSE_OFF, gcPre_FB4A),
		new CompositionData (0xFB1F, COMPOSE_OFF, gcPre_FB1F),
		new CompositionData (0xFD3C, COMPOSE_OFF, gcPre_FD3C),
		new CompositionData (0xFD3D, COMPOSE_OFF, gcPre_FD3D),
		new CompositionData (0x0622, COMPOSE_OFF, gcPre_0622),
		new CompositionData (0x0623, COMPOSE_OFF, gcPre_0623),
		new CompositionData (0x0625, COMPOSE_OFF, gcPre_0625),
		new CompositionData (0xFC5B, COMPOSE_OFF, gcPre_FC5B),
		new CompositionData (0xFC5C, COMPOSE_OFF, gcPre_FC5C),
		new CompositionData (0xFE71, COMPOSE_OFF, gcPre_FE71),
		new CompositionData (0xFE77, COMPOSE_OFF, gcPre_FE77),
		new CompositionData (0xFCF2, COMPOSE_OFF, gcPre_FCF2),
		new CompositionData (0xFE79, COMPOSE_OFF, gcPre_FE79),
		new CompositionData (0xFCF3, COMPOSE_OFF, gcPre_FCF3),
		new CompositionData (0xFE7B, COMPOSE_OFF, gcPre_FE7B),
		new CompositionData (0xFCF4, COMPOSE_OFF, gcPre_FCF4),
		new CompositionData (0xFE7D, COMPOSE_OFF, gcPre_FE7D),
		new CompositionData (0xFE7F, COMPOSE_OFF, gcPre_FE7F),
		new CompositionData (0xFCD9, COMPOSE_OFF, gcPre_FCD9),
		new CompositionData (0x0624, COMPOSE_OFF, gcPre_0624),
		new CompositionData (0xFC5D, COMPOSE_OFF, gcPre_FC5D),
		new CompositionData (0xFC90, COMPOSE_OFF, gcPre_FC90),
		new CompositionData (0x0626, COMPOSE_OFF, gcPre_0626),
		new CompositionData (0x06C2, COMPOSE_OFF, gcPre_06C2),
		new CompositionData (0x06D3, COMPOSE_OFF, gcPre_06D3),
		new CompositionData (0x06C0, COMPOSE_OFF, gcPre_06C0),
		new CompositionData (0x0958, COMPOSE_OFF, gcPre_0958),
		new CompositionData (0x0959, COMPOSE_OFF, gcPre_0959),
		new CompositionData (0x095A, COMPOSE_OFF, gcPre_095A),
		new CompositionData (0x095B, COMPOSE_OFF, gcPre_095B),
		new CompositionData (0x095C, COMPOSE_OFF, gcPre_095C),
		new CompositionData (0x095D, COMPOSE_OFF, gcPre_095D),
		new CompositionData (0x0929, COMPOSE_OFF, gcPre_0929),
		new CompositionData (0x095E, COMPOSE_OFF, gcPre_095E),
		new CompositionData (0x095F, COMPOSE_OFF, gcPre_095F),
		new CompositionData (0x0931, COMPOSE_OFF, gcPre_0931),
		new CompositionData (0x0934, COMPOSE_OFF, gcPre_0934),
		new CompositionData (0x09DC, COMPOSE_OFF, gcPre_09DC),
		new CompositionData (0x09DD, COMPOSE_OFF, gcPre_09DD),
		new CompositionData (0x09DF, COMPOSE_OFF, gcPre_09DF),
		new CompositionData (0x0A59, COMPOSE_OFF, gcPre_0A59),
		new CompositionData (0x0A5A, COMPOSE_OFF, gcPre_0A5A),
		new CompositionData (0x0A5B, COMPOSE_OFF, gcPre_0A5B),
		new CompositionData (0x0A5E, COMPOSE_OFF, gcPre_0A5E),
		new CompositionData (0x0A33, COMPOSE_OFF, gcPre_0A33),
		new CompositionData (0x0A36, COMPOSE_OFF, gcPre_0A36),
		new CompositionData (0x0B5C, COMPOSE_OFF, gcPre_0B5C),
		new CompositionData (0x0B5D, COMPOSE_OFF, gcPre_0B5D),
		new CompositionData (0x0B94, COMPOSE_OFF, gcPre_0B94),
		new CompositionData (0x0F69, COMPOSE_OFF, gcPre_0F69),
		new CompositionData (0x0F43, COMPOSE_OFF, gcPre_0F43),
		new CompositionData (0x0F4D, COMPOSE_OFF, gcPre_0F4D),
		new CompositionData (0x0F52, COMPOSE_OFF, gcPre_0F52),
		new CompositionData (0x0F57, COMPOSE_OFF, gcPre_0F57),
		new CompositionData (0x0F5C, COMPOSE_OFF, gcPre_0F5C),
		new CompositionData (0x1026, COMPOSE_OFF, gcPre_1026),
		new CompositionData (0x1E38, COMPOSE_OFF, gcPre_1E38),
		new CompositionData (0x1E39, COMPOSE_OFF, gcPre_1E39),
		new CompositionData (0x1E5C, COMPOSE_OFF, gcPre_1E5C),
		new CompositionData (0x1E5D, COMPOSE_OFF, gcPre_1E5D),
		new CompositionData (0x1E68, COMPOSE_OFF, gcPre_1E68),
		new CompositionData (0x1E69, COMPOSE_OFF, gcPre_1E69),
		new CompositionData (0x1EAC, COMPOSE_OFF, gcPre_1EAC),
		new CompositionData (0x1EB6, COMPOSE_OFF, gcPre_1EB6),
		new CompositionData (0x1EAD, COMPOSE_OFF, gcPre_1EAD),
		new CompositionData (0x1EB7, COMPOSE_OFF, gcPre_1EB7),
		new CompositionData (0x1EC6, COMPOSE_OFF, gcPre_1EC6),
		new CompositionData (0x1EC7, COMPOSE_OFF, gcPre_1EC7),
		new CompositionData (0x1ED8, COMPOSE_OFF, gcPre_1ED8),
		new CompositionData (0x1ED9, COMPOSE_OFF, gcPre_1ED9),
		new CompositionData (0x1F02, COMPOSE_OFF, gcPre_1F02),
		new CompositionData (0x1F04, COMPOSE_OFF, gcPre_1F04),
		new CompositionData (0x1F06, COMPOSE_OFF, gcPre_1F06),
		new CompositionData (0x1F80, COMPOSE_OFF, gcPre_1F80),
		new CompositionData (0x1F03, COMPOSE_OFF, gcPre_1F03),
		new CompositionData (0x1F05, COMPOSE_OFF, gcPre_1F05),
		new CompositionData (0x1F07, COMPOSE_OFF, gcPre_1F07),
		new CompositionData (0x1F81, COMPOSE_OFF, gcPre_1F81),
		new CompositionData (0x1F82, COMPOSE_OFF, gcPre_1F82),
		new CompositionData (0x1F83, COMPOSE_OFF, gcPre_1F83),
		new CompositionData (0x1F84, COMPOSE_OFF, gcPre_1F84),
		new CompositionData (0x1F85, COMPOSE_OFF, gcPre_1F85),
		new CompositionData (0x1F86, COMPOSE_OFF, gcPre_1F86),
		new CompositionData (0x1F87, COMPOSE_OFF, gcPre_1F87),
		new CompositionData (0x1F0A, COMPOSE_OFF, gcPre_1F0A),
		new CompositionData (0x1F0C, COMPOSE_OFF, gcPre_1F0C),
		new CompositionData (0x1F0E, COMPOSE_OFF, gcPre_1F0E),
		new CompositionData (0x1F88, COMPOSE_OFF, gcPre_1F88),
		new CompositionData (0x1F0B, COMPOSE_OFF, gcPre_1F0B),
		new CompositionData (0x1F0D, COMPOSE_OFF, gcPre_1F0D),
		new CompositionData (0x1F0F, COMPOSE_OFF, gcPre_1F0F),
		new CompositionData (0x1F89, COMPOSE_OFF, gcPre_1F89),
		new CompositionData (0x1F8A, COMPOSE_OFF, gcPre_1F8A),
		new CompositionData (0x1F8B, COMPOSE_OFF, gcPre_1F8B),
		new CompositionData (0x1F8C, COMPOSE_OFF, gcPre_1F8C),
		new CompositionData (0x1F8D, COMPOSE_OFF, gcPre_1F8D),
		new CompositionData (0x1F8E, COMPOSE_OFF, gcPre_1F8E),
		new CompositionData (0x1F8F, COMPOSE_OFF, gcPre_1F8F),
		new CompositionData (0x1F12, COMPOSE_OFF, gcPre_1F12),
		new CompositionData (0x1F14, COMPOSE_OFF, gcPre_1F14),
		new CompositionData (0x1F13, COMPOSE_OFF, gcPre_1F13),
		new CompositionData (0x1F15, COMPOSE_OFF, gcPre_1F15),
		new CompositionData (0x1F1A, COMPOSE_OFF, gcPre_1F1A),
		new CompositionData (0x1F1C, COMPOSE_OFF, gcPre_1F1C),
		new CompositionData (0x1F1B, COMPOSE_OFF, gcPre_1F1B),
		new CompositionData (0x1F1D, COMPOSE_OFF, gcPre_1F1D),
		new CompositionData (0x1F22, COMPOSE_OFF, gcPre_1F22),
		new CompositionData (0x1F24, COMPOSE_OFF, gcPre_1F24),
		new CompositionData (0x1F26, COMPOSE_OFF, gcPre_1F26),
		new CompositionData (0x1F90, COMPOSE_OFF, gcPre_1F90),
		new CompositionData (0x1F23, COMPOSE_OFF, gcPre_1F23),
		new CompositionData (0x1F25, COMPOSE_OFF, gcPre_1F25),
		new CompositionData (0x1F27, COMPOSE_OFF, gcPre_1F27),
		new CompositionData (0x1F91, COMPOSE_OFF, gcPre_1F91),
		new CompositionData (0x1F92, COMPOSE_OFF, gcPre_1F92),
		new CompositionData (0x1F93, COMPOSE_OFF, gcPre_1F93),
		new CompositionData (0x1F94, COMPOSE_OFF, gcPre_1F94),
		new CompositionData (0x1F95, COMPOSE_OFF, gcPre_1F95),
		new CompositionData (0x1F96, COMPOSE_OFF, gcPre_1F96),
		new CompositionData (0x1F97, COMPOSE_OFF, gcPre_1F97),
		new CompositionData (0x1F2A, COMPOSE_OFF, gcPre_1F2A),
		new CompositionData (0x1F2C, COMPOSE_OFF, gcPre_1F2C),
		new CompositionData (0x1F2E, COMPOSE_OFF, gcPre_1F2E),
		new CompositionData (0x1F98, COMPOSE_OFF, gcPre_1F98),
		new CompositionData (0x1F2B, COMPOSE_OFF, gcPre_1F2B),
		new CompositionData (0x1F2D, COMPOSE_OFF, gcPre_1F2D),
		new CompositionData (0x1F2F, COMPOSE_OFF, gcPre_1F2F),
		new CompositionData (0x1F99, COMPOSE_OFF, gcPre_1F99),
		new CompositionData (0x1F9A, COMPOSE_OFF, gcPre_1F9A),
		new CompositionData (0x1F9B, COMPOSE_OFF, gcPre_1F9B),
		new CompositionData (0x1F9C, COMPOSE_OFF, gcPre_1F9C),
		new CompositionData (0x1F9D, COMPOSE_OFF, gcPre_1F9D),
		new CompositionData (0x1F9E, COMPOSE_OFF, gcPre_1F9E),
		new CompositionData (0x1F9F, COMPOSE_OFF, gcPre_1F9F),
		new CompositionData (0x1F32, COMPOSE_OFF, gcPre_1F32),
		new CompositionData (0x1F34, COMPOSE_OFF, gcPre_1F34),
		new CompositionData (0x1F36, COMPOSE_OFF, gcPre_1F36),
		new CompositionData (0x1F33, COMPOSE_OFF, gcPre_1F33),
		new CompositionData (0x1F35, COMPOSE_OFF, gcPre_1F35),
		new CompositionData (0x1F37, COMPOSE_OFF, gcPre_1F37),
		new CompositionData (0x1F3A, COMPOSE_OFF, gcPre_1F3A),
		new CompositionData (0x1F3C, COMPOSE_OFF, gcPre_1F3C),
		new CompositionData (0x1F3E, COMPOSE_OFF, gcPre_1F3E),
		new CompositionData (0x1F3B, COMPOSE_OFF, gcPre_1F3B),
		new CompositionData (0x1F3D, COMPOSE_OFF, gcPre_1F3D),
		new CompositionData (0x1F3F, COMPOSE_OFF, gcPre_1F3F),
		new CompositionData (0x1F42, COMPOSE_OFF, gcPre_1F42),
		new CompositionData (0x1F44, COMPOSE_OFF, gcPre_1F44),
		new CompositionData (0x1F43, COMPOSE_OFF, gcPre_1F43),
		new CompositionData (0x1F45, COMPOSE_OFF, gcPre_1F45),
		new CompositionData (0x1F4A, COMPOSE_OFF, gcPre_1F4A),
		new CompositionData (0x1F4C, COMPOSE_OFF, gcPre_1F4C),
		new CompositionData (0x1F4B, COMPOSE_OFF, gcPre_1F4B),
		new CompositionData (0x1F4D, COMPOSE_OFF, gcPre_1F4D),
		new CompositionData (0x1F52, COMPOSE_OFF, gcPre_1F52),
		new CompositionData (0x1F54, COMPOSE_OFF, gcPre_1F54),
		new CompositionData (0x1F56, COMPOSE_OFF, gcPre_1F56),
		new CompositionData (0x1F53, COMPOSE_OFF, gcPre_1F53),
		new CompositionData (0x1F55, COMPOSE_OFF, gcPre_1F55),
		new CompositionData (0x1F57, COMPOSE_OFF, gcPre_1F57),
		new CompositionData (0x1F5B, COMPOSE_OFF, gcPre_1F5B),
		new CompositionData (0x1F5D, COMPOSE_OFF, gcPre_1F5D),
		new CompositionData (0x1F5F, COMPOSE_OFF, gcPre_1F5F),
		new CompositionData (0x1F62, COMPOSE_OFF, gcPre_1F62),
		new CompositionData (0x1F64, COMPOSE_OFF, gcPre_1F64),
		new CompositionData (0x1F66, COMPOSE_OFF, gcPre_1F66),
		new CompositionData (0x1FA0, COMPOSE_OFF, gcPre_1FA0),
		new CompositionData (0x1F63, COMPOSE_OFF, gcPre_1F63),
		new CompositionData (0x1F65, COMPOSE_OFF, gcPre_1F65),
		new CompositionData (0x1F67, COMPOSE_OFF, gcPre_1F67),
		new CompositionData (0x1FA1, COMPOSE_OFF, gcPre_1FA1),
		new CompositionData (0x1FA2, COMPOSE_OFF, gcPre_1FA2),
		new CompositionData (0x1FA3, COMPOSE_OFF, gcPre_1FA3),
		new CompositionData (0x1FA4, COMPOSE_OFF, gcPre_1FA4),
		new CompositionData (0x1FA5, COMPOSE_OFF, gcPre_1FA5),
		new CompositionData (0x1FA6, COMPOSE_OFF, gcPre_1FA6),
		new CompositionData (0x1FA7, COMPOSE_OFF, gcPre_1FA7),
		new CompositionData (0x1F6A, COMPOSE_OFF, gcPre_1F6A),
		new CompositionData (0x1F6C, COMPOSE_OFF, gcPre_1F6C),
		new CompositionData (0x1F6E, COMPOSE_OFF, gcPre_1F6E),
		new CompositionData (0x1FA8, COMPOSE_OFF, gcPre_1FA8),
		new CompositionData (0x1F6B, COMPOSE_OFF, gcPre_1F6B),
		new CompositionData (0x1F6D, COMPOSE_OFF, gcPre_1F6D),
		new CompositionData (0x1F6F, COMPOSE_OFF, gcPre_1F6F),
		new CompositionData (0x1FA9, COMPOSE_OFF, gcPre_1FA9),
		new CompositionData (0x1FAA, COMPOSE_OFF, gcPre_1FAA),
		new CompositionData (0x1FAB, COMPOSE_OFF, gcPre_1FAB),
		new CompositionData (0x1FAC, COMPOSE_OFF, gcPre_1FAC),
		new CompositionData (0x1FAD, COMPOSE_OFF, gcPre_1FAD),
		new CompositionData (0x1FAE, COMPOSE_OFF, gcPre_1FAE),
		new CompositionData (0x1FAF, COMPOSE_OFF, gcPre_1FAF),
		new CompositionData (0x1FB2, COMPOSE_OFF, gcPre_1FB2),
		new CompositionData (0x1FC2, COMPOSE_OFF, gcPre_1FC2),
		new CompositionData (0x1FF2, COMPOSE_OFF, gcPre_1FF2),
		new CompositionData (0x1FB7, COMPOSE_OFF, gcPre_1FB7),
		new CompositionData (0x1FCD, COMPOSE_OFF, gcPre_1FCD),
		new CompositionData (0x1FCE, COMPOSE_OFF, gcPre_1FCE),
		new CompositionData (0x1FCF, COMPOSE_OFF, gcPre_1FCF),
		new CompositionData (0x1FC7, COMPOSE_OFF, gcPre_1FC7),
		new CompositionData (0x1FF7, COMPOSE_OFF, gcPre_1FF7),
		new CompositionData (0x1FDD, COMPOSE_OFF, gcPre_1FDD),
		new CompositionData (0x1FDE, COMPOSE_OFF, gcPre_1FDE),
		new CompositionData (0x1FDF, COMPOSE_OFF, gcPre_1FDF),
		new CompositionData (0x219A, COMPOSE_OFF, gcPre_219A),
		new CompositionData (0x219B, COMPOSE_OFF, gcPre_219B),
		new CompositionData (0x21AE, COMPOSE_OFF, gcPre_21AE),
		new CompositionData (0x21CD, COMPOSE_OFF, gcPre_21CD),
		new CompositionData (0x21CF, COMPOSE_OFF, gcPre_21CF),
		new CompositionData (0x21CE, COMPOSE_OFF, gcPre_21CE),
		new CompositionData (0x2204, COMPOSE_OFF, gcPre_2204),
		new CompositionData (0x2209, COMPOSE_OFF, gcPre_2209),
		new CompositionData (0x220C, COMPOSE_OFF, gcPre_220C),
		new CompositionData (0x2224, COMPOSE_OFF, gcPre_2224),
		new CompositionData (0x2226, COMPOSE_OFF, gcPre_2226),
		new CompositionData (0x2241, COMPOSE_OFF, gcPre_2241),
		new CompositionData (0x2244, COMPOSE_OFF, gcPre_2244),
		new CompositionData (0x2247, COMPOSE_OFF, gcPre_2247),
		new CompositionData (0x2249, COMPOSE_OFF, gcPre_2249),
		new CompositionData (0x226D, COMPOSE_OFF, gcPre_226D),
		new CompositionData (0x2262, COMPOSE_OFF, gcPre_2262),
		new CompositionData (0x2270, COMPOSE_OFF, gcPre_2270),
		new CompositionData (0x2271, COMPOSE_OFF, gcPre_2271),
		new CompositionData (0x2274, COMPOSE_OFF, gcPre_2274),
		new CompositionData (0x2275, COMPOSE_OFF, gcPre_2275),
		new CompositionData (0x2278, COMPOSE_OFF, gcPre_2278),
		new CompositionData (0x2279, COMPOSE_OFF, gcPre_2279),
		new CompositionData (0x2280, COMPOSE_OFF, gcPre_2280),
		new CompositionData (0x2281, COMPOSE_OFF, gcPre_2281),
		new CompositionData (0x22E0, COMPOSE_OFF, gcPre_22E0),
		new CompositionData (0x22E1, COMPOSE_OFF, gcPre_22E1),
		new CompositionData (0x2284, COMPOSE_OFF, gcPre_2284),
		new CompositionData (0x2285, COMPOSE_OFF, gcPre_2285),
		new CompositionData (0x2288, COMPOSE_OFF, gcPre_2288),
		new CompositionData (0x2289, COMPOSE_OFF, gcPre_2289),
		new CompositionData (0x22E2, COMPOSE_OFF, gcPre_22E2),
		new CompositionData (0x22E3, COMPOSE_OFF, gcPre_22E3),
		new CompositionData (0x22AC, COMPOSE_OFF, gcPre_22AC),
		new CompositionData (0x22AD, COMPOSE_OFF, gcPre_22AD),
		new CompositionData (0x22AE, COMPOSE_OFF, gcPre_22AE),
		new CompositionData (0x22AF, COMPOSE_OFF, gcPre_22AF),
		new CompositionData (0x22EA, COMPOSE_OFF, gcPre_22EA),
		new CompositionData (0x22EB, COMPOSE_OFF, gcPre_22EB),
		new CompositionData (0x22EC, COMPOSE_OFF, gcPre_22EC),
		new CompositionData (0x22ED, COMPOSE_OFF, gcPre_22ED),
		new CompositionData (0x2ADC, COMPOSE_OFF, gcPre_2ADC),
		new CompositionData (0x3094, COMPOSE_ON , gcPre_3094),
		new CompositionData (0x304C, COMPOSE_ON , gcPre_304C),
		new CompositionData (0x304E, COMPOSE_ON , gcPre_304E),
		new CompositionData (0x3050, COMPOSE_ON , gcPre_3050),
		new CompositionData (0x3052, COMPOSE_ON , gcPre_3052),
		new CompositionData (0x3054, COMPOSE_ON , gcPre_3054),
		new CompositionData (0x3056, COMPOSE_ON , gcPre_3056),
		new CompositionData (0x3058, COMPOSE_ON , gcPre_3058),
		new CompositionData (0x305A, COMPOSE_ON , gcPre_305A),
		new CompositionData (0x305C, COMPOSE_ON , gcPre_305C),
		new CompositionData (0x305E, COMPOSE_ON , gcPre_305E),
		new CompositionData (0x3060, COMPOSE_ON , gcPre_3060),
		new CompositionData (0x3062, COMPOSE_ON , gcPre_3062),
		new CompositionData (0x3065, COMPOSE_ON , gcPre_3065),
		new CompositionData (0x3067, COMPOSE_ON , gcPre_3067),
		new CompositionData (0x3069, COMPOSE_ON , gcPre_3069),
		new CompositionData (0x3070, COMPOSE_ON , gcPre_3070),
		new CompositionData (0x3071, COMPOSE_ON , gcPre_3071),
		new CompositionData (0x3073, COMPOSE_ON , gcPre_3073),
		new CompositionData (0x3074, COMPOSE_ON , gcPre_3074),
		new CompositionData (0x3076, COMPOSE_ON , gcPre_3076),
		new CompositionData (0x3077, COMPOSE_ON , gcPre_3077),
		new CompositionData (0x3079, COMPOSE_ON , gcPre_3079),
		new CompositionData (0x307A, COMPOSE_ON , gcPre_307A),
		new CompositionData (0x307C, COMPOSE_ON , gcPre_307C),
		new CompositionData (0x307D, COMPOSE_ON , gcPre_307D),
		new CompositionData (0x309E, COMPOSE_ON , gcPre_309E),
		new CompositionData (0x30F4, COMPOSE_ON , gcPre_30F4),
		new CompositionData (0x30AC, COMPOSE_ON , gcPre_30AC),
		new CompositionData (0x30AE, COMPOSE_ON , gcPre_30AE),
		new CompositionData (0x30B0, COMPOSE_ON , gcPre_30B0),
		new CompositionData (0x30B2, COMPOSE_ON , gcPre_30B2),
		new CompositionData (0x30B4, COMPOSE_ON , gcPre_30B4),
		new CompositionData (0x30B6, COMPOSE_ON , gcPre_30B6),
		new CompositionData (0x30B8, COMPOSE_ON , gcPre_30B8),
		new CompositionData (0x30BA, COMPOSE_ON , gcPre_30BA),
		new CompositionData (0x30BC, COMPOSE_ON , gcPre_30BC),
		new CompositionData (0x30BE, COMPOSE_ON , gcPre_30BE),
		new CompositionData (0x30C0, COMPOSE_ON , gcPre_30C0),
		new CompositionData (0x30C2, COMPOSE_ON , gcPre_30C2),
		new CompositionData (0x30C5, COMPOSE_ON , gcPre_30C5),
		new CompositionData (0x30C7, COMPOSE_ON , gcPre_30C7),
		new CompositionData (0x30C9, COMPOSE_ON , gcPre_30C9),
		new CompositionData (0x30D0, COMPOSE_ON , gcPre_30D0),
		new CompositionData (0x30D1, COMPOSE_ON , gcPre_30D1),
		new CompositionData (0x30D3, COMPOSE_ON , gcPre_30D3),
		new CompositionData (0x30D4, COMPOSE_ON , gcPre_30D4),
		new CompositionData (0x30D6, COMPOSE_ON , gcPre_30D6),
		new CompositionData (0x30D7, COMPOSE_ON , gcPre_30D7),
		new CompositionData (0x30D9, COMPOSE_ON , gcPre_30D9),
		new CompositionData (0x30DA, COMPOSE_ON , gcPre_30DA),
		new CompositionData (0x30DC, COMPOSE_ON , gcPre_30DC),
		new CompositionData (0x30DD, COMPOSE_ON , gcPre_30DD),
		new CompositionData (0x30F7, COMPOSE_ON , gcPre_30F7),
		new CompositionData (0x30F8, COMPOSE_ON , gcPre_30F8),
		new CompositionData (0x30F9, COMPOSE_ON , gcPre_30F9),
		new CompositionData (0x30FA, COMPOSE_ON , gcPre_30FA),
		new CompositionData (0x30FE, COMPOSE_ON , gcPre_30FE),
		new CompositionData (0xFB2C, COMPOSE_OFF, gcPre_FB2C),
		new CompositionData (0xFB2D, COMPOSE_OFF, gcPre_FB2D),
		new CompositionData (0x1D15E, COMPOSE_OFF, gcPre_1D15E),
		new CompositionData (0x1D15F, COMPOSE_OFF, gcPre_1D15F),
		new CompositionData (0x1D160, COMPOSE_OFF, gcPre_1D160),
		new CompositionData (0x1D161, COMPOSE_OFF, gcPre_1D161),
		new CompositionData (0x1D162, COMPOSE_OFF, gcPre_1D162),
		new CompositionData (0x1D163, COMPOSE_OFF, gcPre_1D163),
		new CompositionData (0x1D164, COMPOSE_OFF, gcPre_1D164),
		new CompositionData (0x1D1BB, COMPOSE_OFF, gcPre_1D1BB),
		new CompositionData (0x1D1BC, COMPOSE_OFF, gcPre_1D1BC),
		new CompositionData (0x1D1BD, COMPOSE_OFF, gcPre_1D1BD),
		new CompositionData (0x1D1BF, COMPOSE_OFF, gcPre_1D1BF),
		new CompositionData (0x1D1BE, COMPOSE_OFF, gcPre_1D1BE),
		new CompositionData (0x1D1C0, COMPOSE_OFF, gcPre_1D1C0)
	};

	Composition (int[] pcSourceRun) {
		mpcSourceRun = pcSourceRun;
		mnSplit = pcSourceRun.length;
		mcPrecomposedChar = '\0';
		mbDoComposition = false;
	}

	int[] getSourceRun () {
		return mpcSourceRun;
	}

	int getLength () {
		return mnLength;
	}

	int getSplit () {
		return mnSplit;
	}

	int getPrecomposedChar () {
		return mcPrecomposedChar;
	}

	boolean doComposition () {
		return mbDoComposition;
	}

	boolean isValid () {
		return mnSplit > 1;
	}

	boolean reconcile () {
		while (mnSplit > 1) {
			CompositionData poComposition = lookupComposition (mpcSourceRun);
			if (poComposition != null) {
				int nData = poComposition.mnData;
				mcPrecomposedChar = precomposedChar (nData);
				mbDoComposition = needComposition (nData);
				return true;
			}
			mnSplit--;
		}

		mcPrecomposedChar = mpcSourceRun[0];
		mbDoComposition = false;

		return false;
	}

	boolean popCombiningMark () {
		mnSplit--;
		return reconcile();
	}

	private static CompositionData lookupComposition (int[] pcRun) {
		assert (pcRun.length > 0);

// Note: nMin is always inclusive; nMax is always just outside the range
// of indexes being tested.
		int nMin = 0;
		int nMax = goCompositionData.length;
		int	nRunLimit = pcRun.length;

		while (nMax > nMin) {
			int nMid = (nMin + nMax) >>> 1;
			CompositionData poTest = goCompositionData[nMid];
			int[] pcTest = poTest.mpcSequence;
			int nIter = 0;
			int nTestLimit = poTest.mpcSequence.length;
			boolean bLookInLastHalf = false;

			for (; ; ) {
				if (nIter == nRunLimit) {
					if (nIter == nTestLimit) {
						return poTest;
					}
					break;
				}

				if (nIter == nTestLimit) {
					bLookInLastHalf = true;
					break;
				}

				if (pcRun[nIter] < pcTest[nIter]) {
					break;
				}

				if (pcRun[nIter] > pcTest[nIter]) {
					bLookInLastHalf = true;
					break;
				}

				nIter++;
			}

			if (bLookInLastHalf) {
				nMin = nMid + 1;
			} else {
				nMax = nMid;
			}
		}

		return null;
	}

	private final static int precomposedChar (int nData) {
		return nData & 0xFFFFFF;
	}

	private final static boolean needComposition (int nData) {
		return (nData & COMPOSE_ON) != 0;
	}
}
