/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and may be covered by U.S. and Foreign Patents,
 * patents in process, and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.analytics.sitecatalyst.util;

import java.util.HashSet;

import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;

import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.io.JSONWriter;

import com.day.cq.commons.TidyJsonItemWriter;

public class SitecatalystJsonItemWriter extends TidyJsonItemWriter {
    
    public SitecatalystJsonItemWriter() {
        super(new HashSet<String>());
    }
    
    protected void dump(Node node, JSONWriter w, int currentRecursionLevel, int maxRecursionLevels) throws RepositoryException, JSONException {

        // check for array
        boolean isArray = true;
        NodeIterator children = node.getNodes();
        if(!children.hasNext()) { // has no children
            isArray = false;
        }
        while (children.hasNext()) {
            final Node n = children.nextNode();
            if(!n.getName().matches("\\d+")) {
                isArray = false;
                break;
            }
        }
        PropertyIterator props = node.getProperties();
        if (isArray && props.hasNext()) {
            // array should not have properties
            while (props.hasNext()) {
                Property prop = props.nextProperty();
                // ignore any jcr:* properties
                if (!prop.getName().matches("jcr:.+")) {
                    isArray = false;
                    break;
                }
            }
        }

        if (isArray) {
            w.array();
            // the child nodes
            if (recursionLevelActive(currentRecursionLevel, maxRecursionLevels)) {
                children = node.getNodes();
                while (children.hasNext()) {
                    final Node n = children.nextNode();
                    dump(n, w, currentRecursionLevel + 1, maxRecursionLevels);
                }
            }
            w.endArray();
        } else {
            w.object();
            props = node.getProperties();
            // the node's actual properties
            while (props.hasNext()) {
                Property prop = props.nextProperty();
                if (prop.getName().matches("jcr:.+")) { // ignore any jcr:* properties
                    continue;
                }
                if (prop.getName().matches("cq:.+")) { // ignore any cq:* properties
                    continue;
                }
                writeProperty(w, prop);
            }

            // the child nodes
            if (recursionLevelActive(currentRecursionLevel, maxRecursionLevels)) {
                children = node.getNodes();
                while (children.hasNext()) {
                    final Node n = children.nextNode();
                    dumpSingleNode(n, w, currentRecursionLevel, maxRecursionLevels);
                }
            }
            w.endObject();
        }

    }
}
