/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.commons.folderpreview;

import org.apache.sling.api.resource.Resource;


/**
 * Returns a preview resource associated with a folder item.  Returns null
 * if this provider is unable to handle the given folder item.
 */
public interface FolderPreviewResourceProvider {

    /**
     * Returns a preview resource iterator if this provider can handle the folder
     * in question.
     * @param folderChild folder child
     * @return preview resource
     */
    Resource getPreviewResource(Resource folderChild);
}
