/*
 * Copyright 1997-2010 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */

package com.day.cq.reporting;

import javax.jcr.RepositoryException;
import javax.jcr.Session;

/**
 * This interface represents a cache to be used for value resolving.
 */
public interface PathResolvingCache {

    /**
     * <p>Resolves the specified path to a text, using the resolver cache.</p>
     *
     * @param session The session to use for resolving the path
     * @param path The path to resolve
     * @param propertyName The property to use for resolving
     * @return The resolved value
     * @throws RepositoryException if resolving the path failed
     */
    String resolvePathToText(Session session, String path, String propertyName)
            throws RepositoryException;

}
