/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.search.facets;

import com.day.cq.search.Predicate;
import com.day.cq.search.facets.buckets.SimpleBucket;
import com.day.cq.search.facets.buckets.ValueRangeBucket;

/**
 * <code>Bucket</code> represents a single element of a search result
 * categorization. This could be a {@link SimpleBucket single value} or a
 * predefined {@link ValueRangeBucket value range}.
 */
public interface Bucket {

    /**
     * @return the number of items in this bucket.
     */
    long getCount();

    /**
     * @return the value for this bucket.
     */
    String getValue();

    /**
     * @return a predicate representing this bucket that can be used for a new search
     */
    Predicate getPredicate();
}
