/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.wcm.mobile.api.devicespecs;

import java.util.Map;

import org.apache.sling.api.SlingHttpServletRequest;

/** Query component for {@link DeviceSpecsQueryEngine}. This is not
 * 	meant to be used directly, it is used by {@link DeviceSpecsQueryEngine}
 * 	to try different matching strategies (services that implement
 * 	this interface) in the order of their descending service rankings
 */
public interface DeviceSpecsProvider {
	
	/** Return specs for device identified in supplied
	 * 	request, null if not found.
	 */
	public Map<String, String> getDeviceSpecs(SlingHttpServletRequest request) throws Exception;
}
