/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2017 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 *
 **************************************************************************/
package com.adobe.cq.sites.ui.designfield.datasources;

import com.adobe.granite.ui.components.Config;
import com.adobe.granite.ui.components.ExpressionHelper;
import com.adobe.granite.ui.components.ExpressionResolver;
import com.adobe.granite.ui.components.ds.DataSource;
import com.adobe.granite.ui.components.ds.SimpleDataSource;
import com.day.cq.search.QueryBuilder;
import com.day.cq.wcm.api.NameConstants;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.iterators.TransformIterator;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceWrapper;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import com.day.cq.search.Query;
import com.day.cq.search.PredicateGroup;
import com.day.cq.search.result.SearchResult;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

import javax.jcr.Session;
import javax.servlet.Servlet;
import java.util.HashMap;
import java.util.Map;

@Component(
        service = {Servlet.class},
        property = {
                "sling.servlet.resourceTypes=wcm/designer/gui/components/designfield/datasources/query",
                "sling.servlet.methods=GET"
        }
)
public class QueryDatasource extends SlingSafeMethodsServlet{

    @Reference
    ExpressionResolver expressionResolver;

    @Reference
    QueryBuilder queryBuilder;

    @Override
    public void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) {
        final String LEGACY_DESIGNS_LOCATION = "/etc/designs";
        final String DEFAULT_DESIGNS_LOCATION = "/libs/settings/wcm/designs";
        final String USER_DESIGNS_LOCATION = "/apps/settings/wcm/designs";

        final Resource currentResource = request.getResource();
        final Config cfg = new Config(currentResource.getChild(Config.DATASOURCE));
        final ExpressionHelper ex = new ExpressionHelper(expressionResolver, request);
        final ResourceResolver resourceResolver = request.getResourceResolver();

        final String itemRT = cfg.get("itemResourceType", String.class);
        final long offset = ex.get(cfg.get("offset", "0"), long.class);
        final long limit = ex.get(cfg.get("limit", "20"), long.class);

        final Map<String, String[]> parameterMap = new HashMap(request.getParameterMap());
        parameterMap.put("type", new String[]{NameConstants.NT_PAGE});
        parameterMap.put("group.1_path", new String[]{DEFAULT_DESIGNS_LOCATION});
        parameterMap.put("group.2_path", new String[]{USER_DESIGNS_LOCATION});
        if (resourceResolver.getResource(LEGACY_DESIGNS_LOCATION) != null) {
            parameterMap.put("group.3_path", new String[]{LEGACY_DESIGNS_LOCATION});
        }
        parameterMap.put("group.p.or", new String[]{"true"});

        final PredicateGroup predicates = PredicateGroup.create(parameterMap);

        final Query query = queryBuilder.createQuery(predicates, resourceResolver.adaptTo(Session.class));

        query.setStart(offset);
        query.setHitsPerPage(limit);

        final SearchResult result = query.getResult();

        @SuppressWarnings("unchecked")
        final DataSource ds = new SimpleDataSource(new TransformIterator(result.getResources(), new Transformer() {
            public Object transform(Object input) {
                Resource r = (Resource) input;

                return new ResourceWrapper(r) {
                    public String getResourceType() {
                        return itemRT;
                    }
                };
            }
        }));

        request.setAttribute(DataSource.class.getName(), ds);
    }
}
