/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2016 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 *
 **************************************************************************/
package com.adobe.cq.sites.ui.models.admin.security.permission;

import java.util.Collection;
import java.util.Collections;

import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.jcr.RepositoryException;
import javax.jcr.Session;

import com.day.cq.security.util.CqActions;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.RequestAttribute;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.apache.sling.models.annotations.injectorspecific.ValueMapValue;

/**
 * Representation of the User allowed actions. The actions can the current user perform on the given resource
 *
 * The access rights are associated with the resource provided via the item request parameter. We are not displaying the data of the current resource but from a given resource
 */
@Model(adaptables = SlingHttpServletRequest.class)
public final class UserAllowedActions {

    @Self
    private SlingHttpServletRequest slingRequest;

    @Inject
    private ResourceResolver resolver;

    @ValueMapValue(name = "class")
    private String classNames;

    private CqActions cqActions;

    private boolean aclEdit;

    @PostConstruct
    protected void initModel() throws RepositoryException {

        Session session = resolver.adaptTo(Session.class);

        String resourcePath = slingRequest.getParameter("item");

        if (StringUtils.isNotEmpty(resourcePath)) {
            // Does the user has acl read access
            if(((JackrabbitSession) session).hasPermission(resourcePath, JackrabbitSession.ACTION_READ_ACCESS_CONTROL)) {
                cqActions = new CqActions(session);

                Collection<String> principalAllowedActions = cqActions.getAllowedActions(resourcePath,  Collections.singleton(slingRequest.getUserPrincipal()));

                aclEdit = principalAllowedActions.contains("acl_edit");
            }
        }
    }

    /**
     * Can the user edit the acl of the resource
     *
     * @return
     */
    public boolean canEditAcl() {
        return aclEdit;
    }

    /**
     * Class names to be added to the given component
     *
     * @return
     */
    public String getClassNames() {
        return classNames;
    }
}
