/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2015 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/


package com.adobe.dam.print.ids;

import java.util.List;

import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.event.jobs.Job;

import com.day.cq.dam.api.Asset;

import aQute.bnd.annotation.ProviderType;

@ProviderType
public interface PrintService {
    
    /**
     * Creates a sling job for exporting pdf and indd rendition of asset if the print rendition exists
     *
     * @param master asset for which print mapping is already defined as a rendition
     * @param formats list of export formats
     * @return Instance of the created sling job
     * @throws PersistenceException - If there's an error persisting the job
     */
    Job createExportJob(Asset master, List<PrintFormat> formats) throws PersistenceException;

    /**
     * Creates a sling job for exporting jpg renditions of pages of template if the print rendition exists
     *
     * @param master asset for which print mapping is not yet defined
     * @return Instance of the created sling job
     * @throws PersistenceException - If there's an error persisting the job
     */
    Job createExportPagesJob(Asset master) throws PersistenceException;

    /**
     * Creates multiple assets corresponding to products using master asset 
     * 
     * @param products list of paths for commerce products
     * @param master asset for which print mapping is already defined as a rendition
     * @param parent parent resource where new assets are to be created
     * 
     * @return a list of assets created as a copy from master asset and correspoding product
     * @throws PersistenceException - If there's an error persisting the page
     */
    List<Asset> createPages(List<String> products, Asset master, Resource parent) throws PersistenceException;

    /**
     * Creates a brochure using multiple assets 
     *
     * @param name name of the page
     * @param pages ordered list of assets to be part of brochure
     * @param parent parent resource where new assets are to be created
     * @param mergedType Template or Catalog ?
     * @return a asset representing brochure
     * @throws PersistenceException - If there's an error persisting the catalog
     */
    Asset createCatalog(String name, List<Asset> pages, String mergedType, Resource parent) throws PersistenceException;
    /**
     * Creates a brochure using multiple assets
     * @param name name of the catalog
     * @param pages ordered list of assets to be part of brochure
     * @param parent parent resource where new assets are to be created
     * @return a asset representing brochure
     * @throws PersistenceException - If there's an error persisting the catalog
     */
    Asset createCatalog(String name, List<Asset> pages, Resource parent) throws PersistenceException;

}
