/*************************************************************************
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2020 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 **************************************************************************/

package com.adobe.granite.workflow.exec.filter;

import com.adobe.granite.workflow.exec.Workflow;

/**
 * The <code>WorkflowFilter</code> interface allows filter implementations
 * that can be used to filter specific <code>{@link com.adobe.granite.workflow.exec.Workflow}s</code>
 */

public interface WorkflowFilter {
    /**
     * This method returns <code>true</code> if the given <code>{@link Workflow}</code>
     * matches the filter criteria.
     *
     * @param workflow <code>{@link Workflow}</code> to check
     *
     * @return <code>true</code> if the given <code>{@link Workflow}</code>
     * matches the filter criteria.
     */
    boolean doInclude(Workflow workflow);
}
