/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2007 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */
package com.adobe.xfa.gfx;

import com.adobe.xfa.font.FontService;
import com.adobe.xfa.ut.CoordPair;
import com.adobe.xfa.ut.Rect;
import com.adobe.xfa.ut.UnitSpan;
// import com.adobe.xfa.ut.Storage;


/**
 * A base class to position, align, etc,
 * objects within a given environment.
 */
public abstract class GFXEnv {
	/**
	 * @exclude from published api.
	 */
	public static final int FIT_LEFT = 0x01;
	/**
	 * @exclude from published api.
	 */
	public static final int FIT_CENTRE = 0x02;
	/**
	 * @exclude from published api.
	 */
	public static final int FIT_RIGHT = 0x03;
	/**
	 * @exclude from published api.
	 */
	public static final int FIT_TOP = 0x04;
	/**
	 * @exclude from published api.
	 */
	public static final int FIT_MIDDLE = 0x08;
	/**
	 * @exclude from published api.
	 */
	public static final int FIT_BOTTOM = 0x0C;

	private static final int IC_ASKDRIVER = 0;
	private static final int IC_INTERACTIVE = 1;
	private static final int IC_NONINTERACTIVE = 2;

//	private GFXScroller mpoHorzScroller;
//	private GFXScroller mpoVertScroller;

	private final boolean mbEraseBg;

	private final GFXFillAttr moBackground;
	private boolean mbDefaultColours;
	//private boolean mbLookupPreferences;
	private boolean mbDisplayAsPages;

	private final boolean mbInfoEnv;
	private int mnInteractive;
	private boolean mbLegacyPositioning;

//	private boolean mbCaretShown;

//	private GFXDevInfo moDevInfoOverrideKludge;
//	private boolean mbDevInfoOverridden;

	private FontService mpoFontService;

//	private Storage moInvalidList;

//	private ExFull moPaintEx;

//	private GFXDevInfo moDevInfo;

	/**
	 * @exclude from published api.
	 */
	public GFXEnv (boolean bInfoEnv) {
		mbInfoEnv = bInfoEnv;
		mbEraseBg = true;
		moBackground = new GFXFillAttr (GFXFillAttr.WHITE_FILL);
		mbDefaultColours = true;
		//mbLookupPreferences = true;
		mnInteractive = IC_ASKDRIVER;
		mbDisplayAsPages = true;
	}

	/**
	 * @exclude from published api.
	 */
	public GFXEnv () {
		this (false);
	}

	/**
	 * @exclude from published api.
	 */
	public GFXFillAttr background () {
		return moBackground;
	}

	/**
	 * @exclude from published api.
	 */
	public void background (GFXFillAttr oBackground) {
		moBackground.copyFrom (oBackground);
	}

	/**
	 * @exclude from published api.
	 */
	public boolean defaultColours () {
		return mbDefaultColours;
	}

	/**
	 * @exclude from published api.
	 */
	public void defaultColours (boolean bDefaultColours) {
		mbDefaultColours = bDefaultColours;
	}

	/**
	 * @exclude from published api.
	 */
	public boolean draw3dEffects () {
		return driver().draw3dEffects();
	}

	/**
	 * @exclude from published api.
	 */
	public void draw3dEffects (boolean b3dEffects) {
		driver().draw3dEffects (b3dEffects);
	}

	/**
	 * @exclude from published api.
	 */
	public boolean displayAsPages () {
		return mbDisplayAsPages;
	}

	/**
	 * @exclude from published api.
	 */
	public void displayAsPages (boolean bDisplayAsPages) {
		mbDisplayAsPages = bDisplayAsPages;
	}

//	public GFXDevInfo DevInfo () {
//		GFXDriver poDriver = DriverAttach();
//		setDevInfo (poDriver.devInfo());
//		DriverDetach();
//
//		return getDevInfo();
//	}

//	public GFXDevInfo DevInfoOverrideKludge () {
//		if (mbDevInfoOverridden) {
//			return moDevInfoOverrideKludge;
//		} else {
//			return DevInfo();
//		}
//	}

//	public void DevInfoOverrideKludge (GFXDevInfo oOverride) {
//		moDevInfoOverrideKludge = oOverride;
//		mbDevInfoOverridden = true;
//	}

	/**
	 * @exclude from published api.
	 */
	public int devH (UnitSpan oHeight) {
		GFXDriver poDriver = validDriver();
		return poDriver.devH (oHeight);
	}

	/**
	 * @exclude from published api.
	 */
	public GFXDevPoint devPoint (CoordPair oPoint) {
		GFXDriver poDriver = validDriver();
		return poDriver.devPoint (oPoint);
	}

	/**
	 * @exclude from published api.
	 */
	public GFXDevRect devRect (Rect oRect) {
		GFXDriver poDriver = validDriver();
		return poDriver.devRect (oRect);
	}

	/**
	 * @exclude from published api.
	 */
	public int devW (UnitSpan oWidth) {
		GFXDriver poDriver = validDriver();
		return poDriver.devW (oWidth);
	}

	/**
	 * @exclude from published api.
	 */
	public int devX (UnitSpan oX) {
		GFXDriver poDriver = validDriver();
		return poDriver.devX (oX);
	}

	/**
	 * @exclude from published api.
	 */
	public int devY (UnitSpan oY) {
		GFXDriver poDriver = validDriver();
		return poDriver.devY (oY);
	}

	/**
	 * @exclude from published api.
	 */
	public GFXDriver driverAttach () {
		return validDriver();
	}

	/**
	 * Attach/create a driver instance to render the given model context in
	 * this view.
	 * <p>
	 * Attaching with different model contexts will likely produce different
	 * driver instances--instances that are aware of the co-ordinate spaces
	 * of their respective model contexts.
	 * </p>
	 * <p>
	 * The default implementation simply calls the existing overload of
	 * DriverAttach() that has no parameters.
	 * </p>
	 * @param poModelContext - Pointer to model context for the driver
	 * instance.
	 * @return Pointer to a driver instance the client can use to render the
	 * given model context in this view.
	 *
	 * @exclude from published api.
	 */
	public GFXDriver driverAttach (GFXModelContext poModelContext) {
		return driverAttach();
	}

	/**
	 * @exclude from published api.
	 */
	public void driverDetach () {
	}

	/**
	 * Detach/release a driver instance previously created to render the
	 * given model context in this view.
	 * <p>
	 * The default implementation simply calls the existing overload of
	 * DriverDetach() that has no parameters.
	 * @param poModelContext - Pointer to model context for the driver
	 * instance.
	 *
	 * @exclude from published api.
	 */
	public void driverDetach (GFXModelContext poModelContext) {
		driverDetach();
	}

	/**
	 * @exclude from published api.
	 */
	public boolean eraseBg () {
		return mbEraseBg;
	}

	/**
	 * @exclude from published api.
	 */
	public void fit (double dScale, CoordPair oOrigin, int nFit, boolean bInvalidate) {
		GFXDriver poDriver = driverAttach();

		//double dOldScale = poDriver.scale();

		poDriver.fit (dScale, oOrigin, nFit);
		driverDetach();
// If the scale has changed, inform the primary scroller so it can tell
// it's nested scrollers (and other multi-view objects) to resize and
// reposition themselves
//		if ((PrimaryVertScroller() != null) && (dScale != dOldScale)) {
//			GFXScrollingEnv poScrollEnv = PrimaryVertScroller().scrollingEnv();
//			if (poScrollEnv != null) {
//				poScrollEnv.scrollingObj().adjustObjects (this);
//			}
//		}
//		if (bInvalidate) {
//			InvalidateArea (VisibleArea());
//		}
	}

	/**
	 * @exclude from published api.
	 */
	public void fit (double dScale, CoordPair oOrigin, int nFit) {
		fit (dScale, oOrigin, nFit, false);
	}

	/**
	 * @exclude from published api.
	 */
	public void fitPage (Rect oPageRect) {
//		if (oPageRect.width().value() == 0 || oPageRect.height().value() == 0) {
//			JfExThrow (GFXENV_ERR_INVALID_FIT);
//		}

		GFXDriver poDriver = validDriver();
		UnitSpan oWidth = poDriver.widthInUnits();
		UnitSpan oHeight = poDriver.heightInUnits();

		double dScale = oWidth.divide (oPageRect.width());
		double dScaleY = oHeight.divide (oPageRect.height());
		if (dScaleY < dScale) {
			dScale = dScaleY;
		}

		fit (dScale, oPageRect.topLeft(), FIT_LEFT | FIT_TOP);
	}

	/**
	 * @exclude from published api.
	 */
	public void fitSides (UnitSpan oLeft, UnitSpan oRight, UnitSpan oY, int nFit) {
		UnitSpan oFitWidth = oRight.subtract (oLeft);
		if (oFitWidth.value() == 0) {
//			JfExThrow (GFXENV_ERR_INVALID_FIT);
		}

		GFXDriver poDriver = validDriver();
		UnitSpan oWidth = poDriver.widthInUnits();
		double dScale = oWidth.divide (oFitWidth);

		fit (dScale, new CoordPair (oLeft, oY), (nFit & 0x0C) | FIT_LEFT);
	}

	/**
	 * @exclude from published api.
	 */
	public FontService fontService () {
		return mpoFontService;
	}

	/**
	 * @exclude from published api.
	 */
	public void fontService (FontService poNewService) {
		mpoFontService = poNewService;
	}

	/**
	 * @exclude from published api.
	 */
	public GFXDriver getDriver () {
		return validDriver();
	}

	/**
	 * @exclude from published api.
	 */
	public int height () {
		GFXDriver poDriver = driverAttach();
		int lHeight = poDriver.height();
		driverDetach();

		return lHeight;
	}

	/**
	 * @exclude from published api.
	 */
	public UnitSpan heightInAbsUnits () {
		GFXDriver poDriver = driverAttach();
		UnitSpan oHeight = poDriver.heightInUnits();
		driverDetach();

		return oHeight;
	}

	/**
	 * @exclude from published api.
	 */
	public boolean infoEnv () {
		return mbInfoEnv;
	}

	/**
	 * @exclude from published api.
	 */
	public boolean interactive () {
		if (mnInteractive == IC_ASKDRIVER) {
			GFXDriver poDriver = driverAttach();
			boolean bInteractive = poDriver.interactive();
			driverDetach();

			mnInteractive = bInteractive ? IC_INTERACTIVE : IC_NONINTERACTIVE;
		}
		return (mnInteractive == IC_INTERACTIVE);
	}

	/**
	 * @exclude from published api.
	 */
	public void interactive (boolean bInteractive) {
		mnInteractive = bInteractive ? IC_INTERACTIVE : IC_NONINTERACTIVE;
	}

	/**
	 * @exclude from published api.
	 */
	public boolean legacyPositioning () {
		return mbLegacyPositioning;
	}

	/**
	 * @exclude from published api.
	 */
	public void legacyPositioning (boolean bLegacyPositioning) {
		mbLegacyPositioning = bLegacyPositioning;
	}

//	public void InvalidateArea (Rect oArea, boolean bEraseBg) {
//		if ((oArea.width().value() == 0) || (oArea.height().value() == 0)) {
//			return;
//		}
//
//		Rect oNewRect = oArea;
//		boolean bNewEraseBg = bEraseBg;
//		GFXInvalidArea poArea;
//
//		for (int i = 0; i < moInvalidList.size(); i++) {
//			poArea = moInvalidList[i];
//
//			if (poArea.area().contains (oNewRect)) {
//				if (bNewEraseBg && ! poArea.eraseBg()) {
//					poArea.eraseBg (true);
//				}
//				return;
//			}
//			if (oNewRect.contains (poArea.area())) {
//				if (poArea.eraseBg() && ! bNewEraseBg) {
//					bNewEraseBg = true;
//				}
//				moInvalidList.remove (i);
//				delete poArea;
//				i--;
//			} else if (poArea.area().overlaps (oNewRect)) {
//				oNewRect |= poArea.area();
//				if (poArea.eraseBg() != bNewEraseBg) {
//					bNewEraseBg = true;
//				}
//				moInvalidList.remove (i);
//				delete poArea;
//				i = -1; // restart
//			}
//		}
//
//		moInvalidList.append (new GFXInvalidArea (oNewRect, bNewEraseBg));
//	}

	/**
	 * Invalidate some part of a given model context in this view.
	 * <p>
	 * The default implementation simply calls the existing overload of
	 * InvalidateArea() that is not model context aware.
	 * @param poModelContext - Pointer to model context for the driver
	 * instance.
	 * @param oInvalidArea - Rectangular area to invalidate.  This will be
	 * in the co-ordinate space of the given model context.
	 * @param bEraseBG - True if the background is to be erased first; false
	 * if not.
	  *
	 * @exclude from published api.
	 */
	public void invalidateArea (GFXModelContext poModelContext, Rect oInvalidArea, boolean bEraseBG) {
//		InvalidateArea (oInvalidArea, bEraseBG);
	}

//	public boolean LookupPreferences () {
//		return mbLookupPreferences;
//	}

//	public void LookupPreferences (boolean bLookupPreferences) {
//		mbLookupPreferences = bLookupPreferences;
//	}

//	public boolean PaintExceptions (ExFull oPaintEx) {
//		oPaintEx = moPaintEx;
//
//		return (moPaintEx.count() > 0);
//	}

//	public void PaintExceptionsClear () {
//		moPaintEx = ExFull();
//	}

//	public GFXScroller PrimaryHorzScroller () {
//		return mpoHorzScroller;
//	}

//	public void PrimaryHorzScroller (GFXScroller poScroller) {
//		mpoHorzScroller = poScroller;
//	}

//	public GFXScroller PrimaryVertScroller () {
//		return mpoVertScroller;
//	}

//	public void PrimaryVertScroller (GFXScroller poScroller) {
//		mpoVertScroller = poScroller;
//	}

	/**
	 * @exclude from published api.
	 */
	public void refresh () {
//		GFXDriver poDriver = ValidDriver();
//		poDriver.cacheRemoveAll();
	}

	/**
	 * @exclude from published api.
	 */
	public double scale () {
		GFXDriver poDriver = validDriver();
		return poDriver.scale();
	}

	/**
	 * @exclude from published api.
	 */
	public UnitSpan unitH (int lHeight) {
		GFXDriver poDriver = validDriver();
		return poDriver.unitH (lHeight);
	}

	/**
	 * @exclude from published api.
	 */
	public CoordPair unitPoint (int lX, int lY) {
		GFXDriver poDriver = validDriver();
		return poDriver.unitPoint (lX, lY);
	}

	/**
	 * @exclude from published api.
	 */
	public Rect unitRect (int lLeft, int lTop, int lRight, int lBottom) {
		GFXDriver poDriver = validDriver();
		return poDriver.unitRect (lLeft, lTop, lRight, lBottom);
	}

	/**
	 * @exclude from published api.
	 */
	public UnitSpan unitW (int lWidth) {
		GFXDriver poDriver = validDriver();
		return poDriver.unitW (lWidth);
	}

	/**
	 * @exclude from published api.
	 */
	public UnitSpan unitX (int lX) {
		GFXDriver poDriver = validDriver();
		return poDriver.unitX (lX);
	}

	/**
	 * @exclude from published api.
	 */
	public UnitSpan unitY (int lY) {
		GFXDriver poDriver = validDriver();
		return poDriver.unitY (lY);
	}

	/**
	 * @exclude from published api.
	 */
	public Rect visibleArea () {
		GFXDriver poDriver = driverAttach();
		Rect oVisibleArea = poDriver.visibleArea();
		driverDetach();

		return oVisibleArea;
	}

	/**
	 * @exclude from published api.
	 */
	public int width () {
		GFXDriver poDriver = driverAttach();
		int lWidth = poDriver.width();
		driverDetach();

		return lWidth;
	}

	/**
	 * @exclude from published api.
	 */
	public UnitSpan widthInAbsUnits () {
		GFXDriver poDriver = driverAttach();
		UnitSpan oWidth = poDriver.widthInUnits();
		driverDetach();

		return oWidth;
	}

//	public void WindowCaretHide () {
//		if (Interactive()) {
//			ValidDriver().caretHide();
//			mbCaretShown = false;
//		}
//	}

//	public boolean WindowCaretIsVisible () {
//		if (Interactive()) {
//			return ValidDriver().caretIsVisible();
//		} else {
//			return false;
//		}
//	}

//	public void WindowCaretMove (CoordPair oPosition) {
//		if (Interactive()) {
//			ValidDriver().caretMove (oPosition);
//		}
//	}

//	public void WindowCaretRestore () {
//		if (mbCaretShown) {
//			WindowCaretShow();
//		} else {
//			WindowCaretHide();
//		}
//	}

//	public void WindowCaretSet (CoordPair oPosition, UnitSpan oWidth, UnitSpan oHeight) {
//		if (Interactive()) {
//			GFXDriver poDriver = ValidDriver();
//			poDriver.caretSize (oWidth, oHeight);
//			poDriver.caretMove (oPosition);
//		}
//	}

//	public void WindowCaretShow () {
//		if (Interactive()) {
//			ValidDriver().caretShow();
//			mbCaretShown = true;
//		}
//	}

//	public void WindowCaretSize (UnitSpan oWidth, UnitSpan oHeight) {
//		if (Interactive()) {
//			ValidDriver().caretSize (oWidth, oHeight);
//		}
//	}

//	public CoordPair WindowCaretPosition () {
//		return ValidDriver().caretPosition();
//	}

//	public UnitSpan WindowCaretWidth () {
//		return ValidDriver().caretWidth();
//	}

//	public UnitSpan WindowCaretHeight () {
//		return ValidDriver().caretHeight();
//	}

//	public void WindowFocus (boolean bFocus) {
//		ValidDriver().focus (bFocus);
//	}

//	public void WindowPaint () {
//		WindowPaint (VisibleArea());
//	}

//	public void WindowPaint (Rect oPaintArea) {
//		InvalidateArea (oPaintArea);
//		PaintInvalidAreas();
//	}

//	public void WindowResolutionChanged () {
//		ValidDriver().resolutionChanged();
//	}

//	public void WindowUpdate () {
//		PaintInvalidAreas();
//	}

//	public void WindowTimer () {
//		;
//	}

	/**
	 * @exclude from published api.
	 */
	public GFXDriver validDriver () {
		GFXDriver poDriver = driver();
//		if (poDriver == null) {
//			JfExThrow (GFXENV_ERR_NO_DRIVER);
//		}
// TODO: set env in driver?
		return poDriver;
	}

	/**
	 * @exclude from published api.
	 */
	protected abstract GFXDriver driver ();

//	private void PaintInvalidAreas () {
//
//// Check if the visible area has expanded.	If so, adjust all the scrolling
//// objects in the visible area.
//		Rect oVisibleArea (VisibleArea());
//
//		if (! moVisibleArea.contains (oVisibleArea) && PrimaryVertScroller() != null) {
//			GFXScrollingEnv poScrollEnv = PrimaryVertScroller().scrollingEnv();
//
//// All the multi-view objects which have just come into view need to
//// be adjusted.
//			if (poScrollEnv != null) {
//				poScrollEnv.scrollingObj().adjustObjects (this, moVisibleArea, oVisibleArea);
//			}
//		}
//		moVisibleArea = oVisibleArea;
//	}

// Get the variables to allow the return of a const local variable.
//	private GFXDevInfo getDevInfo () {
//		return moDevInfo;
//	}

//	private void setDevInfo (GFXDevInfo oGDevInfo) {
//		moDevInfo = oGDevInfo;
//	}
}
