/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2005 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */
package com.adobe.xfa.template;

import com.adobe.xfa.Attribute;
import com.adobe.xfa.Bool;
import com.adobe.xfa.Element;
import com.adobe.xfa.EnumAttr;
import com.adobe.xfa.EnumValue;
import com.adobe.xfa.Node;
import com.adobe.xfa.ProtoableNode;
import com.adobe.xfa.STRS;
import com.adobe.xfa.StringAttr;
import com.adobe.xfa.XFA;
import com.adobe.xfa.content.Content;
import com.adobe.xfa.template.containers.Draw;
import com.adobe.xfa.template.containers.Field;
import com.adobe.xfa.template.ui.UI;

/**
 * This class implements the functionality of the <value> element in the XFA
 * grammar.
 *
 * @exclude from published api -- Mike Tardif, May 2006.
 */

public final class Value extends ProtoableNode {

	public Value(Element parent, Node prevSibling) {
		super(parent, prevSibling, null, XFA.VALUE, XFA.VALUE, null, XFA.VALUETAG, XFA.VALUE);
	}

	public int defaultElement() {
		// ask the parent for the defualt element for value
		Element pParent = getXFAParent();

		// if we are a field or a draw get the UI
		if (pParent instanceof Field || pParent instanceof Draw) {
			UI pUI = (UI) pParent.getElement(XFA.UITAG, true, 0, false, false);

			// return the correct defualt based on the UI
			if (pUI != null) {
				Element pUIElement = pUI.getUIElement(true);
				if (pUIElement != null) {
					int eTag = pUIElement.getClassTag();
					switch (eTag) {
					case XFA.NUMERICEDITTAG:
						return XFA.FLOATTAG; // could also be INTEGER or
					// DECIMAL
					case XFA.DATETIMEEDITTAG:
						return XFA.DATETIMETAG;
					case XFA.IMAGEEDITTAG:
						return XFA.IMAGETAG;
					case XFA.TEXTEDITTAG: {
						boolean bRichText = Bool.getValue((EnumValue) pUIElement
								.getAttribute(XFA.ALLOWRICHTEXTTAG));
						if (bRichText)
							return XFA.EXDATATAG;
						break;
					}
					case XFA.CHOICELISTTAG: {
						// default value for a multi select node is an exdata
						// node
						int eValue = pUIElement.getEnum(XFA.OPENTAG);

						if (eValue == EnumAttr.MULTISELECT)
							return XFA.EXDATATAG;
						break;
					}
					// else default to TEXT
					}
				}
			}
		}
		return XFA.TEXTTAG;
	}

	/**
	 * @see Element#defaultElementImpl(int, int, boolean)
	 * @exclude from published api.
	 */
	protected Node defaultElementImpl(int eTag, int nOccurrence, boolean bAppend /* = true */) {

		if (eTag == XFA.SCHEMA_DEFAULTTAG)
			eTag = defaultElement();
		
		if (eTag == XFA.SCHEMA_DEFAULTTAG)
			return null;
		
		Node node = super.defaultElementImpl(eTag, nOccurrence, bAppend);

		if (node != null) {
			Content content = (Content)node;
	
			// set default content type
			if (eTag == XFA.EXDATATAG) {
				StringAttr sTextHtml = new StringAttr(XFA.CONTENTTYPE, STRS.TEXTHTML);
				content.setAttribute(sTextHtml, XFA.CONTENTTYPETAG);
			}
	
			content.setIsNull(true, false, false);
		}
		return node;
	}

	/**
	 * @exclude from published api.
	 */
	public Element replaceContent(int eTag) {
		Attribute oMaxChars = null;
		Node oOneOf = getOneOfChild(true, false);
		if (oOneOf != null) {
			if (oOneOf.isSameClass(XFA.TEXTTAG))
				oMaxChars = ((Element)oOneOf).getAttribute(XFA.MAXCHARSTAG, true, false);
			else if (oOneOf.isSameClass(XFA.EXDATATAG))
				oMaxChars = ((Element)oOneOf).getAttribute(XFA.MAXLENGTHTAG, true, false);
		}
		// watson bug 1780370, make sure we copy over the max len property. 
		Element oNewNode = getModel().createElement(eTag, null);
		if (oMaxChars != null && oNewNode != null) 	{
			if (oNewNode.isSameClass(XFA.TEXTTAG))
				oNewNode.setAttribute(oMaxChars, XFA.MAXCHARSTAG);
			else if (oNewNode.isSameClass(XFA.EXDATATAG))
				oNewNode.setAttribute(oMaxChars, XFA.MAXLENGTHTAG);
			
		}
		setOneOfChild(oNewNode);
		
		return oNewNode;
	}

}
