/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 1994 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 *
 * @author Richard Devitt
 */

package com.adobe.xfa.ut;

import java.util.ArrayList;
import java.util.List;

/**
 * This class stores a multi-part key in such as way as to allow instances 
 * of the class to be included in HashMaps.
 * 
 * @exclude from published api. 
 */
public final class Key {

	private final List<String> mKeyValues;
	

	public Key() {
		mKeyValues = new ArrayList<String>();
	}
	
	public Key(int initialCapacity) {
		mKeyValues = new ArrayList<String>(initialCapacity);
	}
	
	public Key(List<String> keyValues) {
		mKeyValues = new ArrayList<String>(keyValues);
	}
	
	public int numValues() {
		return mKeyValues.size();
	}
	
	public String value(int index) {
		return mKeyValues.get(index);
	}
	
	public void appendValue(String aValue) {
		mKeyValues.add(aValue);
	}
	
	public boolean equals(Object o) {
		if (o == this)
			return true;
		
		if (o == null)
			return false;
		
		if (o.getClass() != Key.class)
			return false;
		
		Key key = (Key)o;
		
		if (key.mKeyValues.size() != mKeyValues.size())
			return false;
		
		// JavaPort: This implementation doesn't require entries to be interned.
		for (int i = 0; i < mKeyValues.size(); i++)
			if (!key.mKeyValues.get(i).equals(mKeyValues.get(i)))
				return false;
		
		return true;
	}
	
	public int hashCode() {
		int hash = 0;
		
		for (int i = 0; i < mKeyValues.size(); i++)
			hash ^= mKeyValues.get(i).hashCode();
		
		return hash;
	}
}
