/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and may be covered by U.S. and Foreign Patents,
 * patents in process, and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.analytics.sitecatalyst;

import org.apache.sling.api.resource.Resource;
import org.osgi.annotation.versioning.ProviderType;


/**
 * The {@link AnalyticsPageNameResolver} service can be used to generate the 
 * Analytics pageName based on {@link Framework} mappings or other context data.
 * It's mostly used by back-end processes that need the pageName to run reports 
 * against Analytics. 
 */
@ProviderType
public interface AnalyticsPageNameResolver {
    /**
     * Called when pageName for a resource is requested. See
     * {@link AnalyticsPageNameProvider} for providing your own pageName
     * resolution
     * 
     * @param context
     *            the resolution {@link AnalyticsPageNameContext}
     * @return {@code null} or the generated pageName
     */
    public String getPageName(AnalyticsPageNameContext context);
    
    /**
     * Called when the {@link Resource} for a given pageName is requested. See
     * {@link AnalyticsPageNameProvider} for providing your own pageName
     * resolution
     * 
     * @param context
     *            the resolution {@link AnalyticsPageNameContext}
     * @return {@code null} or the resource that matches the pageName provided via
     *         {@link AnalyticsPageNameContext}
     */
    public Resource getResource(AnalyticsPageNameContext context);
}
